/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.commands;

import com.legacy.structure_gel.core.commands.BuildingToolCommand;
import com.legacy.structure_gel.core.commands.DebugCommand;
import com.legacy.structure_gel.core.commands.DistanceCommand;
import com.legacy.structure_gel.core.commands.GetBiomesCommand;
import com.legacy.structure_gel.core.commands.GetFeaturesCommand;
import com.legacy.structure_gel.core.commands.GetSpawnsCommand;
import com.legacy.structure_gel.core.commands.GetStructuresCommand;
import com.legacy.structure_gel.core.commands.NightVisionCommand;
import com.legacy.structure_gel.core.commands.SaveStructuresCommand;
import com.legacy.structure_gel.core.commands.ViewBoundsCommand;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.block.state.properties.StructureMode;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

public class StructureGelCommand {
    private static final DynamicCommandExceptionType INVALID_KEY = new DynamicCommandExceptionType(obj -> Component.literal((String)(String.valueOf(obj) + " is not valid in registry.")));

    public static <T> CompletableFuture<Suggestions> suggestFromRegistry(CommandContext<CommandSourceStack> context, SuggestionsBuilder builder, ResourceKey<Registry<T>> registry) {
        ((Registry)((CommandSourceStack)context.getSource()).registryAccess().lookup(registry).get()).keySet().stream().map(ResourceLocation::toString).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder command = Commands.literal((String)"structure_gel");
        command.then(DebugCommand.get());
        LiteralArgumentBuilder help = (LiteralArgumentBuilder)Commands.literal((String)"?").executes(context -> {
            ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)"Explains the basic function of a command").withStyle(ChatFormatting.GRAY), false);
            return 1;
        });
        command.then((ArgumentBuilder)help);
        StructureGelCommand.addChild((LiteralArgumentBuilder<CommandSourceStack>)command, SaveStructuresCommand.get(), Component.literal((String)"Runs the Save operation on Structure Blocks in the area or found in the search"));
        StructureGelCommand.addChild((LiteralArgumentBuilder<CommandSourceStack>)command, GetSpawnsCommand.get(), Component.literal((String)"Gets the mob spawns in the current location"));
        StructureGelCommand.addChild((LiteralArgumentBuilder<CommandSourceStack>)command, GetStructuresCommand.get(), Component.literal((String)"Gets the structures that can generate in the provided biome, or the current one you're in"));
        StructureGelCommand.addChild((LiteralArgumentBuilder<CommandSourceStack>)command, GetBiomesCommand.get(), Component.literal((String)"Gets the biomes that a structure can generate in"));
        StructureGelCommand.addChild((LiteralArgumentBuilder<CommandSourceStack>)command, ViewBoundsCommand.get(), Component.literal((String)"Sends structure bounding boxes to the client. The white box is the full bounds of the structure, while colored boxes are individual pieces"));
        StructureGelCommand.addChild((LiteralArgumentBuilder<CommandSourceStack>)command, BuildingToolCommand.get(), Component.literal((String)"Allows handling specific building tool actions and managing building tool data"));
        StructureGelCommand.addChild((LiteralArgumentBuilder<CommandSourceStack>)command, DistanceCommand.get(), Component.empty().append((Component)Component.literal((String)"You should only run this command in testing worlds.").withStyle(ChatFormatting.RED)).append((Component)Component.literal((String)"\nSelects random positions in the world, locates the nearest structure, and reports the average distance. Larger sample sizes provide more accurate results.")));
        StructureGelCommand.addChild((LiteralArgumentBuilder<CommandSourceStack>)command, GetFeaturesCommand.get(), Component.literal((String)"Gets the features that can generate in the provided biome, or the current one you're in"));
        StructureGelCommand.addChild((LiteralArgumentBuilder<CommandSourceStack>)command, NightVisionCommand.get(), Component.literal((String)"Shorthand to toggle night vision"));
        dispatcher.register(command);
    }

    public static LiteralArgumentBuilder<CommandSourceStack> addChild(LiteralArgumentBuilder<CommandSourceStack> parent, LiteralArgumentBuilder<CommandSourceStack> child, @Nullable MutableComponent childHelp) {
        if (childHelp != null) {
            parent.then(Commands.literal((String)"?").then(((LiteralArgumentBuilder)Commands.literal((String)child.getLiteral()).requires(child.getRequirement())).executes(context -> {
                ((CommandSourceStack)context.getSource()).sendSuccess(() -> childHelp.withStyle(ChatFormatting.GRAY), false);
                return 1;
            })));
        }
        parent.then(child);
        return parent;
    }

    public static <T> Holder<T> getResourceKeyHolder(CommandContext<CommandSourceStack> context, ResourceKey<Registry<T>> registryKey, String arg) throws CommandSyntaxException {
        ResourceKey rawKey = (ResourceKey)context.getArgument(arg, ResourceKey.class);
        ResourceKey key = (ResourceKey)rawKey.cast(registryKey).orElseThrow(() -> INVALID_KEY.create((Object)rawKey));
        return (Holder)((CommandSourceStack)context.getSource()).getServer().registryAccess().lookupOrThrow(registryKey).get(key).orElseThrow(() -> INVALID_KEY.create((Object)key));
    }

    public static Map<BlockPos, StructureBlockEntity> findStructureBlocks(ServerLevel level, BlockPos origin, int radius) {
        Map<BlockPos, StructureBlockEntity> structureBlocks = StructureGelCommand.findStructureBlocks(level, origin, radius, new LinkedHashMap<BlockPos, StructureBlockEntity>());
        StructureGelCommand.displayStructureBlockParticles(level, structureBlocks);
        return structureBlocks;
    }

    private static Map<BlockPos, StructureBlockEntity> findStructureBlocks(ServerLevel level, BlockPos origin, int radius, Map<BlockPos, StructureBlockEntity> structureBlocks) {
        ChunkPos originChunk = new ChunkPos(origin);
        int cRadius = radius / 16 + 1;
        for (int cx = -cRadius; cx <= cRadius; ++cx) {
            for (int cz = -cRadius; cz <= cRadius; ++cz) {
                for (BlockPos pos : level.getChunk(originChunk.x + cx, originChunk.z + cz).getBlockEntitiesPos()) {
                    StructureBlockEntity structureBlock;
                    BlockEntity blockEntity;
                    if (!StructureGelCommand.inSquareRadius(origin, pos, radius) || !((blockEntity = level.getBlockEntity(pos)) instanceof StructureBlockEntity) || (structureBlock = (StructureBlockEntity)blockEntity).getMode() != StructureMode.SAVE || structureBlocks.put(pos, structureBlock) != null) continue;
                    StructureGelCommand.findStructureBlocks(level, pos, radius, structureBlocks);
                }
            }
        }
        return structureBlocks;
    }

    public static Map<BlockPos, StructureBlockEntity> findStructureBlocks(ServerLevel level, BoundingBox area) {
        LinkedHashMap<BlockPos, StructureBlockEntity> structureBlocks = new LinkedHashMap<BlockPos, StructureBlockEntity>();
        for (BlockPos pos : BlockPos.betweenClosed((int)area.minX(), (int)area.minY(), (int)area.minZ(), (int)area.maxX(), (int)area.maxY(), (int)area.maxZ())) {
            StructureBlockEntity structureBlock;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (!(blockEntity instanceof StructureBlockEntity) || (structureBlock = (StructureBlockEntity)blockEntity).getMode() != StructureMode.SAVE) continue;
            structureBlocks.put(pos, structureBlock);
        }
        StructureGelCommand.displayStructureBlockParticles(level, structureBlocks);
        return structureBlocks;
    }

    private static void displayStructureBlockParticles(ServerLevel level, Map<BlockPos, StructureBlockEntity> structureBlocks) {
        for (ServerPlayer player : level.players()) {
            for (Map.Entry<BlockPos, StructureBlockEntity> entry : structureBlocks.entrySet()) {
                BlockPos above = entry.getKey().above();
                if (!level.getBlockState(above).isAir()) continue;
                level.sendParticles(player, (ParticleOptions)new BlockParticleOption(ParticleTypes.BLOCK_MARKER, Blocks.REDSTONE_TORCH.defaultBlockState()), true, true, (double)above.getX() + 0.5, (double)above.getY() + 0.5, (double)above.getZ() + 0.5, 1, 0.0, 0.0, 0.0, 0.0);
            }
        }
    }

    private static boolean inSquareRadius(BlockPos a, BlockPos b, int r) {
        return Math.abs(a.getX() - b.getX()) <= r && Math.abs(a.getY() - b.getY()) <= r && Math.abs(a.getZ() - b.getZ()) <= r;
    }
}

