/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.data.generators;

import com.legacy.structure_gel.core.block.DataHandlerBlock;
import com.legacy.structure_gel.core.client.item_model_properties.BuildingToolModeProperty;
import com.legacy.structure_gel.core.client.item_model_properties.StructureModeProperty;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolModes;
import com.legacy.structure_gel.core.registry.SGRegistry;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.client.data.models.BlockModelGenerators;
import net.minecraft.client.data.models.ItemModelGenerators;
import net.minecraft.client.data.models.ItemModelOutput;
import net.minecraft.client.data.models.ModelProvider;
import net.minecraft.client.data.models.blockstates.BlockStateGenerator;
import net.minecraft.client.data.models.blockstates.MultiVariantGenerator;
import net.minecraft.client.data.models.blockstates.PropertyDispatch;
import net.minecraft.client.data.models.blockstates.Variant;
import net.minecraft.client.data.models.blockstates.VariantProperties;
import net.minecraft.client.data.models.model.ItemModelUtils;
import net.minecraft.client.data.models.model.ModelInstance;
import net.minecraft.client.data.models.model.ModelLocationUtils;
import net.minecraft.client.data.models.model.ModelTemplate;
import net.minecraft.client.data.models.model.ModelTemplates;
import net.minecraft.client.data.models.model.TextureMapping;
import net.minecraft.client.data.models.model.TextureSlot;
import net.minecraft.client.data.models.model.TexturedModel;
import net.minecraft.client.renderer.item.BlockModelWrapper;
import net.minecraft.client.renderer.item.ItemModel;
import net.minecraft.client.renderer.item.SelectItemModel;
import net.minecraft.client.renderer.item.properties.select.SelectItemModelProperty;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StructureMode;

public class SGModelProvider
extends ModelProvider {
    public SGModelProvider(PackOutput output) {
        super(output, "structure_gel");
    }

    protected void registerModels(BlockModelGenerators blockModels, ItemModelGenerators itemModels) {
        new ItemProv(itemModels.itemModelOutput, itemModels.modelOutput).run();
        new StateProv(blockModels.blockStateOutput, blockModels.itemModelOutput, blockModels.modelOutput).run();
    }

    private static ModelTemplate parent(String name) {
        return ModelTemplates.create((String)name, (TextureSlot[])new TextureSlot[0]);
    }

    private static class ItemProv
    extends ItemModelGenerators {
        public ItemProv(ItemModelOutput itemOutput, BiConsumer<ResourceLocation, ModelInstance> models) {
            super(itemOutput, models);
        }

        public void run() {
            this.basicItem((Item)SGRegistry.Items.BLOCK_PALETTE.get());
            this.buildingTool((Item)SGRegistry.Items.BUILDING_TOOL.get());
        }

        private void basicItem(Item item) {
            this.generateFlatItem(item, ModelTemplates.FLAT_ITEM);
        }

        private void buildingTool(Item item) {
            HashMap modelsForMode = new HashMap();
            ArrayList modeSwitch = new ArrayList();
            BuildingToolModes.REGISTRY.forEach((key, mode) -> {
                ItemModel.Unbaked modeModel = ItemModelUtils.plainModel((ResourceLocation)this.createFlatItemModel(item, "_" + key.getPath(), ModelTemplates.FLAT_HANDHELD_ITEM));
                modelsForMode.put(mode, modeModel);
                modeSwitch.add(ItemModelUtils.when((Object)mode, (ItemModel.Unbaked)modeModel));
            });
            this.itemModelOutput.accept(item, ItemModelUtils.select((SelectItemModelProperty)new BuildingToolModeProperty(), (ItemModel.Unbaked)((ItemModel.Unbaked)modelsForMode.get(BuildingToolModes.NONE)), modeSwitch));
        }
    }

    private static class StateProv
    extends BlockModelGenerators {
        public StateProv(Consumer<BlockStateGenerator> blockOutput, ItemModelOutput itemOutput, BiConsumer<ResourceLocation, ModelInstance> models) {
            super(blockOutput, itemOutput, models);
        }

        public void run() {
            this.createGel((Block)SGRegistry.Blocks.GEL_SPREADER.get());
            this.createGel((Block)SGRegistry.Blocks.RED_GEL.get());
            this.createGel((Block)SGRegistry.Blocks.BLUE_GEL.get());
            this.createGel((Block)SGRegistry.Blocks.GREEN_GEL.get());
            this.createGel((Block)SGRegistry.Blocks.CYAN_GEL.get());
            this.createGel((Block)SGRegistry.Blocks.ORANGE_GEL.get());
            this.createGel((Block)SGRegistry.Blocks.YELLOW_GEL.get());
            this.dataHandler((Block)SGRegistry.Blocks.DATA_HANDLER.get());
            this.dynamicSpawner((Block)SGRegistry.Blocks.DYNAMIC_SPAWNER.get());
            this.structureBlock(Blocks.STRUCTURE_BLOCK);
        }

        public void createGel(Block block) {
            this.simpleBlock(block, "translucent");
        }

        public void simpleBlock(Block block, @Nullable String renderType) {
            this.createTrivialBlock(block, renderType != null ? TexturedModel.createDefault(TextureMapping::cube, (ModelTemplate)ModelTemplates.CUBE_ALL.extend().renderType(ResourceLocation.parse((String)renderType)).build()) : TexturedModel.CUBE);
        }

        private void dataHandler(Block block) {
            ResourceLocation frontTex = TextureMapping.getBlockTexture((Block)block, (String)"_front");
            ResourceLocation backTex = TextureMapping.getBlockTexture((Block)block, (String)"_back");
            ResourceLocation sideTex = TextureMapping.getBlockTexture((Block)block, (String)"_side");
            TextureMapping texturemapping = new TextureMapping().put(TextureSlot.DOWN, sideTex).put(TextureSlot.WEST, sideTex).put(TextureSlot.EAST, sideTex).put(TextureSlot.PARTICLE, frontTex).put(TextureSlot.NORTH, frontTex).put(TextureSlot.SOUTH, backTex).put(TextureSlot.UP, sideTex);
            ResourceLocation model = ModelTemplates.CUBE_DIRECTIONAL.create(block, texturemapping, this.modelOutput);
            ResourceLocation frontClearTex = frontTex.withSuffix("_clear");
            ResourceLocation backClearTex = backTex.withSuffix("_clear");
            ResourceLocation sideClearTex = sideTex.withSuffix("_clear");
            TextureMapping clearTexturemapping = new TextureMapping().put(TextureSlot.DOWN, sideClearTex).put(TextureSlot.WEST, sideClearTex).put(TextureSlot.EAST, sideClearTex).put(TextureSlot.PARTICLE, frontClearTex).put(TextureSlot.NORTH, frontClearTex).put(TextureSlot.SOUTH, backClearTex).put(TextureSlot.UP, sideClearTex);
            ResourceLocation clearModel = ModelTemplates.CUBE_DIRECTIONAL.extend().renderType("translucent").build().createWithSuffix(block, "_clear", clearTexturemapping, this.modelOutput);
            this.blockStateOutput.accept(MultiVariantGenerator.multiVariant((Block)block).with(PropertyDispatch.properties(DataHandlerBlock.FACING, (Property)DataHandlerBlock.WATERLOGGED).generate((dir, waterlogged) -> {
                ResourceLocation m = waterlogged != false ? clearModel : model;
                switch (dir) {
                    case DOWN: {
                        return Variant.variant().with(VariantProperties.MODEL, (Object)m).with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R90);
                    }
                    case EAST: {
                        return Variant.variant().with(VariantProperties.MODEL, (Object)m).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R90);
                    }
                    case NORTH: {
                        return Variant.variant().with(VariantProperties.MODEL, (Object)m);
                    }
                    case SOUTH: {
                        return Variant.variant().with(VariantProperties.MODEL, (Object)m).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R180);
                    }
                    case UP: {
                        return Variant.variant().with(VariantProperties.MODEL, (Object)m).with(VariantProperties.X_ROT, (Object)VariantProperties.Rotation.R270);
                    }
                }
                return Variant.variant().with(VariantProperties.MODEL, (Object)m).with(VariantProperties.Y_ROT, (Object)VariantProperties.Rotation.R270);
            })));
        }

        private void dynamicSpawner(Block block) {
            ResourceLocation modelName = ModelTemplates.create((String)"spawner", (TextureSlot[])new TextureSlot[0]).extend().renderType("cutout").build().create(block, new TextureMapping(), this.modelOutput);
            MultiVariantGenerator gen = MultiVariantGenerator.multiVariant((Block)block, (Variant)Variant.variant().with(VariantProperties.MODEL, (Object)modelName));
            this.blockStateOutput.accept(gen);
        }

        private void structureBlock(Block block) {
            HashMap<StructureMode, BlockModelWrapper.Unbaked> modelsForMode = new HashMap<StructureMode, BlockModelWrapper.Unbaked>();
            ArrayList<SelectItemModel.SwitchCase> modeSwitch = new ArrayList<SelectItemModel.SwitchCase>();
            for (StructureMode mode : StructureMode.values()) {
                BlockModelWrapper.Unbaked modeModel = new BlockModelWrapper.Unbaked(ModelLocationUtils.getModelLocation((Block)block, (String)("_" + mode.getSerializedName())), List.of());
                modelsForMode.put(mode, modeModel);
                modeSwitch.add(ItemModelUtils.when((Object)mode, (ItemModel.Unbaked)modeModel));
            }
            this.itemModelOutput.accept(block.asItem(), ItemModelUtils.select((SelectItemModelProperty)new StructureModeProperty(), (ItemModel.Unbaked)((ItemModel.Unbaked)modelsForMode.get(StructureMode.LOAD)), modeSwitch));
        }
    }
}

