/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.data_components;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.Weight;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public record BlockPalette(WeightedRandomList<WeightedEntry.Wrapper<BlockState>> blocks) {
    public static final Codec<BlockPalette> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)WeightedRandomList.codec((Codec)WeightedEntry.Wrapper.codec((Codec)BlockState.CODEC)).fieldOf("blocks").forGetter(p -> p.blocks)).apply((Applicative)instance, BlockPalette::new));
    public static final StreamCodec<FriendlyByteBuf, BlockPalette> STREAM_CODEC = new StreamCodec<FriendlyByteBuf, BlockPalette>(){

        public BlockPalette decode(FriendlyByteBuf buff) {
            int size = buff.readInt();
            SimpleWeightedRandomList.Builder builder = SimpleWeightedRandomList.builder();
            for (int i = 0; i < size; ++i) {
                int weight = buff.readInt();
                BlockState state = (BlockState)Block.BLOCK_STATE_REGISTRY.byId(buff.readInt());
                builder.add((Object)state, weight);
            }
            return BlockPalette.of((WeightedRandomList<WeightedEntry.Wrapper<BlockState>>)builder.build());
        }

        public void encode(FriendlyByteBuf buff, BlockPalette palette) {
            List blocks = palette.blocks.unwrap();
            int size = blocks.size();
            buff.writeInt(size);
            for (int i = 0; i < size; ++i) {
                WeightedEntry.Wrapper b = (WeightedEntry.Wrapper)blocks.get(i);
                Weight weight = b.getWeight();
                BlockState state = (BlockState)b.data();
                buff.writeInt(weight.asInt());
                buff.writeInt(Block.BLOCK_STATE_REGISTRY.getId((Object)state));
            }
        }
    };
    public static final BlockPalette EMPTY = BlockPalette.of((WeightedRandomList<WeightedEntry.Wrapper<BlockState>>)SimpleWeightedRandomList.empty());

    public static BlockPalette of(WeightedRandomList<WeightedEntry.Wrapper<BlockState>> palette) {
        return new BlockPalette(palette);
    }

    public boolean isEmpty() {
        return this.blocks.isEmpty();
    }

    public Optional<WeightedEntry.Wrapper<BlockState>> getRandom(RandomSource rand) {
        return this.blocks.getRandom(rand);
    }
}

