/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.data_handler.handlers;

import com.legacy.structure_gel.api.data_handler.handlers.DataHandler;
import com.legacy.structure_gel.api.data_handler.handlers.ProbabilityDataHandler;
import com.legacy.structure_gel.api.data_handler.parsing.DataMap;
import com.legacy.structure_gel.api.data_handler.parsing.DataParser;
import com.legacy.structure_gel.api.registry.RegistryHelper;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.TreeFeatures;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;

public class ConfiguredFeatureHandler
extends ProbabilityDataHandler<ConfiguredFeatureHandler> {
    public static final DataParser.Factory PARSER = DataParser.of(builder -> {
        builder.add("feature", TreeFeatures.OAK);
        builder.add("generation_chance", 1.0f, 0.0f, 1.0f);
    });
    private final ResourceKey<ConfiguredFeature<?, ?>> feature;

    public ConfiguredFeatureHandler(DataMap data) {
        super(data, "generation_chance");
        this.feature = data.get("feature", Registries.CONFIGURED_FEATURE);
    }

    @Override
    protected void handle(DataHandler.Context context) {
        WorldGenLevel level = context.getLevel();
        BlockPos pos = context.getBlockPos();
        RandomSource rand = context.getRandom();
        Optional<ConfiguredFeature<?, ?>> configuredFeature = RegistryHelper.get((LevelAccessor)level, this.feature);
        if (configuredFeature.isPresent()) {
            configuredFeature.get().place(level, level.getLevel().getChunkSource().getGenerator(), rand, pos);
        }
    }
}

