/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.events;

import com.legacy.structure_gel.api.data.providers.NestedDataProvider;
import com.legacy.structure_gel.api.registry.StructureGelRegistries;
import com.legacy.structure_gel.api.registry.registrar.RegistrarHandler;
import com.legacy.structure_gel.core.commands.StructureGelCommand;
import com.legacy.structure_gel.core.data.generators.SGModelProvider;
import com.legacy.structure_gel.core.data.generators.SGTagProv;
import com.legacy.structure_gel.core.item.building_tool.ActionHistory;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolItem;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolMode;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolModes;
import com.legacy.structure_gel.core.registry.RegistrarLoader;
import com.legacy.structure_gel.core.registry.SGRegistry;
import com.legacy.structure_gel.core.util.Internal;
import com.mojang.brigadier.CommandDispatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.DetectedVersion;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.RegistrySetBuilder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.metadata.PackMetadataGenerator;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.util.InclusiveRange;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.properties.StructureMode;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.data.DatapackBuiltinEntriesProvider;
import net.neoforged.neoforge.common.util.TriState;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.registries.NewRegistryEvent;
import net.neoforged.neoforge.registries.RegisterEvent;

@Internal
public class SGCommonEvents {

    @EventBusSubscriber(modid="structure_gel", bus=EventBusSubscriber.Bus.GAME)
    protected static class ForgeBus {
        protected ForgeBus() {
        }

        @SubscribeEvent
        protected static void registerCommands(RegisterCommandsEvent event) {
            StructureGelCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        }

        @SubscribeEvent
        protected static void onRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
            if (event.getItemStack().is((Item)SGRegistry.Items.BUILDING_TOOL.get())) {
                event.setUseBlock(TriState.FALSE);
            }
        }
    }

    @EventBusSubscriber(modid="structure_gel", bus=EventBusSubscriber.Bus.MOD)
    protected static class ModBus {
        protected ModBus() {
        }

        @SubscribeEvent
        protected static void newRegistries(NewRegistryEvent event) {
            event.register(StructureGelRegistries.DATA_HANDLER_TYPE);
            event.register(StructureGelRegistries.LOOT_TABLE_ALIAS);
            event.register(StructureGelRegistries.DYNAMIC_SPAWNER_TYPE);
            event.register(StructureGelRegistries.JIGSAW_TYPE);
            event.register(StructureGelRegistries.GEL_SPREAD_BEHAVIOR);
            event.register(StructureGelRegistries.GEL_SPREAD_RESTRICTION);
        }

        @SubscribeEvent(priority=EventPriority.HIGHEST)
        protected static void onRegistry(RegisterEvent event) {
            RegistrarLoader.loadRegistrars();
        }

        @SubscribeEvent
        protected static void commonSetup(FMLCommonSetupEvent event) {
            BuildingToolModes.init();
            ActionHistory.init();
        }

        @SubscribeEvent
        protected static void onTabLoad(BuildCreativeModeTabContentsEvent event) {
            if (event.getTabKey().equals(CreativeModeTabs.OP_BLOCKS) && event.hasPermissions()) {
                ArrayList<ItemStack> structureBlocks = new ArrayList<ItemStack>(4);
                for (StructureMode mode : StructureMode.values()) {
                    ItemStack stack = new ItemStack((ItemLike)Blocks.STRUCTURE_BLOCK);
                    CompoundTag blockEntityTag = new CompoundTag();
                    blockEntityTag.putString("id", BlockEntityType.STRUCTURE_BLOCK.builtInRegistryHolder().key().location().toString());
                    blockEntityTag.putString("mode", mode.name());
                    stack.set(DataComponents.BLOCK_ENTITY_DATA, (Object)CustomData.of((CompoundTag)blockEntityTag));
                    structureBlocks.add(stack);
                }
                ModBus.insertAfter(event, structureBlocks, (ItemLike)Items.STRUCTURE_BLOCK);
                event.accept(SGRegistry.Blocks.RED_GEL);
                event.accept(SGRegistry.Blocks.BLUE_GEL);
                event.accept(SGRegistry.Blocks.GREEN_GEL);
                event.accept(SGRegistry.Blocks.CYAN_GEL);
                event.accept(SGRegistry.Blocks.ORANGE_GEL);
                event.accept(SGRegistry.Blocks.YELLOW_GEL);
                event.accept((ItemLike)Items.GUNPOWDER);
                event.accept(SGRegistry.Blocks.DATA_HANDLER);
                event.accept(SGRegistry.Blocks.DYNAMIC_SPAWNER);
                event.accept(SGRegistry.Items.BUILDING_TOOL);
                for (BuildingToolMode mode : BuildingToolModes.REGISTRY) {
                    if (mode.isNone()) continue;
                    ItemStack stack = SGRegistry.Items.BUILDING_TOOL.getDefaultInstance();
                    BuildingToolItem.setMode(stack, mode);
                    event.accept(stack, CreativeModeTab.TabVisibility.SEARCH_TAB_ONLY);
                }
            }
            if (event.getTabKey().equals(CreativeModeTabs.SPAWN_EGGS)) {
                ModBus.insertAfter(event, List.of(SGRegistry.Blocks.DYNAMIC_SPAWNER.asItem().getDefaultInstance()), (ItemLike)Items.SPAWNER);
            }
        }

        private static void insertAfter(BuildCreativeModeTabContentsEvent event, List<ItemStack> items, ItemLike target) {
            ItemStack currentStack = null;
            for (ItemStack e : event.getParentEntries()) {
                if (e.getItem() != target) continue;
                currentStack = e;
                break;
            }
            for (ItemStack item : items) {
                ItemStack itemStack = currentStack;
                currentStack = item;
                event.insertAfter(itemStack, currentStack, CreativeModeTab.TabVisibility.PARENT_AND_SEARCH_TABS);
            }
        }

        @SubscribeEvent
        protected static void gatherData(GatherDataEvent.Client event) {
            DataGenerator dataGen = event.getGenerator();
            PackOutput packOutput = dataGen.getPackOutput();
            boolean server = true;
            DatapackBuiltinEntriesProvider registrarProv = new DatapackBuiltinEntriesProvider(packOutput, event.getLookupProvider(), RegistrarHandler.injectRegistries(new RegistrySetBuilder()), Set.of("structure_gel"));
            registrarProv = (DatapackBuiltinEntriesProvider)dataGen.addProvider(server, (DataProvider)registrarProv);
            SGTagProv.BlockTagProv blockTags = new SGTagProv.BlockTagProv(packOutput, registrarProv.getRegistryProvider());
            dataGen.addProvider(server, (DataProvider)blockTags);
            dataGen.addProvider(server, (DataProvider)new SGTagProv.ItemTagProv(packOutput, registrarProv.getRegistryProvider(), blockTags.contentsGetter()));
            dataGen.addProvider(server, (DataProvider)new SGTagProv.StructureTagProv(packOutput, registrarProv.getRegistryProvider()));
            dataGen.addProvider(server, (DataProvider)new SGModelProvider(packOutput));
            dataGen.addProvider(server, ModBus.packMcmeta(packOutput, "Structure Gel resources"));
        }

        private static final DataProvider packMcmeta(PackOutput output, String description) {
            int serverVersion = DetectedVersion.BUILT_IN.getPackVersion(PackType.SERVER_DATA);
            return NestedDataProvider.of(new PackMetadataGenerator(output).add(PackMetadataSection.TYPE, (Object)new PackMetadataSection((Component)Component.literal((String)description), serverVersion, Optional.of(new InclusiveRange((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(Integer.MAX_VALUE))))), description);
        }
    }
}

