/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.item;

import com.legacy.structure_gel.core.data_components.BlockPalette;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolItem;
import com.legacy.structure_gel.core.item.util.PaletteTooltip;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.inventory.tooltip.TooltipComponent;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.LevelReader;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

public class BlockPaletteItem
extends Item {
    public BlockPaletteItem(Item.Properties prop) {
        super(prop);
    }

    public Optional<TooltipComponent> getTooltipImage(ItemStack stack) {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            return BlockPaletteItem.getPalleteTooltip(stack, (LevelReader)Minecraft.getInstance().level);
        }
        return Optional.ofNullable(ServerLifecycleHooks.getCurrentServer()).map(MinecraftServer::overworld).map(l -> BlockPaletteItem.getPalleteTooltip(stack, (LevelReader)l).orElse(null));
    }

    public static Optional<TooltipComponent> getPalleteTooltip(ItemStack stack, LevelReader level) {
        BlockPalette palette = BlockPaletteItem.getPalette(stack, level);
        return palette.isEmpty() ? Optional.empty() : Optional.of(new PaletteTooltip(palette));
    }

    public static BlockPalette getPalette(ItemStack stack, LevelReader level) {
        return BuildingToolItem.getPalette(stack, level);
    }

    public static void setPalette(ItemStack stack, BlockPalette palette) {
        BuildingToolItem.setPalette(stack, palette);
    }
}

