/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.item.building_tool;

import com.legacy.structure_gel.api.registry.registrar.Registrar;
import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.capability.level.BuildingToolPlayerData;
import com.legacy.structure_gel.core.client.ClientProxy;
import com.legacy.structure_gel.core.data_components.BlockPalette;
import com.legacy.structure_gel.core.data_components.BuildingToolProperties;
import com.legacy.structure_gel.core.data_components.CloneRegion;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolBounds;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolMode;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolModes;
import com.legacy.structure_gel.core.item.building_tool.CapturedBlocks;
import com.legacy.structure_gel.core.item.building_tool.SmartBoundingBox;
import com.legacy.structure_gel.core.item.building_tool.ToolModeProperty;
import com.legacy.structure_gel.core.network.SGPacketHandler;
import com.legacy.structure_gel.core.network.bi_directional.UpdateBuildingToolPacket;
import com.legacy.structure_gel.core.network.c_to_s.ActionHistoryPacket;
import com.legacy.structure_gel.core.network.c_to_s.LeftClickBuildingToolPacket;
import com.legacy.structure_gel.core.network.c_to_s.MiddleClickBuildingToolPacket;
import com.legacy.structure_gel.core.network.c_to_s.ProcessDeletePacket;
import com.legacy.structure_gel.core.network.c_to_s.RequestClipboardPacket;
import com.legacy.structure_gel.core.network.c_to_s.RightClickBuildingToolPacket;
import com.legacy.structure_gel.core.registry.SGRegistry;
import com.legacy.structure_gel.core.util.SGText;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.datafixers.util.Pair;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.random.SimpleWeightedRandomList;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandom;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ClickAction;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SolidBucketItem;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.ICancellableEvent;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.InputEvent;
import net.neoforged.neoforge.client.event.RenderFrameEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.util.Lazy;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.tick.PlayerTickEvent;

public final class BuildingToolItem
extends Item {
    private final BiFunction<BuildingToolMode, String, Component> nameCache = Util.memoize((mode, name) -> Component.literal((String)name).append((Component)Component.literal((String)": ")).append(mode.getComponent()));
    public static int leftClickHoldTime = 0;
    public static int rightClickHoldTime = 0;
    public static final int CLICK_HOLD_TIME = 5;
    private static BlockPos lastHitPos = BlockPos.ZERO;
    private static long lastActionTime = 0L;
    private static final Component NO_PERMISSION = Component.translatable((String)"info.structure_gel.building_tool.message.no_permission").withStyle(ChatFormatting.RED);
    private static final String INFO_NAME = "item.structure_gel.building_tool.info.";
    public static final String BLOCK_PALETTE_NAME = "info.structure_gel.building_tool.block_palette";
    public static final String BLOCK_PALETTE_TOOLTIP = StructureGelMod.locate("block_palette_tooltip").toString();
    private static BoundingBox lastClipboardRequestBounds = BoundingBox.infinite();
    private static long lastClipboardRequestTime = 0L;

    @OnlyIn(value=Dist.CLIENT)
    private void clientInit() {
        IEventBus bus = NeoForge.EVENT_BUS;
        bus.addListener(PlayerInteractEvent.LeftClickEmpty.class, event -> {
            BlockPos blockPos;
            HitResult patt0$temp = Minecraft.getInstance().hitResult;
            if (patt0$temp instanceof BlockHitResult) {
                BlockHitResult blockHit = (BlockHitResult)patt0$temp;
                blockPos = blockHit.getBlockPos();
            } else {
                blockPos = null;
            }
            this.onLeftClickEvent((PlayerInteractEvent)event, blockPos);
        });
        bus.addListener(PlayerInteractEvent.LeftClickBlock.class, event -> this.onLeftClickEvent((PlayerInteractEvent)event, event.getPos()));
        bus.addListener(PlayerInteractEvent.RightClickItem.class, event -> {
            BlockPos blockPos;
            HitResult patt0$temp = Minecraft.getInstance().hitResult;
            if (patt0$temp instanceof BlockHitResult) {
                BlockHitResult blockHit = (BlockHitResult)patt0$temp;
                blockPos = blockHit.getBlockPos();
            } else {
                blockPos = null;
            }
            this.onRightClickEvent((PlayerInteractEvent)event, blockPos, arg_0 -> ((PlayerInteractEvent.RightClickItem)event).setCancellationResult(arg_0));
        });
        bus.addListener(PlayerInteractEvent.RightClickBlock.class, event -> this.onRightClickEvent((PlayerInteractEvent)event, event.getPos(), arg_0 -> ((PlayerInteractEvent.RightClickBlock)event).setCancellationResult(arg_0)));
        bus.addListener(InputEvent.Key.class, event -> this.processKeyPress((InputEvent.Key)event));
        bus.addListener(InputEvent.MouseButton.Pre.class, event -> this.interceptMousePress((InputEvent.MouseButton.Pre)event));
        bus.addListener(InputEvent.MouseButton.Post.class, event -> this.processMousePress((InputEvent.MouseButton.Post)event));
        bus.addListener(InputEvent.MouseScrollingEvent.class, event -> this.onMouseScroll((InputEvent.MouseScrollingEvent)event));
        bus.addListener(PlayerTickEvent.Pre.class, event -> this.tick((PlayerTickEvent.Pre)event));
        bus.addListener(ClientTickEvent.Post.class, event -> this.clientTick((ClientTickEvent.Post)event));
        bus.addListener(RenderFrameEvent.Post.class, event -> this.renderTick((RenderFrameEvent.Post)event));
    }

    @Nullable
    public static Pair<InteractionHand, ItemStack> getBuildingTool(Player player) {
        ItemStack stack = player.getMainHandItem();
        if (stack.is((Item)SGRegistry.Items.BUILDING_TOOL.get())) {
            return Pair.of((Object)InteractionHand.MAIN_HAND, (Object)stack);
        }
        stack = player.getOffhandItem();
        if (stack.is((Item)SGRegistry.Items.BUILDING_TOOL.get())) {
            return Pair.of((Object)InteractionHand.OFF_HAND, (Object)stack);
        }
        return null;
    }

    public BuildingToolItem(Item.Properties properties) {
        super(properties);
        if (FMLEnvironment.dist == Dist.CLIENT) {
            this.clientInit();
        }
    }

    public ItemAttributeModifiers getDefaultAttributeModifiers(ItemStack stack) {
        ItemAttributeModifiers.Builder builder = ItemAttributeModifiers.builder();
        int reach = BuildingToolItem.getReachDistanceModifier(stack) + BuildingToolItem.getMode(stack).getReachDistance(stack);
        builder.add(Attributes.BLOCK_INTERACTION_RANGE, new AttributeModifier(StructureGelMod.locate("building_tool_block_reach"), (double)reach, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.HAND);
        builder.add(Attributes.ENTITY_INTERACTION_RANGE, new AttributeModifier(StructureGelMod.locate("building_tool_entity_reach"), (double)reach, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.HAND);
        return builder.build();
    }

    public boolean canAttackBlock(BlockState state, Level level, BlockPos pos, Player player) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void processKeyPress(InputEvent.Key event) {
        Minecraft mc = Minecraft.getInstance();
        int action = event.getAction();
        if (action == 1 || action == 2) {
            Pair<InteractionHand, ItemStack> tool;
            if (mc.player != null && (tool = BuildingToolItem.getBuildingTool((Player)mc.player)) != null) {
                InteractionHand hand = (InteractionHand)tool.getFirst();
                ItemStack stack = (ItemStack)tool.getSecond();
                this.processModdedKeyMapping(hand, stack, (InputEvent)event);
                return;
            }
            this.voidModdedKeyMapping();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void interceptMousePress(InputEvent.MouseButton.Pre event) {
        Pair<InteractionHand, ItemStack> tool;
        Minecraft mc = Minecraft.getInstance();
        int action = event.getAction();
        if ((action == 1 || action == 2) && mc.player != null && (tool = BuildingToolItem.getBuildingTool((Player)mc.player)) != null) {
            InteractionHand hand = (InteractionHand)tool.getFirst();
            ItemStack stack = (ItemStack)tool.getSecond();
            if (event.getButton() == mc.options.keyPickItem.getKey().getValue() && mc.screen == null && this.hasPermission(stack, (Player)mc.player)) {
                BlockPos hitPos;
                HitResult hitResult = mc.hitResult;
                if (hitResult instanceof BlockHitResult) {
                    BlockHitResult blockHit = (BlockHitResult)hitResult;
                    v0 = blockHit.getBlockPos();
                } else {
                    v0 = hitPos = null;
                }
                if (hitPos != null) {
                    this.onMiddleClick(stack, (Player)mc.player, hitPos);
                    mc.player.swing(hand);
                    SGPacketHandler.sendToServer(new MiddleClickBuildingToolPacket(hand, hitPos));
                    if (event instanceof ICancellableEvent) {
                        event.setCanceled(true);
                    }
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void processMousePress(InputEvent.MouseButton.Post event) {
        Minecraft mc = Minecraft.getInstance();
        int action = event.getAction();
        if (action == 1 || action == 2) {
            Pair<InteractionHand, ItemStack> tool;
            if (mc.player != null && (tool = BuildingToolItem.getBuildingTool((Player)mc.player)) != null) {
                InteractionHand hand = (InteractionHand)tool.getFirst();
                ItemStack stack = (ItemStack)tool.getSecond();
                this.processModdedKeyMapping(hand, stack, (InputEvent)event);
                return;
            }
            this.voidModdedKeyMapping();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void processModdedKeyMapping(InteractionHand hand, ItemStack stack, InputEvent event) {
        Minecraft mc = Minecraft.getInstance();
        while (((KeyMapping)ClientProxy.UNDO_KEY.get()).consumeClick()) {
            if (mc.screen != null || !this.hasPermission(stack, (Player)mc.player)) continue;
            SGPacketHandler.sendToServer(ActionHistoryPacket.undo(true));
        }
        while (((KeyMapping)ClientProxy.REDO_KEY.get()).consumeClick()) {
            if (mc.screen != null || !this.hasPermission(stack, (Player)mc.player)) continue;
            SGPacketHandler.sendToServer(ActionHistoryPacket.redo(true));
        }
        while (((KeyMapping)ClientProxy.COPY_KEY.get()).consumeClick()) {
            if (mc.screen != null || !this.hasPermission(stack, (Player)mc.player) || BuildingToolItem.getMode(stack) != BuildingToolModes.CLONE) continue;
            SGPacketHandler.sendToServer(ActionHistoryPacket.copy(hand, true));
        }
        while (((KeyMapping)ClientProxy.PASTE_KEY.get()).consumeClick()) {
            if (mc.screen != null || !this.hasPermission(stack, (Player)mc.player) || BuildingToolItem.getMode(stack) != BuildingToolModes.CLONE) continue;
            KeyMapping.click((InputConstants.Key)mc.options.keyAttack.getKey());
        }
        while (((KeyMapping)ClientProxy.DELETE_KEY.get()).consumeClick()) {
            if (mc.screen != null || !this.hasPermission(stack, (Player)mc.player)) continue;
            SGPacketHandler.sendToServer(new ProcessDeletePacket());
        }
        while (((KeyMapping)ClientProxy.BUILDING_TOOL_KEY.get()).consumeClick()) {
            if (!this.hasPermission(stack, (Player)mc.player)) continue;
            BuildingToolBounds.releaseGrabbedCorner(stack, (Player)mc.player);
            SGPacketHandler.sendToServer(ActionHistoryPacket.releaseGrabbedCorner(hand));
            StructureGelMod.proxy.openBuildingToolScreen(stack, hand);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void voidModdedKeyMapping() {
        for (Lazy<KeyMapping> mapping : ClientProxy.KEY_MAPPINGS) {
            while (((KeyMapping)mapping.get()).consumeClick()) {
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void onMouseScroll(InputEvent.MouseScrollingEvent event) {
        Minecraft mc = Minecraft.getInstance();
        if (mc.player != null) {
            int scrollDelta;
            Pair<InteractionHand, ItemStack> tool = BuildingToolItem.getBuildingTool((Player)mc.player);
            if (tool == null) {
                return;
            }
            InteractionHand hand = (InteractionHand)tool.getFirst();
            ItemStack stack = (ItemStack)tool.getSecond();
            if (mc.screen == null && mc.options.keySprint.isDown() && this.hasPermission(stack, (Player)mc.player) && (scrollDelta = (int)event.getScrollDeltaY()) != 0) {
                if (BuildingToolItem.getSelectedCorner(stack) == null) {
                    int reach = BuildingToolItem.setReachDistanceModifier(stack, BuildingToolItem.getReachDistanceModifier(stack) + scrollDelta);
                    SGPacketHandler.sendToServer(UpdateBuildingToolPacket.builder().hand(hand).reachDistance(reach).build());
                    mc.player.displayClientMessage((Component)Component.translatable((String)"info.structure_gel.building_tool.message.set_reach", (Object[])new Object[]{reach + BuildingToolItem.getMode(stack).getReachDistance(stack)}), true);
                } else {
                    float cornerDistance = BuildingToolItem.setSelectedCornerDistance(this.getDefaultInstance(), BuildingToolItem.getSelectedCornerDistance(stack) + (float)scrollDelta);
                    SGPacketHandler.sendToServer(UpdateBuildingToolPacket.builder().hand(hand).cornerReachDistance(cornerDistance).build());
                    DecimalFormat formatter = new DecimalFormat("0.##");
                    mc.player.displayClientMessage((Component)Component.translatable((String)"info.structure_gel.building_tool.message.set_reach", (Object[])new Object[]{formatter.format(cornerDistance)}), true);
                }
                event.setCanceled(true);
            }
        }
    }

    public void tick(PlayerTickEvent.Pre event) {
        if (event.getEntity() != null) {
            Pair<InteractionHand, ItemStack> tool = BuildingToolItem.getBuildingTool(event.getEntity());
            if (tool == null) {
                return;
            }
            ItemStack stack = (ItemStack)tool.getSecond();
            if (BuildingToolBounds.tick(stack, event.getEntity())) {
                return;
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void clientTick(ClientTickEvent.Post event) {
        LocalPlayer player;
        if (Minecraft.getInstance().options.keyAttack.isDown()) {
            player = Minecraft.getInstance().player;
            if (player.isCreative() && this.hasPermission(player.getMainHandItem(), (Player)player)) {
                ++leftClickHoldTime;
            }
        } else if (leftClickHoldTime > 0) {
            leftClickHoldTime = 0;
        }
        if (Minecraft.getInstance().options.keyUse.isDown()) {
            player = Minecraft.getInstance().player;
            if (player.isCreative() && this.hasPermission(player.getMainHandItem(), (Player)player)) {
                ++rightClickHoldTime;
            }
        } else if (rightClickHoldTime > 0) {
            rightClickHoldTime = 0;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    private void renderTick(RenderFrameEvent.Post event) {
        HitResult hitResult;
        LocalPlayer player;
        if ((leftClickHoldTime >= 5 || rightClickHoldTime >= 5) && (player = Minecraft.getInstance().player).isCreative() && (hitResult = Minecraft.getInstance().hitResult) instanceof BlockHitResult) {
            BlockHitResult blockHit = (BlockHitResult)hitResult;
            BlockPos pos = blockHit.getBlockPos();
            ItemStack stack = player.getMainHandItem();
            BuildingToolMode mode = BuildingToolItem.getMode(stack);
            if (!lastHitPos.equals((Object)pos) || !mode.targetsSpecificPos()) {
                Direction clickedFace = blockHit.getDirection();
                if (leftClickHoldTime >= 5) {
                    long time = Minecraft.getInstance().level.getGameTime();
                    if (time - lastActionTime >= (long)mode.getSpamDelay() || lastActionTime == 0L) {
                        this.onLeftClick(stack, (Player)player, pos, clickedFace, true);
                        SGPacketHandler.sendToServer(new LeftClickBuildingToolPacket(InteractionHand.MAIN_HAND, pos, clickedFace, true));
                        lastActionTime = time;
                    }
                } else if (rightClickHoldTime >= 5) {
                    InteractionHand hand = player.getUsedItemHand();
                    this.onRightClick(stack, hand, (Player)player, pos, clickedFace, true);
                    SGPacketHandler.sendToServer(new RightClickBuildingToolPacket(hand, pos, clickedFace, true));
                }
                lastHitPos = pos;
            }
        }
    }

    public boolean onRightClick(ItemStack stack, InteractionHand hand, Player player, BlockPos clickedPos, Direction clickedFace, boolean isHolding) {
        if (this.hasPermission(stack, player)) {
            BuildingToolMode mode = BuildingToolItem.getMode(stack);
            Level level = player.level();
            player.swing(hand);
            if (!isHolding && BuildingToolBounds.handleBoundingBoxClick(stack, player)) {
                return true;
            }
            if (level.getBlockState(clickedPos).isAir()) {
                mode.onRightClickAir(level, player, clickedPos, stack);
            } else {
                mode.onRightClickBlock(level, player, clickedPos, stack, clickedFace);
            }
            return true;
        }
        return false;
    }

    private void onRightClickEvent(PlayerInteractEvent event, @Nullable BlockPos pos, Consumer<InteractionResult> result) {
        if (pos != null) {
            Player player = event.getEntity();
            ItemStack stack = event.getItemStack();
            if (player != null && player.level().isClientSide && this.hasPermission(stack, player)) {
                Direction clickedFace = event.getFace();
                if (clickedFace == null) {
                    clickedFace = Direction.UP;
                }
                if (this.onRightClick(stack, event.getHand(), player, pos, clickedFace, rightClickHoldTime >= 5) && event instanceof ICancellableEvent) {
                    ICancellableEvent cancellable = (ICancellableEvent)event;
                    cancellable.setCanceled(true);
                    result.accept((InteractionResult)InteractionResult.SUCCESS);
                }
                SGPacketHandler.sendToServer(new RightClickBuildingToolPacket(event.getHand(), pos, clickedFace, rightClickHoldTime >= 5));
            }
        }
    }

    public boolean onLeftClick(ItemStack stack, Player player, BlockPos clickedPos, Direction clickedFace, boolean isHolding) {
        if (this.hasPermission(stack, player)) {
            if (BuildingToolItem.getSelectedCorner(stack) != null) {
                return false;
            }
            BuildingToolItem.getMode(stack).onLeftClick(player.level(), player, clickedPos, stack, clickedFace);
            return true;
        }
        return false;
    }

    private void onLeftClickEvent(PlayerInteractEvent event, @Nullable BlockPos pos) {
        if (pos != null) {
            Player player = event.getEntity();
            ItemStack stack = event.getItemStack();
            if (player != null && player.level().isClientSide && this.hasPermission(stack, player) && (!player.swinging || player.swingTime > 1)) {
                Direction clickedFace = event.getFace();
                if (clickedFace == null) {
                    clickedFace = Direction.UP;
                }
                if (this.onLeftClick(stack, player, pos, clickedFace, leftClickHoldTime >= 5) && event instanceof ICancellableEvent) {
                    ICancellableEvent cancellable = (ICancellableEvent)event;
                    cancellable.setCanceled(true);
                }
                SGPacketHandler.sendToServer(new LeftClickBuildingToolPacket(event.getHand(), pos, clickedFace, leftClickHoldTime >= 5));
            }
        }
    }

    public void onMiddleClick(ItemStack stack, Player player, BlockPos clickedPos) {
        if (clickedPos != null && this.hasPermission(stack, player)) {
            Level level = player.level();
            BuildingToolMode mode = BuildingToolItem.getMode(stack);
            if (level.getBlockState(clickedPos).isAir()) {
                mode.onMiddleClickAir(level, player, clickedPos, stack);
            } else {
                mode.onMiddleClickBlock(level, player, clickedPos, stack);
            }
        }
    }

    public Component getName(ItemStack stack) {
        BuildingToolMode mode = BuildingToolItem.getMode(stack);
        Component name = super.getName(stack);
        return mode.isNone() ? name : this.nameCache.apply(mode, name.getString());
    }

    public static boolean hasToolPermission(ItemStack stack, Player player) {
        return ((BuildingToolItem)((Object)SGRegistry.Items.BUILDING_TOOL.get())).hasPermission(stack, player);
    }

    private boolean hasPermission(ItemStack stack, Player player) {
        if (stack.is((Item)this)) {
            boolean hasPermission = player.isCreative();
            if (!hasPermission && !player.isSpectator()) {
                player.displayClientMessage(NO_PERMISSION, true);
            }
            return hasPermission;
        }
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> list, TooltipFlag showAdvanced) {
        BuildingToolMode mode = BuildingToolItem.getMode(stack);
        if (Screen.hasShiftDown()) {
            if (!mode.isNone()) {
                list.add(SGText.applyKeybindFilter((Component)Component.translatable((String)mode.getDescKey(), (Object[])mode.getDescArgs())));
                list.add((Component)SGText.NEW_LINE);
                if (mode.hasBlockPalette()) {
                    list.add((Component)SGText.BULLET_POINT.copy().withStyle(ChatFormatting.GRAY).append((Component)Component.translatable((String)BLOCK_PALETTE_NAME).withStyle(SGText.VALUE_LABEL_STYLE)));
                    list.add((Component)Component.literal((String)BLOCK_PALETTE_TOOLTIP));
                }
                for (ToolModeProperty<?> property : mode.getProperties().values()) {
                    list.add((Component)SGText.BULLET_POINT.copy().withStyle(ChatFormatting.GRAY).append((Component)Component.literal((String)property.getNameComponent().getString()).withStyle(SGText.VALUE_LABEL_STYLE)).append((Component)Component.literal((String)(": " + property.getValueComponent(BuildingToolItem.getProperty(stack, property)).getString()))));
                }
                list.add((Component)SGText.NEW_LINE);
            } else {
                String buildingToolKey = SGText.keybindString((KeyMapping)ClientProxy.BUILDING_TOOL_KEY.get());
                list.add(SGText.applyKeybindFilter((Component)Component.translatable((String)"info.structure_gel.building_tool_description", (Object[])new Object[]{buildingToolKey})));
                list.add((Component)SGText.NEW_LINE);
            }
        } else if (Screen.hasControlDown()) {
            Options options = Minecraft.getInstance().options;
            String buildingToolKey = SGText.keybindString((KeyMapping)ClientProxy.BUILDING_TOOL_KEY.get());
            String middleClick = SGText.keybindString(options.keyPickItem);
            String control = SGText.keybindString(options.keySprint);
            String undo = SGText.keybindString((KeyMapping)ClientProxy.UNDO_KEY.get());
            String redo = SGText.keybindString((KeyMapping)ClientProxy.REDO_KEY.get());
            list.add(SGText.applyKeybindFilter((Component)Component.translatable((String)"item.structure_gel.building_tool.info.open_gui", (Object[])new Object[]{buildingToolKey})));
            list.add(SGText.applyKeybindFilter((Component)Component.translatable((String)"item.structure_gel.building_tool.info.select_block", (Object[])new Object[]{middleClick})));
            list.add(SGText.applyKeybindFilter((Component)Component.translatable((String)"item.structure_gel.building_tool.info.zoom_reach", (Object[])new Object[]{control})));
            list.add(SGText.applyKeybindFilter((Component)Component.translatable((String)"item.structure_gel.building_tool.info.undo_and_redo", (Object[])new Object[]{undo, redo})));
            list.add((Component)SGText.NEW_LINE);
        } else {
            list.add(SGText.applyKeybindFilter((Component)Component.translatable((String)"info.structure_gel.hold_shift")));
            list.add(SGText.applyKeybindFilter((Component)Component.translatable((String)"info.structure_gel.hold_control")));
        }
    }

    public static String getPaletteString(WeightedRandomList<WeightedEntry.Wrapper<BlockState>> palette) {
        List states = palette.unwrap().stream().sorted((o1, o2) -> Integer.compare(o2.getWeight().asInt(), o1.getWeight().asInt())).toList();
        if (states.isEmpty()) {
            states = SimpleWeightedRandomList.builder().add((Object)Blocks.AIR.defaultBlockState(), 1).build().unwrap();
        }
        StringBuilder paletteStr = new StringBuilder();
        float totalWeight = WeightedRandom.getTotalWeight(states);
        for (WeightedEntry.Wrapper state : states) {
            int percent = Math.round((float)state.getWeight().asInt() / totalWeight * 100.0f);
            paletteStr.append("\n   " + percent + "% " + ((BlockState)state.data()).getBlock().getName().getString());
        }
        return paletteStr.toString();
    }

    public boolean overrideOtherStackedOnMe(ItemStack stack, ItemStack other, Slot slot, ClickAction clickAction, Player player, SlotAccess slotAccess) {
        if (!other.isEmpty() && clickAction == ClickAction.SECONDARY) {
            BuildingToolItem.setPaletteFromInventory(stack, BuildingToolItem.readPaletteFrom(other, (LevelReader)player.level()), player);
            return true;
        }
        return false;
    }

    public boolean overrideStackedOnOther(ItemStack stack, Slot slot, ClickAction clickAction, Player player) {
        ItemStack other;
        if (clickAction == ClickAction.SECONDARY && !(other = slot.getItem()).isEmpty()) {
            BuildingToolItem.setPaletteFromInventory(stack, BuildingToolItem.readPaletteFrom(other, (LevelReader)player.level()), player);
            return true;
        }
        return false;
    }

    private static void setPaletteFromInventory(ItemStack stack, BlockPalette palette, Player player) {
        BuildingToolItem.setPalette(stack, palette);
        player.playSound(SoundEvents.ITEM_PICKUP, 0.8f, 0.9f + player.level().getRandom().nextFloat() * 0.2f);
    }

    public static BuildingToolMode getMode(ItemStack stack) {
        BuildingToolMode mode;
        ResourceLocation modeName = (ResourceLocation)stack.get(SGRegistry.DataComponents.BUILDING_TOOL_MODE);
        if (modeName != null && (mode = BuildingToolModes.REGISTRY.get(modeName)) != null) {
            return mode;
        }
        return BuildingToolModes.NONE;
    }

    public static void setMode(ItemStack stack, BuildingToolMode mode) {
        stack.set(SGRegistry.DataComponents.BUILDING_TOOL_MODE, (Object)mode.getName());
    }

    public static Optional<BlockPos> getPos(ItemStack stack, int index) {
        BlockPos pos;
        if (index > -1 && index < SGRegistry.DataComponents.TOOL_POSES.size() && (pos = (BlockPos)stack.get((Supplier)SGRegistry.DataComponents.TOOL_POSES.get(index))) != null) {
            return Optional.of(pos);
        }
        return Optional.empty();
    }

    public static boolean hasCompleteSelection(ItemStack stack) {
        return BuildingToolItem.getPos(stack, 0).isPresent() && BuildingToolItem.getPos(stack, 1).isPresent();
    }

    public static boolean setPos(ItemStack stack, int index, Vec3i pos) {
        if (BuildingToolItem.getPos(stack, index).equals(Optional.of(pos))) {
            return false;
        }
        stack.set((Supplier)SGRegistry.DataComponents.TOOL_POSES.get(index), (Object)new BlockPos(pos));
        return true;
    }

    public static void clearPoses(ItemStack stack) {
        for (Registrar.Static<DataComponentType<BlockPos>> pos : SGRegistry.DataComponents.TOOL_POSES) {
            stack.remove(pos);
        }
        BuildingToolItem.setSelectedCorner(stack, null);
    }

    public static BlockPalette getPalette(ItemStack stack, LevelReader level) {
        BlockPalette palette = (BlockPalette)stack.getOrDefault(SGRegistry.DataComponents.BLOCK_PALETTE, (Object)BlockPalette.EMPTY);
        if (palette.isEmpty()) {
            return BlockPalette.of((WeightedRandomList<WeightedEntry.Wrapper<BlockState>>)SimpleWeightedRandomList.builder().add((Object)Blocks.AIR.defaultBlockState(), 1).build());
        }
        return palette;
    }

    public static void setPalette(ItemStack stack, BlockPalette palette) {
        stack.set(SGRegistry.DataComponents.BLOCK_PALETTE, (Object)palette);
    }

    public static BlockPalette readPaletteFrom(Level level, BlockPos pos) {
        Container readFrom;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof Container && !(readFrom = (Container)blockEntity).isEmpty()) {
            HashMap<Item, Integer> stacks = new HashMap<Item, Integer>();
            int size = readFrom.getContainerSize();
            for (int i = 0; i < size; ++i) {
                ItemStack stack = readFrom.getItem(i);
                int count = stack.getCount();
                stacks.compute(stack.getItem(), (item, c) -> c == null ? count : c + count);
            }
            BlockPalette palette = BuildingToolItem.readPaletteFrom(stacks, (LevelReader)level);
            if (!palette.isEmpty()) {
                return palette;
            }
        }
        return BlockPalette.of((WeightedRandomList<WeightedEntry.Wrapper<BlockState>>)SimpleWeightedRandomList.builder().add((Object)level.getBlockState(pos), 1).build());
    }

    public static BlockPalette readPaletteFrom(ItemStack readFrom, LevelReader level) {
        if (readFrom.is((Item)SGRegistry.Items.BLOCK_PALETTE.get())) {
            return BuildingToolItem.getPalette(readFrom, level);
        }
        ItemContainerContents container = (ItemContainerContents)readFrom.get(DataComponents.CONTAINER);
        if (container != null) {
            HashMap<Item, Integer> stacks = new HashMap<Item, Integer>();
            List containerItems = container.nonEmptyStream().toList();
            if (!containerItems.isEmpty()) {
                for (ItemStack stack : containerItems) {
                    int count = stack.getCount();
                    stacks.compute(stack.getItem(), (i, c) -> c == null ? count : c + count);
                }
                BlockPalette palette = BuildingToolItem.readPaletteFrom(stacks, level);
                if (!palette.isEmpty()) {
                    return palette;
                }
            }
        }
        return BuildingToolItem.readPaletteFrom(Map.of(readFrom.getItem(), readFrom.getCount()), level);
    }

    public static BlockPalette readPaletteFrom(Map<Item, Integer> items, LevelReader level) {
        SimpleWeightedRandomList.Builder builder = SimpleWeightedRandomList.builder();
        for (Map.Entry<Item, Integer> entry : items.entrySet()) {
            Optional<BlockState> opState = BuildingToolItem.getStateForItem(entry.getKey(), level, false);
            if (!opState.isPresent()) continue;
            builder.add((Object)opState.get(), entry.getValue().intValue());
        }
        return BlockPalette.of((WeightedRandomList<WeightedEntry.Wrapper<BlockState>>)builder.build());
    }

    public static ItemStack getItemForBlock(BlockState state, LevelReader level) {
        ItemStack stack;
        Block block = state.getBlock();
        if (block instanceof LiquidBlock) {
            LiquidBlock liquidBlock = (LiquidBlock)block;
            stack = liquidBlock.fluid.getBucket().getDefaultInstance();
        } else {
            stack = block.asItem().getDefaultInstance();
        }
        if (stack.is(Items.AIR)) {
            stack = Items.BUCKET.getDefaultInstance();
        }
        return stack.isItemEnabled(level.enabledFeatures()) ? stack : ItemStack.EMPTY;
    }

    public static Optional<BlockState> getStateForItem(Item item, LevelReader level, boolean includeAir) {
        BlockState state = null;
        if (item instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            state = blockItem.getBlock().defaultBlockState();
        } else if (item instanceof BucketItem) {
            BucketItem bucket = (BucketItem)item;
            state = bucket.content.defaultFluidState().createLegacyBlock();
        } else if (item instanceof SolidBucketItem) {
            SolidBucketItem solidBucket = (SolidBucketItem)item;
            state = solidBucket.getBlock().defaultBlockState();
        } else if (includeAir) {
            state = Blocks.AIR.defaultBlockState();
        }
        return Optional.ofNullable(state != null && state.getBlock().isEnabled(level.enabledFeatures()) ? state : null);
    }

    public static void clearPalette(ItemStack stack) {
        stack.remove(SGRegistry.DataComponents.BLOCK_PALETTE);
    }

    public static <T> T getProperty(ItemStack stack, ToolModeProperty<T> property) {
        String key;
        BuildingToolProperties props = (BuildingToolProperties)stack.get(SGRegistry.DataComponents.BUILDING_TOOL_PROPERTIES);
        if (props != null && props.contains(key = property.getKey())) {
            return property.read(props.get(key));
        }
        return property.getDefaultValue();
    }

    public static <T> void setProperty(ItemStack stack, ToolModeProperty<T> property, T value) {
        BuildingToolProperties props = (BuildingToolProperties)stack.getOrDefault(SGRegistry.DataComponents.BUILDING_TOOL_PROPERTIES, (Object)BuildingToolProperties.DEFAULT);
        props = props.withValue(property.getKey(), property.write(value));
        stack.set(SGRegistry.DataComponents.BUILDING_TOOL_PROPERTIES, (Object)props);
    }

    public static int getReachDistanceModifier(ItemStack stack) {
        return (Integer)stack.getOrDefault(SGRegistry.DataComponents.BUILDING_TOOL_REACH_MODIFIER, (Object)0);
    }

    public static int setReachDistanceModifier(ItemStack stack, int reachDistanceModifier) {
        reachDistanceModifier = Mth.clamp((int)reachDistanceModifier, (int)ToolModeProperty.REACH_DISTANCE.min(), (int)ToolModeProperty.REACH_DISTANCE.max());
        stack.set(SGRegistry.DataComponents.BUILDING_TOOL_REACH_MODIFIER, (Object)reachDistanceModifier);
        return reachDistanceModifier;
    }

    public static boolean causesBlockUpdates(ItemStack stack) {
        return (Boolean)stack.getOrDefault(SGRegistry.DataComponents.BUILDING_TOOL_CAUSE_BLOCK_UPDATES, (Object)true);
    }

    public static void setCausesBlockUpdates(ItemStack stack, boolean causeBlockUpdates) {
        stack.set(SGRegistry.DataComponents.BUILDING_TOOL_CAUSE_BLOCK_UPDATES, (Object)causeBlockUpdates);
    }

    @Nullable
    public static SmartBoundingBox.CornerType getSelectedCorner(ItemStack stack) {
        return (SmartBoundingBox.CornerType)((Object)stack.get(SGRegistry.DataComponents.CORNER_TYPE));
    }

    public static void setSelectedCorner(ItemStack stack, @Nullable SmartBoundingBox.CornerType cornerType) {
        if (cornerType == null) {
            stack.remove(SGRegistry.DataComponents.CORNER_TYPE);
        } else {
            stack.set(SGRegistry.DataComponents.CORNER_TYPE, (Object)cornerType);
        }
    }

    public static float getSelectedCornerDistance(ItemStack stack) {
        return ((Float)stack.getOrDefault(SGRegistry.DataComponents.BUILDING_TOOL_CORNER_DIST, (Object)Float.valueOf(3.0f))).floatValue();
    }

    public static float setSelectedCornerDistance(ItemStack stack, float cornerDistance) {
        cornerDistance = Mth.clamp((float)cornerDistance, (float)1.0f, (float)ToolModeProperty.REACH_DISTANCE.max().intValue());
        stack.set(SGRegistry.DataComponents.BUILDING_TOOL_CORNER_DIST, (Object)Float.valueOf(cornerDistance));
        return cornerDistance;
    }

    public static boolean isMovingBounds(ItemStack stack) {
        return (Boolean)stack.getOrDefault(SGRegistry.DataComponents.BUILDING_TOOL_MOVING_BOUNDS, (Object)false);
    }

    public static void setMovingBounds(ItemStack stack, boolean moveBounds) {
        stack.set(SGRegistry.DataComponents.BUILDING_TOOL_MOVING_BOUNDS, (Object)moveBounds);
    }

    @Nullable
    public static CapturedBlocks getCapturedBlocks(ItemStack stack, Level level, Player player) {
        CloneRegion cloneRegion = (CloneRegion)stack.get(SGRegistry.DataComponents.BUILDING_TOOL_CAPTURED_BLOCKS);
        if (cloneRegion != null) {
            BoundingBox bounds = cloneRegion.bounds();
            CapturedBlocks captured = StructureGelMod.proxy.getBuildingToolData(level.getServer(), cloneRegion).getCapturedBlocks(bounds, cloneRegion.playerName());
            if (level.isClientSide && captured == null) {
                long time = System.currentTimeMillis();
                if (!lastClipboardRequestBounds.equals((Object)bounds) || time - lastClipboardRequestTime > 1000L || lastClipboardRequestTime == 0L) {
                    lastClipboardRequestTime = time;
                    lastClipboardRequestBounds = bounds;
                    SGPacketHandler.sendToServer(new RequestClipboardPacket(cloneRegion));
                }
            }
            return captured;
        }
        return null;
    }

    public static void setCapturedBlocks(ItemStack stack, Level level, Player player, @Nullable Pair<BoundingBox, CapturedBlocks> clipboard) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (clipboard == null) {
                stack.remove(SGRegistry.DataComponents.BUILDING_TOOL_CAPTURED_BLOCKS);
            } else {
                BoundingBox bounds = (BoundingBox)clipboard.getFirst();
                CapturedBlocks captured = (CapturedBlocks)clipboard.getSecond();
                String owner = player.getGameProfile().getName();
                BuildingToolPlayerData data = BuildingToolPlayerData.get(serverLevel, owner);
                data.addToClipboard(bounds, captured);
                stack.set(SGRegistry.DataComponents.BUILDING_TOOL_CAPTURED_BLOCKS, (Object)new CloneRegion(bounds, (ResourceKey<Level>)level.dimension(), owner));
            }
        }
    }
}

