/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.item.building_tool.modes;

import com.legacy.structure_gel.core.client.ClientProxy;
import com.legacy.structure_gel.core.item.building_tool.ActionHistory;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolItem;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolMode;
import com.legacy.structure_gel.core.item.building_tool.CapturedBlocks;
import com.legacy.structure_gel.core.item.building_tool.ToolModeProperty;
import com.legacy.structure_gel.core.util.SGText;
import com.mojang.datafixers.util.Pair;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.Vec3;

public class CloneTool
extends BuildingToolMode.ForCorners {
    public CloneTool(String name, int modelIndex) {
        super(name, modelIndex);
    }

    @Override
    protected void performAction(Level level, Player player, BlockPos clickedPos, ItemStack stack, BlockPos cornerA, BlockPos cornerB) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        RandomSource rand = level.getRandom();
        boolean causesBlockUpdates = BuildingToolItem.causesBlockUpdates(stack);
        double integrity = BuildingToolItem.getProperty(stack, ToolModeProperty.INTEGRITY);
        Rotation rotation = BuildingToolItem.getProperty(stack, ToolModeProperty.ROTATION).toVanilla(rand);
        Mirror mirror = BuildingToolItem.getProperty(stack, ToolModeProperty.MIRROR).toVanilla(rand);
        boolean cut = BuildingToolItem.getProperty(stack, ToolModeProperty.CUT_FALSE).value();
        ToolModeProperty.Replace replace = BuildingToolItem.getProperty(stack, ToolModeProperty.REPLACE_NOT_CLICKED);
        CapturedBlocks captured = BuildingToolItem.getCapturedBlocks(stack, level, player);
        if (captured == null) {
            BuildingToolMode.sendMessage(player, "info.structure_gel.building_tool.message.clipboard_missing", Style.EMPTY.withColor(ChatFormatting.RED), new Object[0]);
            return;
        }
        captured = captured.withTransforms(mirror, rotation);
        ActionHistory.ActionBuilder action = ActionHistory.newAction(level, causesBlockUpdates);
        if (cut) {
            BlockState air = Blocks.AIR.defaultBlockState();
            this.forPosesWithin((Vec3i)cornerA, (Vec3i)cornerB, pos -> this.setBlock(level, (BlockPos)pos, air, causesBlockUpdates, action));
            this.clearPoses(stack, player);
        }
        BoundingBox destBB = CloneTool.getCloneDestBounds(captured, clickedPos, level.getBlockState(clickedPos), player.position(), player.isShiftKeyDown());
        BlockPos startPos = new BlockPos(destBB.minX(), destBB.minY(), destBB.minZ());
        for (CapturedBlocks.BlockInfo blockInfo : captured.getBlockInfos()) {
            if (!((double)rand.nextFloat() < integrity)) continue;
            BlockPos placePos = startPos.offset((Vec3i)blockInfo.pos());
            BlockState placeState = blockInfo.state();
            if (!replace.shouldReplace(level, placeState, placePos)) continue;
            this.setBlock(level, placePos, old -> blockInfo.state(), causesBlockUpdates, blockInfo.blockEntityTag().orElse(null), action, captured.getMirror(), captured.getRotation());
        }
        for (CapturedBlocks.EntityInfo entityInfo : captured.getEntityInfos()) {
            Entity entity = entityInfo.createEntity(level, startPos, mirror, rotation);
            if (entity == null) continue;
            this.addEntity(level, entity, action);
            if (!cut) continue;
            this.removeEntity(serverLevel, entityInfo.original(), action);
        }
        ActionHistory.get(player).add(level, action);
        BuildingToolMode.sendMessage(player, "info.structure_gel.building_tool.message.clone_blocks", new Object[0]);
        BuildingToolMode.playSound(player, SoundEvents.NETHERITE_BLOCK_PLACE);
    }

    @Override
    public Object[] getDescArgs() {
        Options options = Minecraft.getInstance().options;
        String shift = SGText.keybindString(options.keyShift);
        String rightClick = SGText.keybindString(options.keyUse);
        String leftClick = SGText.keybindString(options.keyAttack);
        String copy = SGText.keybindString((KeyMapping)ClientProxy.COPY_KEY.get());
        String paste = SGText.keybindString((KeyMapping)ClientProxy.PASTE_KEY.get());
        return new Object[]{Component.translatable((String)"item.structure_gel.building_tool.mode.select_corners", (Object[])new Object[]{rightClick, shift, rightClick, rightClick, shift}), leftClick, paste, copy};
    }

    @Override
    public void addProperties(List<ToolModeProperty<?>> properties) {
        super.addProperties(properties);
        properties.add(ToolModeProperty.INTEGRITY);
        properties.add(ToolModeProperty.ROTATION);
        properties.add(ToolModeProperty.MIRROR);
        properties.add(ToolModeProperty.CUT_FALSE);
        properties.add(ToolModeProperty.REPLACE_NOT_CLICKED);
        properties.add(ToolModeProperty.INCLUDE_ENTITIES);
    }

    @Override
    public boolean hasBlockPalette() {
        return false;
    }

    public static void saveCapturedBlocks(ItemStack stack, Level level, Player player) {
        Optional<BlockPos> pos0 = BuildingToolItem.getPos(stack, 0);
        Optional<BlockPos> pos1 = BuildingToolItem.getPos(stack, 1);
        if (pos0.isPresent() && pos1.isPresent()) {
            CapturedBlocks captured = new CapturedBlocks(level, pos0.get(), pos1.get(), Mirror.NONE, Rotation.NONE, BuildingToolItem.getProperty(stack, ToolModeProperty.INCLUDE_ENTITIES).value());
            BuildingToolItem.setCapturedBlocks(stack, level, player, (Pair<BoundingBox, CapturedBlocks>)Pair.of((Object)BoundingBox.fromCorners((Vec3i)((Vec3i)pos0.get()), (Vec3i)((Vec3i)pos1.get())), (Object)captured));
        }
    }

    @Override
    public void setPosition(Player player, BlockPos clickedPos, ItemStack stack, boolean message) {
        super.setPosition(player, clickedPos, stack, message);
        CloneTool.saveCapturedBlocks(stack, player.level(), player);
    }

    @Override
    public void onSelect(ItemStack stack, Level level, Player player) {
        CloneTool.saveCapturedBlocks(stack, level, player);
    }

    @Override
    public void clearPoses(ItemStack stack, Player player) {
        super.clearPoses(stack, player);
        BuildingToolItem.setCapturedBlocks(stack, player.level(), player, null);
    }

    @Override
    public boolean requiresSelectionLoaded() {
        return false;
    }

    @Override
    public void onReleaseCorner(ItemStack stack, Level level, Player player) {
        CloneTool.saveCapturedBlocks(stack, level, player);
    }

    public static BoundingBox getCloneDestBounds(CapturedBlocks captured, BlockPos targetPos, BlockState targetedBlock, Vec3 playerPos, boolean placeOneBlockAbove) {
        Vec3i bbLength = captured.getBounds().getLength();
        BlockPos start = targetPos.offset(-bbLength.getX() + bbLength.getX() / 2, 0, -bbLength.getZ() + bbLength.getZ() / 2);
        if (placeOneBlockAbove) {
            start = start.above();
        }
        BoundingBox destBB = BoundingBox.fromCorners((Vec3i)start, (Vec3i)start.offset(bbLength));
        int x = destBB.minX();
        int z = destBB.minZ();
        int dx = destBB.maxX();
        int dz = destBB.maxZ();
        LinkedList<Vec3i> edgePositions = new LinkedList<Vec3i>();
        edgePositions.add(new Vec3i(x, 0, z));
        edgePositions.add(new Vec3i(x, 0, dz));
        edgePositions.add(new Vec3i(dx, 0, z));
        edgePositions.add(new Vec3i(dx, 0, dz));
        edgePositions.sort(Comparator.comparingDouble(v -> new Vec3((double)v.getX() + 0.5, (double)v.getY(), (double)v.getZ() + 0.5).distanceTo(playerPos)));
        Vec3i closestCorner = (Vec3i)edgePositions.getFirst();
        BlockPos center = destBB.getCenter();
        return destBB.moved(center.getX() - closestCorner.getX(), 0, center.getZ() - closestCorner.getZ());
    }
}

