/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.mixin.client;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.legacy.structure_gel.api.events.RegisterArmorTrimTexturesEvent;
import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.client.ClientUtil;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.model.Model;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.entity.layers.EquipmentLayerRenderer;
import net.minecraft.client.renderer.texture.atlas.SpriteSource;
import net.minecraft.client.renderer.texture.atlas.SpriteSourceList;
import net.minecraft.client.renderer.texture.atlas.sources.PalettedPermutations;
import net.minecraft.client.resources.model.EquipmentClientInfo;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.equipment.EquipmentAsset;
import net.minecraft.world.item.equipment.trim.ArmorTrim;
import net.minecraft.world.item.equipment.trim.TrimMaterial;
import net.neoforged.bus.api.Event;
import net.neoforged.fml.ModLoader;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

public class ArmorTrimMixins {

    @Mixin(value={EquipmentLayerRenderer.class})
    private static class EquipmentLayerRendererMixin {
        private EquipmentLayerRendererMixin() {
        }

        @WrapOperation(at={@At(value="INVOKE", target="Lnet/minecraft/client/model/Model;renderToBuffer(Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;II)V")}, method={"renderLayers(Lnet/minecraft/client/resources/model/EquipmentClientInfo$LayerType;Lnet/minecraft/resources/ResourceKey;Lnet/minecraft/client/model/Model;Lnet/minecraft/world/item/ItemStack;Lcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;ILnet/minecraft/resources/ResourceLocation;)V"})
        private void modifyLight(Model target, PoseStack poseStack, VertexConsumer buff, int packedLight, int packedOverlay, Operation<Void> original, EquipmentClientInfo.LayerType layerType, ResourceKey<EquipmentAsset> equipmentAsset, Model model, ItemStack stack) {
            int customBlockLight;
            ArmorTrim trim = (ArmorTrim)stack.get(DataComponents.TRIM);
            if (trim != null && (customBlockLight = ClientUtil.getMaterialBrightness(trim)) > -1) {
                packedLight = LightTexture.pack((int)Math.max(customBlockLight, LightTexture.block((int)packedLight)), (int)LightTexture.sky((int)packedLight));
            }
            original.call(new Object[]{target, poseStack, buff, packedLight, packedOverlay});
        }
    }

    @Mixin(value={SpriteSourceList.class})
    private static abstract class SpriteSourceListMixin {
        private SpriteSourceListMixin() {
        }

        @Inject(at={@At(value="RETURN")}, method={"load"})
        private static void onLoadReturn(ResourceManager pResourceManager, ResourceLocation atlasLocation, CallbackInfoReturnable<SpriteSourceList> callback) {
            try {
                PalettedPermutations permutate;
                SpriteSourceList ret;
                RegisterArmorTrimTexturesEvent trimEvent;
                HashMap<ResourceKey<TrimMaterial>, Integer> materialLight;
                HashMap<String, ResourceLocation> trimMaterials;
                HashSet<ResourceLocation> patterns;
                HashSet<ResourceLocation> armorPatterns;
                if (atlasLocation.equals((Object)ResourceLocation.tryParse((String)"armor_trims"))) {
                    StructureGelMod.LOGGER.debug("Injecting armor trims into texture atlas: " + String.valueOf(atlasLocation), new Object[0]);
                    armorPatterns = new HashSet<ResourceLocation>();
                    patterns = new HashSet<ResourceLocation>();
                    trimMaterials = new HashMap<String, ResourceLocation>();
                    materialLight = new HashMap<ResourceKey<TrimMaterial>, Integer>();
                    trimEvent = new RegisterArmorTrimTexturesEvent(armorPatterns, patterns, trimMaterials, materialLight);
                    ModLoader.postEvent((Event)trimEvent);
                    ClientUtil.materialLight = materialLight;
                    ret = (SpriteSourceList)callback.getReturnValue();
                    for (SpriteSource source : ((SpriteSourceListMixin)ret).getSources()) {
                        if (!(source instanceof PalettedPermutations)) continue;
                        permutate = (PalettedPermutations)source;
                        if (!permutate.paletteKey.equals((Object)ResourceLocation.tryParse((String)"trims/color_palettes/trim_palette"))) continue;
                        List<ResourceLocation> patternLocations = Stream.concat(armorPatterns.stream(), armorPatterns.stream().map(rl -> rl.withSuffix("_leggings"))).map(rl -> rl.withPrefix("trims/models/armor/")).toList();
                        permutate.textures = ImmutableList.builder().addAll((Iterable)permutate.textures).addAll(patternLocations).addAll(patterns).build();
                        Map<String, ResourceLocation> materialLocations = trimMaterials.entrySet().stream().collect(Collectors.toMap(p -> (String)p.getKey(), p -> ((ResourceLocation)p.getValue()).withPrefix("trims/color_palettes/")));
                        permutate.permutations = ImmutableMap.builder().putAll(permutate.permutations).putAll(materialLocations).build();
                    }
                }
                if (atlasLocation.equals((Object)ResourceLocation.tryParse((String)"blocks"))) {
                    StructureGelMod.LOGGER.debug("Injecting armor trims into texture atlas: " + String.valueOf(atlasLocation), new Object[0]);
                    armorPatterns = new HashSet();
                    patterns = new HashSet();
                    trimMaterials = new HashMap();
                    materialLight = new HashMap();
                    trimEvent = new RegisterArmorTrimTexturesEvent(armorPatterns, patterns, trimMaterials, materialLight);
                    ModLoader.postEvent((Event)trimEvent);
                    ClientUtil.materialLight = materialLight;
                    ret = (SpriteSourceList)callback.getReturnValue();
                    for (SpriteSource source : ((SpriteSourceListMixin)ret).getSources()) {
                        if (!(source instanceof PalettedPermutations)) continue;
                        permutate = (PalettedPermutations)source;
                        if (!permutate.paletteKey.equals((Object)ResourceLocation.tryParse((String)"trims/color_palettes/trim_palette"))) continue;
                        Map<String, ResourceLocation> materialLocations = trimMaterials.entrySet().stream().collect(Collectors.toMap(p -> (String)p.getKey(), p -> ((ResourceLocation)p.getValue()).withPrefix("trims/color_palettes/")));
                        permutate.permutations = ImmutableMap.builder().putAll(permutate.permutations).putAll(materialLocations).build();
                    }
                }
            }
            catch (IllegalAccessError e) {
                e.printStackTrace();
            }
            catch (Exception e) {
                StructureGelMod.LOGGER.error(e, new Object[0]);
                e.printStackTrace();
            }
        }

        @Accessor(value="sources")
        abstract List<SpriteSource> getSources();
    }
}

