/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.mixin.client;

import com.legacy.structure_gel.core.SGConfig;
import com.legacy.structure_gel.core.client.ClientUtil;
import com.legacy.structure_gel.core.util.SGText;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.StructureBlockRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.StructureMode;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@OnlyIn(value=Dist.CLIENT)
@Mixin(value={StructureBlockRenderer.class})
public class StructureBlockRendererMixin {
    @Inject(at={@At(value="HEAD")}, method={"render"})
    private void render(StructureBlockEntity structureBlock, float partialTicks, PoseStack posStack, MultiBufferSource buffer, int pPackedLight, int pPackedOverlay, CallbackInfo callback) {
        if (!SGConfig.CLIENT.showStructureBlockInfo()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        if (structureBlock.getLevel() != null && mc.player != null && ClientUtil.rayTrace(structureBlock.getLevel(), (Player)mc.player).getBlockPos().equals((Object)structureBlock.getBlockPos())) {
            String name = structureBlock.getMode().getSerializedName();
            MutableComponent mode = Component.translatable((String)("structure_block.mode." + name)).setStyle(SGText.VALUE_LABEL_STYLE).append(": ");
            MutableComponent text = Component.literal((String)(structureBlock.getMode() == StructureMode.DATA ? structureBlock.getMetaData() : structureBlock.getStructureName()));
            ClientUtil.renderName((Component)Component.empty().append((Component)mode).append((Component)text), (BlockGetter)structureBlock.getLevel(), structureBlock.getBlockPos(), posStack, buffer, 220);
        }
    }

    @WrapOperation(at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;isAir()Z")}, method={"renderInvisibleBlocks"})
    private boolean renderInvisibleAir(BlockState target, Operation<Boolean> original) {
        return (Boolean)original.call(new Object[]{target}) != false && (Boolean)SGConfig.CLIENT.showAir.get() != false;
    }

    @WrapOperation(at={@At(value="INVOKE", target="net/minecraft/world/level/block/state/BlockState.is(Lnet/minecraft/world/level/block/Block;)Z", ordinal=0)}, method={"renderInvisibleBlocks"})
    private boolean renderInvisibleVoid(BlockState target, Block block, Operation<Boolean> original) {
        return (Boolean)original.call(new Object[]{target, block}) != false && (Boolean)SGConfig.CLIENT.showVoid.get() != false;
    }

    @WrapOperation(at={@At(value="INVOKE", target="net/minecraft/world/level/block/state/BlockState.is(Lnet/minecraft/world/level/block/Block;)Z", ordinal=1)}, method={"renderInvisibleBlocks"})
    private boolean renderInvisibleBarrier(BlockState target, Block block, Operation<Boolean> original) {
        return (Boolean)original.call(new Object[]{target, block}) != false && (Boolean)SGConfig.CLIENT.showBarrier.get() != false;
    }

    @WrapOperation(at={@At(value="INVOKE", target="net/minecraft/world/level/block/state/BlockState.is(Lnet/minecraft/world/level/block/Block;)Z", ordinal=2)}, method={"renderInvisibleBlocks"})
    private boolean renderInvisibleLight(BlockState target, Block block, Operation<Boolean> original) {
        return (Boolean)original.call(new Object[]{target, block}) != false && (Boolean)SGConfig.CLIENT.showLight.get() != false;
    }
}

