/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.mixin.common;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.StructureMode;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={StructureBlockEntity.class})
public class StructureBlockEntityMixin {
    @Inject(at={@At(value="RETURN")}, method={"detectSize"}, cancellable=true)
    private void detectSizeHook(CallbackInfoReturnable<Boolean> callback) {
        StructureBlockEntity me;
        if (!((Boolean)callback.getReturnValue()).booleanValue() && (me = (StructureBlockEntity)this).getMode() == StructureMode.SAVE) {
            BlockPos pos = me.getBlockPos();
            BlockPos originPos = pos.offset(1, 1, 1);
            Level level = me.getLevel();
            int maxSize = 48;
            Vec3i bounds = StructureBlockEntityMixin.createBounds(level, originPos, new Vec3i(maxSize, maxSize, maxSize));
            if ((bounds = StructureBlockEntityMixin.createBounds(level, originPos, bounds)).getX() > 0 && bounds.getY() > 0 && bounds.getZ() > 0) {
                me.setStructurePos(new BlockPos(1, 1, 1));
                me.setStructureSize(bounds);
                me.setChanged();
                BlockState blockstate = level.getBlockState(pos);
                level.sendBlockUpdated(pos, blockstate, blockstate, 3);
                callback.setReturnValue((Object)true);
            }
        }
    }

    private static Vec3i createBounds(Level level, BlockPos origin, Vec3i searchBounds) {
        int pz;
        int py;
        int px;
        int maxX = 0;
        block0: for (px = 0; px < searchBounds.getX(); ++px) {
            for (int y = 0; y < searchBounds.getY(); ++y) {
                for (int z = 0; z < searchBounds.getZ(); ++z) {
                    BlockPos searchPos = origin.offset(px, y, z);
                    if (!level.getBlockState(searchPos).isAir()) continue block0;
                }
            }
        }
        maxX = px;
        int maxY = 0;
        block3: for (py = 0; py < searchBounds.getY(); ++py) {
            for (int x = 0; x < maxX; ++x) {
                for (int z = 0; z < searchBounds.getZ(); ++z) {
                    BlockPos searchPos = origin.offset(x, py, z);
                    if (!level.getBlockState(searchPos).isAir()) continue block3;
                }
            }
        }
        maxY = py;
        int maxZ = 0;
        block6: for (pz = 0; pz < searchBounds.getZ(); ++pz) {
            for (int x = 0; x < maxX; ++x) {
                for (int y = 0; y < maxY; ++y) {
                    BlockPos searchPos = origin.offset(x, y, pz);
                    if (!level.getBlockState(searchPos).isAir()) continue block6;
                }
            }
        }
        maxZ = pz;
        return new Vec3i(maxX, maxY, maxZ);
    }
}

