/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.mixin.common;

import com.legacy.structure_gel.api.structure.StructureAccessHelper;
import com.legacy.structure_gel.api.structure.base.IPieceBuilderModifier;
import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.function.Predicate;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePiecesBuilder;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Structure.class})
public class StructureMixin {
    @Inject(at={@At(value="HEAD")}, method={"generate"}, cancellable=true)
    private void checkDimension(Holder<Structure> structure, ResourceKey<Level> level, RegistryAccess registryAccess, ChunkGenerator chunkGen, BiomeSource biomeSource, RandomState randomState, StructureTemplateManager structureTemplateManager, long levelSeed, ChunkPos chunkPos, int refs, LevelHeightAccessor levelHeight, Predicate<Holder<Biome>> biomeTest, CallbackInfoReturnable<StructureStart> callback) {
        boolean validDim = StructureAccessHelper.isValidDimension(structure.unwrapKey(), level);
        if (!validDim) {
            callback.setReturnValue((Object)StructureStart.INVALID_START);
        }
    }

    @ModifyExpressionValue(at={@At(value="INVOKE", target="net/minecraft/world/level/levelgen/structure/Structure$GenerationStub.getPiecesBuilder()Lnet/minecraft/world/level/levelgen/structure/pieces/StructurePiecesBuilder;")}, method={"generate"})
    private StructurePiecesBuilder modifyPieceBuilder(StructurePiecesBuilder pieceBuilder, @Local(ordinal=0) Structure.GenerationContext context) {
        Structure structure = (Structure)this;
        if (structure instanceof IPieceBuilderModifier) {
            IPieceBuilderModifier modifier = (IPieceBuilderModifier)structure;
            modifier.modifyPieceBuilder(pieceBuilder, context);
        }
        return pieceBuilder;
    }
}

