/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.network;

import com.legacy.structure_gel.core.network.bi_directional.UpdateBuildingToolPacket;
import com.legacy.structure_gel.core.network.c_to_s.ActionHistoryPacket;
import com.legacy.structure_gel.core.network.c_to_s.ExportPalettePacket;
import com.legacy.structure_gel.core.network.c_to_s.LeftClickBuildingToolPacket;
import com.legacy.structure_gel.core.network.c_to_s.MiddleClickBuildingToolPacket;
import com.legacy.structure_gel.core.network.c_to_s.ProcessDeletePacket;
import com.legacy.structure_gel.core.network.c_to_s.RequestClipboardPacket;
import com.legacy.structure_gel.core.network.c_to_s.RequestRegistryKeysPacket;
import com.legacy.structure_gel.core.network.c_to_s.RightClickBuildingToolPacket;
import com.legacy.structure_gel.core.network.c_to_s.UpdateDataHandlerPacket;
import com.legacy.structure_gel.core.network.c_to_s.UpdateDynamicSpawnerPacket;
import com.legacy.structure_gel.core.network.s_to_c.EditClipboardPacket;
import com.legacy.structure_gel.core.network.s_to_c.PlaySoundPacket;
import com.legacy.structure_gel.core.network.s_to_c.SendRegistryKeysToClientPacket;
import com.legacy.structure_gel.core.network.s_to_c.SendStructureInfoToClientPacket;
import com.legacy.structure_gel.core.network.s_to_c.ToggleViewBoundsPacket;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.common.util.FakePlayer;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.server.ServerLifecycleHooks;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class SGPacketHandler {
    @SubscribeEvent
    public static void registerPayloads(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("10");
        registrar.playToClient(EditClipboardPacket.TYPE, EditClipboardPacket.CODEC, EditClipboardPacket::handler);
        registrar.playToClient(PlaySoundPacket.TYPE, PlaySoundPacket.CODEC, PlaySoundPacket::handler);
        registrar.playToClient(SendRegistryKeysToClientPacket.TYPE, SendRegistryKeysToClientPacket.CODEC, SendRegistryKeysToClientPacket::handler);
        registrar.playToClient(SendStructureInfoToClientPacket.TYPE, SendStructureInfoToClientPacket.CODEC, SendStructureInfoToClientPacket::handler);
        registrar.playToClient(ToggleViewBoundsPacket.TYPE, ToggleViewBoundsPacket.CODEC, ToggleViewBoundsPacket::handler);
        registrar.playToServer(ActionHistoryPacket.TYPE, ActionHistoryPacket.CODEC, ActionHistoryPacket::handler);
        registrar.playToServer(LeftClickBuildingToolPacket.TYPE, LeftClickBuildingToolPacket.CODEC, LeftClickBuildingToolPacket::handler);
        registrar.playToServer(RightClickBuildingToolPacket.TYPE, RightClickBuildingToolPacket.CODEC, RightClickBuildingToolPacket::handler);
        registrar.playToServer(MiddleClickBuildingToolPacket.TYPE, MiddleClickBuildingToolPacket.CODEC, MiddleClickBuildingToolPacket::handler);
        registrar.playToServer(RequestClipboardPacket.TYPE, RequestClipboardPacket.CODEC, RequestClipboardPacket::handler);
        registrar.playToServer(RequestRegistryKeysPacket.TYPE, RequestRegistryKeysPacket.CODEC, RequestRegistryKeysPacket::handler);
        registrar.playToServer(UpdateDynamicSpawnerPacket.TYPE, UpdateDynamicSpawnerPacket.CODEC, UpdateDynamicSpawnerPacket::handler);
        registrar.playToServer(UpdateDataHandlerPacket.TYPE, UpdateDataHandlerPacket.CODEC, UpdateDataHandlerPacket::handler);
        registrar.playToServer(ProcessDeletePacket.TYPE, ProcessDeletePacket.CODEC, ProcessDeletePacket::handler);
        registrar.playToServer(ExportPalettePacket.TYPE, ExportPalettePacket.CODEC, ExportPalettePacket::handler);
        registrar.playBidirectional(UpdateBuildingToolPacket.TYPE, UpdateBuildingToolPacket.CODEC, UpdateBuildingToolPacket::handler);
    }

    public static void sendToClient(CustomPacketPayload packet, ServerPlayer serverPlayer) {
        if (!(serverPlayer instanceof FakePlayer)) {
            PacketDistributor.sendToPlayer((ServerPlayer)serverPlayer, (CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
        }
    }

    public static void sendToClients(CustomPacketPayload packet, ServerLevel level) {
        level.players().forEach(player -> SGPacketHandler.sendToClient(packet, player));
    }

    public static void sendToClients(CustomPacketPayload packet, ServerLevel level, BlockPos pos) {
        SGPacketHandler.sendToClients(packet, level, pos, 256);
    }

    public static void sendToClients(CustomPacketPayload packet, ServerLevel level, BlockPos pos, int range) {
        Vec3 centerPos = Vec3.atCenterOf((Vec3i)pos);
        level.players().forEach(player -> {
            if (centerPos.distanceTo(player.position()) <= (double)range) {
                SGPacketHandler.sendToClient(packet, player);
            }
        });
    }

    public static void sendToClients(CustomPacketPayload packet) {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server != null) {
            server.getPlayerList().getPlayers().forEach(player -> SGPacketHandler.sendToClient(packet, player));
        }
    }

    public static void sendToServer(CustomPacketPayload packet) {
        PacketDistributor.sendToServer((CustomPacketPayload)packet, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }
}

