/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.network.c_to_s;

import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.capability.level.BuildingToolPlayerData;
import com.legacy.structure_gel.core.data_components.CloneRegion;
import com.legacy.structure_gel.core.item.building_tool.CapturedBlocks;
import com.legacy.structure_gel.core.network.SGPacketHandler;
import com.legacy.structure_gel.core.network.s_to_c.EditClipboardPacket;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record RequestClipboardPacket(CloneRegion cloneRegion) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<RequestClipboardPacket> TYPE = new CustomPacketPayload.Type(StructureGelMod.locate("request_clipboard_packet"));
    public static final StreamCodec<RegistryFriendlyByteBuf, RequestClipboardPacket> CODEC = new StreamCodec<RegistryFriendlyByteBuf, RequestClipboardPacket>(){

        public void encode(RegistryFriendlyByteBuf buff, RequestClipboardPacket packet) {
            CloneRegion.STREAM_CODEC.encode((Object)buff, (Object)packet.cloneRegion);
        }

        public RequestClipboardPacket decode(RegistryFriendlyByteBuf buff) {
            return new RequestClipboardPacket((CloneRegion)CloneRegion.STREAM_CODEC.decode((Object)buff));
        }
    };

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handler(RequestClipboardPacket packet, IPayloadContext context) {
        context.enqueueWork(() -> {
            Player patt0$temp = context.player();
            if (!(patt0$temp instanceof ServerPlayer)) {
                return;
            }
            ServerPlayer player = (ServerPlayer)patt0$temp;
            CloneRegion cloneRegion = packet.cloneRegion;
            String owner = cloneRegion.playerName();
            ServerLevel level = player.getServer().getLevel(cloneRegion.levelKey());
            CapturedBlocks captured = BuildingToolPlayerData.get(level, owner).getCapturedBlocks(cloneRegion.bounds(), owner);
            if (captured != null && !packet.cloneRegion.bounds().equals((Object)BoundingBox.infinite())) {
                SGPacketHandler.sendToClient(new EditClipboardPacket(owner, cloneRegion.bounds(), captured, BoundingBox.infinite()), player);
            }
        });
    }
}

