/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.network.c_to_s;

import com.legacy.structure_gel.api.dynamic_spawner.DynamicSpawnerType;
import com.legacy.structure_gel.api.registry.StructureGelRegistries;
import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.block_entity.DynamicSpawnerBlockEntity;
import com.legacy.structure_gel.core.registry.SGRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record UpdateDynamicSpawnerPacket(BlockPos pos, ResourceLocation spawnerType, DynamicSpawnerBlockEntity.ExpRange expRange) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<UpdateDynamicSpawnerPacket> TYPE = new CustomPacketPayload.Type(StructureGelMod.locate("update_dynamic_spawner"));
    public static final StreamCodec<RegistryFriendlyByteBuf, UpdateDynamicSpawnerPacket> CODEC = new StreamCodec<RegistryFriendlyByteBuf, UpdateDynamicSpawnerPacket>(){

        public void encode(RegistryFriendlyByteBuf buff, UpdateDynamicSpawnerPacket packet) {
            buff.writeBlockPos(packet.pos);
            buff.writeResourceLocation(packet.spawnerType);
            buff.writeInt(packet.expRange.min);
            buff.writeInt(packet.expRange.max);
        }

        public UpdateDynamicSpawnerPacket decode(RegistryFriendlyByteBuf buff) {
            try {
                BlockPos pos = buff.readBlockPos();
                ResourceLocation type = buff.readResourceLocation();
                DynamicSpawnerBlockEntity.ExpRange range = new DynamicSpawnerBlockEntity.ExpRange(buff.readInt(), buff.readInt());
                return new UpdateDynamicSpawnerPacket(pos, type, range);
            }
            catch (Throwable t) {
                return new UpdateDynamicSpawnerPacket(BlockPos.ZERO, ERRORED, DynamicSpawnerBlockEntity.ExpRange.VANILLA);
            }
        }
    };
    private static final ResourceLocation ERRORED = StructureGelMod.locate("errored");

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handler(UpdateDynamicSpawnerPacket packet, IPayloadContext context) {
        Player player = context.player();
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player2 = (ServerPlayer)player;
        if (packet.spawnerType.equals((Object)ERRORED) && packet.pos.equals((Object)BlockPos.ZERO)) {
            StructureGelMod.LOGGER.warn("An invalid packet ({}) was sent to the server from {} at {} in {}", packet.getClass().getSimpleName(), player2.getGameProfile().getName(), player2.blockPosition(), player2.level().dimension().location());
            return;
        }
        context.enqueueWork(() -> {
            BlockEntity patt0$temp;
            BlockPos pos;
            ServerLevel level = player2.serverLevel();
            BlockState state = level.getBlockState(pos = packet.pos);
            if (state.getBlock() == SGRegistry.Blocks.DYNAMIC_SPAWNER.get() && (patt0$temp = level.getBlockEntity(pos)) instanceof DynamicSpawnerBlockEntity) {
                DynamicSpawnerBlockEntity spawner = (DynamicSpawnerBlockEntity)patt0$temp;
                DynamicSpawnerType dynSpawn = (DynamicSpawnerType)StructureGelRegistries.DYNAMIC_SPAWNER_TYPE.getValue(packet.spawnerType);
                if (dynSpawn != null) {
                    spawner.setSpawner(dynSpawn, (HolderLookup.Provider)level.registryAccess());
                }
                spawner.setExpRange(packet.expRange);
                spawner.setChanged();
                level.sendBlockUpdated(pos, state, state, 3);
            } else {
                StructureGelMod.LOGGER.warn("Attempted to set DynamicSpawnerBlockEntity data for the wrong block.", new Object[0]);
            }
        });
    }
}

