/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.network.s_to_c;

import com.legacy.structure_gel.api.util.NetworkUtil;
import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.capability.level.BuildingToolPlayerData;
import com.legacy.structure_gel.core.item.building_tool.CapturedBlocks;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.network.handling.IPayloadContext;

public record EditClipboardPacket(String ownerName, BoundingBox addKey, @Nullable CapturedBlocks captured, BoundingBox removeKey) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<EditClipboardPacket> TYPE = new CustomPacketPayload.Type(StructureGelMod.locate("edit_clipboard"));
    public static final StreamCodec<RegistryFriendlyByteBuf, EditClipboardPacket> CODEC = new StreamCodec<RegistryFriendlyByteBuf, EditClipboardPacket>(){

        public void encode(RegistryFriendlyByteBuf buff, EditClipboardPacket packet) {
            buff.writeUtf(packet.ownerName);
            NetworkUtil.writeBoundingBox((FriendlyByteBuf)buff, packet.addKey);
            if (!packet.addKey.equals((Object)BoundingBox.infinite()) && packet.captured != null) {
                CompoundTag tag = packet.captured.toCompressedTag((HolderLookup.Provider)buff.registryAccess());
                NetworkUtil.writeCompressedNbt((FriendlyByteBuf)buff, tag);
            }
            NetworkUtil.writeBoundingBox((FriendlyByteBuf)buff, packet.removeKey);
        }

        public EditClipboardPacket decode(RegistryFriendlyByteBuf buff) {
            CompoundTag tag;
            String ownerName = buff.readUtf();
            BoundingBox addKey = NetworkUtil.readBoundingBox((FriendlyByteBuf)buff);
            CapturedBlocks captured = null;
            if (!addKey.equals((Object)BoundingBox.infinite()) && (tag = NetworkUtil.readCompressedNbt((FriendlyByteBuf)buff, () -> null)) != null) {
                captured = CapturedBlocks.fromCompressedTag((HolderLookup.Provider)buff.registryAccess(), tag);
            }
            BoundingBox removeKey = NetworkUtil.readBoundingBox((FriendlyByteBuf)buff);
            return new EditClipboardPacket(ownerName, addKey, captured, removeKey);
        }
    };

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public static void handler(EditClipboardPacket packet, IPayloadContext context) {
        if (FMLEnvironment.dist == Dist.CLIENT) {
            context.enqueueWork(() -> EditClipboardPacket.handleClient(packet, context));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void handleClient(EditClipboardPacket packet, IPayloadContext context) {
        LocalPlayer player = Minecraft.getInstance().player;
        BuildingToolPlayerData data = StructureGelMod.proxy.getBuildingToolData(null, player.getGameProfile().getName());
        if (!packet.addKey.equals((Object)BoundingBox.infinite()) && packet.captured != null) {
            data.addToClipboardDirect(packet.addKey, packet.captured, packet.ownerName);
        }
        if (!packet.removeKey.equals((Object)BoundingBox.infinite())) {
            data.removeFromClipboard(packet.removeKey, packet.ownerName);
        }
    }
}

