/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.registry;

import com.legacy.structure_gel.api.registry.RegistrarHolder;
import com.legacy.structure_gel.api.registry.registrar.RegistrarHandler;
import com.legacy.structure_gel.core.StructureGelMod;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.neoforgespi.language.ModFileScanData;
import org.objectweb.asm.Type;

public class RegistrarLoader {
    private static boolean loaded = false;

    public static void loadRegistrars() {
        if (loaded) {
            return;
        }
        loaded = true;
        for (Map.Entry<String, List<RegistrarHandler<?>>> entry : RegistrarLoader.findHandlers(RegistrarHolder.class).entrySet()) {
            List<RegistrarHandler<?>> handlers = entry.getValue();
            String modID = entry.getKey();
            IEventBus modBus = ((ModContainer)ModList.get().getModContainerById(modID).get()).getEventBus();
            StructureGelMod.LOGGER.debug("Found and registering {} annotated {} for {}", handlers.size(), RegistrarLoader.handlerStr(), modID);
            RegistrarHandler.registerHandlers(modID, modBus, handlers);
        }
    }

    private static Map<String, List<RegistrarHandler<?>>> findHandlers(Class<?> annotation) {
        Type registrarHolder = Type.getType(annotation);
        HashMap handlers = new HashMap();
        for (ModFileScanData.AnnotationData annotationAata : ModList.get().getAllScanData().stream().map(ModFileScanData::getAnnotations).flatMap(Collection::stream).filter(a -> registrarHolder.equals((Object)a.annotationType())).toList()) {
            String className = annotationAata.memberName();
            try {
                Field[] fields;
                Class<?> clazz = Class.forName(className);
                for (Field field : fields = clazz.getDeclaredFields()) {
                    if (!RegistrarHandler.class.isAssignableFrom(field.getType())) continue;
                    int modifiers = field.getModifiers();
                    if (Modifier.isStatic(modifiers) && Modifier.isPublic(modifiers)) {
                        try {
                            RegistrarHandler handler = (RegistrarHandler)RegistrarHandler.class.cast(field.get(null));
                            String modID = handler.getModID();
                            handlers.computeIfAbsent(modID, m -> new LinkedList()).add(handler);
                            continue;
                        }
                        catch (IllegalAccessException | IllegalArgumentException e) {
                            throw new IllegalStateException("Failed to get " + RegistrarLoader.handlerStr() + " field " + String.valueOf(field) + " from class " + className);
                        }
                    }
                    throw new IllegalStateException("Failed to load " + RegistrarLoader.handlerStr() + " " + field.toString() + " as it must be public and static.");
                }
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("Failed to locate " + RegistrarLoader.annStr(annotation) + " class " + className);
            }
        }
        return handlers;
    }

    private static String handlerStr() {
        return RegistrarHandler.class.getSimpleName();
    }

    private static String annStr(Class<?> annotation) {
        return "@" + annotation.getSimpleName();
    }
}

