/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api.component;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.component.BarComponent;
import mcp.mobius.waila.api.util.WRenders;
import net.minecraft.client.DeltaTracker;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ARGB;
import org.joml.Matrix4f;

public class SpriteBarComponent
implements ITooltipComponent {
    private final float ratio;
    private final ResourceLocation texture;
    private final float u0;
    private final float u1;
    private final float v0;
    private final float v1;
    private final int spriteTint;
    private final int regionWidth;
    private final int regionHeight;
    private final Component text;

    public SpriteBarComponent(float ratio, ResourceLocation texture, float u0, float u1, float v0, float v1, int regionWidth, int regionHeight, int tint, Component text) {
        this.ratio = ratio;
        this.texture = texture;
        this.u0 = u0;
        this.u1 = u1;
        this.v0 = v0;
        this.v1 = v1;
        this.spriteTint = tint;
        this.regionWidth = regionWidth;
        this.regionHeight = regionHeight;
        this.text = text;
    }

    public SpriteBarComponent(float ratio, TextureAtlasSprite sprite, int regionWidth, int regionHeight, int tint, Component text) {
        this(ratio, sprite.atlasLocation(), sprite.getU0(), sprite.getU1(), sprite.getV0(), sprite.getV1(), regionWidth, regionHeight, tint, text);
    }

    @Override
    public int getWidth() {
        return Math.max(Minecraft.getInstance().font.width((FormattedText)this.text), 100);
    }

    @Override
    public int getHeight() {
        return 11;
    }

    @Override
    public void render(GuiGraphics ctx, int x, int y, DeltaTracker delta) {
        PoseStack ps = ctx.pose();
        BarComponent.renderBar(ctx, x, y, 100.0f, 0.0f, 0.4765625f, 0.04296875f, -5592406);
        int mx = (int)((float)x + 100.0f * this.ratio);
        int my = y + 11;
        ctx.enableScissor(x + 1, y + 1, mx - 1, my - 1);
        ps.pushPose();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        int a = ARGB.alpha((int)this.spriteTint);
        int r = ARGB.red((int)this.spriteTint);
        int g = ARGB.green((int)this.spriteTint);
        int b = ARGB.blue((int)this.spriteTint);
        VertexConsumer buffer = null;
        Matrix4f pose = ps.last().pose();
        for (int px1 = x; px1 < mx; px1 += this.regionWidth) {
            int px2 = px1 + this.regionWidth;
            for (int py1 = y; py1 < my; py1 += this.regionHeight) {
                int py2 = py1 + this.regionHeight;
                if (buffer == null) {
                    buffer = WRenders.buffer(ctx, RenderType.guiTextured((ResourceLocation)this.texture));
                }
                buffer.addVertex(pose, (float)px1, (float)py2, 0.0f).setUv(this.u0, this.v1).setColor(r, g, b, a);
                buffer.addVertex(pose, (float)px2, (float)py2, 0.0f).setUv(this.u1, this.v1).setColor(r, g, b, a);
                buffer.addVertex(pose, (float)px2, (float)py1, 0.0f).setUv(this.u1, this.v0).setColor(r, g, b, a);
                buffer.addVertex(pose, (float)px1, (float)py1, 0.0f).setUv(this.u0, this.v0).setColor(r, g, b, a);
            }
        }
        RenderSystem.disableBlend();
        ps.popPose();
        ctx.disableScissor();
        ctx.flush();
        BarComponent.renderText(ctx, this.text, x, y);
    }
}

