/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.hud.theme;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.gui.hud.theme.ThemeDefinition;
import mcp.mobius.waila.util.Log;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.jetbrains.annotations.NotNull;

public class BuiltinThemeLoader
extends SimplePreparableReloadListener<Map<ResourceLocation, JsonElement>> {
    private static final Log LOG = Log.create();
    public static final Map<ResourceLocation, ThemeDefinition<?>> THEMES = new HashMap();
    public static final ResourceLocation ID = Waila.id("builtin_themes");

    protected Map<ResourceLocation, JsonElement> prepare(ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        HashMap<ResourceLocation, JsonElement> map = new HashMap<ResourceLocation, JsonElement>();
        FileToIdConverter fileToIdConverter = FileToIdConverter.json((String)"waila_themes");
        for (Map.Entry entry : fileToIdConverter.listMatchingResources(resourceManager).entrySet()) {
            ResourceLocation resourceLocation = (ResourceLocation)entry.getKey();
            ResourceLocation resourceLocation2 = fileToIdConverter.fileToId(resourceLocation);
            try {
                BufferedReader reader = ((Resource)entry.getValue()).openAsReader();
                try {
                    JsonElement json = JsonParser.parseReader((Reader)reader);
                    map.put(resourceLocation2, json);
                }
                finally {
                    if (reader == null) continue;
                    reader.close();
                }
            }
            catch (IOException e) {
                LOG.error("Couldn't parse data file '{}' from '{}'", resourceLocation2, resourceLocation, e);
            }
        }
        return map;
    }

    protected void apply(@NotNull Map<ResourceLocation, JsonElement> map, @NotNull ResourceManager manager, @NotNull ProfilerFiller profiler) {
        THEMES.clear();
        map.forEach((id, json) -> {
            try {
                Waila.CONFIG.get().getOverlay().getColor().getCustomThemes().remove(id);
                THEMES.put((ResourceLocation)id, ThemeDefinition.Adapter.deserialize(id, json, true));
            }
            catch (Exception e) {
                LOG.error("Couldn't parse builtin theme definition {}", id, (Object)e);
            }
        });
        Waila.CONFIG.save();
    }
}

