/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.screen;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.InputConstants;
import java.awt.Rectangle;
import mcp.mobius.waila.Waila;
import mcp.mobius.waila.WailaClient;
import mcp.mobius.waila.api.IModInfo;
import mcp.mobius.waila.api.ITheme;
import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.api.component.ItemComponent;
import mcp.mobius.waila.config.WailaConfig;
import mcp.mobius.waila.gui.hud.Line;
import mcp.mobius.waila.gui.hud.TooltipRenderer;
import mcp.mobius.waila.gui.hud.theme.ThemeDefinition;
import mcp.mobius.waila.gui.screen.ConfigScreen;
import mcp.mobius.waila.gui.screen.ThemeEditorScreen;
import mcp.mobius.waila.gui.widget.ButtonEntry;
import mcp.mobius.waila.gui.widget.CategoryEntry;
import mcp.mobius.waila.gui.widget.ConfigListWidget;
import mcp.mobius.waila.gui.widget.value.BooleanValue;
import mcp.mobius.waila.gui.widget.value.ConfigValue;
import mcp.mobius.waila.gui.widget.value.CycleValue;
import mcp.mobius.waila.gui.widget.value.EnumValue;
import mcp.mobius.waila.gui.widget.value.InputValue;
import mcp.mobius.waila.mixin.KeyMappingAccess;
import mcp.mobius.waila.util.DisplayUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WailaConfigScreen
extends ConfigScreen {
    private static final Component PREVIEW_PROMPT = Component.translatable((String)"config.waila.preview_prompt");
    private final WailaConfig defaultConfig = new WailaConfig();
    private final TooltipRenderer.State previewState = new PreviewTooltipRendererState();
    @Nullable
    private ThemeDefinition<?> theme;
    private boolean f1held = false;
    private ConfigValue<String> modNameFormatVal;
    private ConfigValue<String> blockNameFormatVal;
    private ConfigValue<Integer> fpsVal;
    private ConfigValue<Integer> xPosValue;
    private ConfigValue<IWailaConfig.Overlay.Position.Align.X> xAnchorValue;
    private ConfigValue<IWailaConfig.Overlay.Position.Align.Y> yAnchorValue;
    private ConfigValue<IWailaConfig.Overlay.Position.Align.X> xAlignValue;
    private ConfigValue<IWailaConfig.Overlay.Position.Align.Y> yAlignValue;
    private ConfigValue<Integer> yPosValue;
    private ConfigValue<Float> scaleValue;
    private ConfigValue<Integer> backgroundAlphaVal;
    private ThemeValue themeIdVal;
    @Nullable
    private KeyBindValue selectedKeyBind;

    public WailaConfigScreen(Screen parent) {
        super(parent, (Component)Component.translatable((String)"gui.waila.configuration", (Object[])new Object[]{"WTHIT"}), Waila.CONFIG::save, Waila.CONFIG::invalidate);
    }

    private static WailaConfig get() {
        return Waila.CONFIG.get();
    }

    public Rectangle buildPreview(TooltipRenderer.State state) {
        TooltipRenderer.beginBuild(state);
        TooltipRenderer.setIcon(new ItemComponent((ItemLike)Blocks.GRASS_BLOCK));
        TooltipRenderer.add(new Line(null).with((Component)Component.literal((String)DisplayUtil.tryFormat(this.blockNameFormatVal.getValue(), Blocks.GRASS_BLOCK.getName().getString()))));
        TooltipRenderer.add(new Line(null).with((Component)Component.literal((String)"never gonna give you up").withStyle(ChatFormatting.OBFUSCATED)));
        TooltipRenderer.add(new Line(null).with((Component)Component.literal((String)DisplayUtil.tryFormat(this.modNameFormatVal.getValue(), IModInfo.get(Blocks.GRASS_BLOCK).getName()))));
        return TooltipRenderer.endBuild();
    }

    public void addTheme(ThemeDefinition<?> theme) {
        WailaConfigScreen.get().getOverlay().getColor().getCustomThemes().put(theme.id, theme);
        ThemeDefinition.resetAll();
        String id = theme.id.toString();
        this.themeIdVal.addValue(id);
        this.themeIdVal.setValue(id);
        this.theme = theme;
    }

    public void removeTheme(ResourceLocation id) {
        WailaConfigScreen.get().getOverlay().getColor().getCustomThemes().remove(id);
        ThemeDefinition.resetAll();
        this.themeIdVal.removeValue(id.toString());
        this.theme = null;
    }

    private ThemeDefinition<?> getTheme() {
        if (this.theme == null) {
            this.theme = ThemeDefinition.getAll().get(ResourceLocation.parse((String)((String)this.themeIdVal.getValue())));
        }
        return this.theme;
    }

    @Override
    public void render(@NotNull GuiGraphics ctx, int mouseX, int mouseY, float partialTicks) {
        if (InputConstants.isKeyDown((long)this.minecraft.getWindow().getWindow(), (int)290)) {
            if (!this.f1held) {
                this.f1held = true;
                this.buildPreview(this.previewState);
            }
            this.renderBackground(ctx, mouseX, mouseY, partialTicks);
            TooltipRenderer.render(ctx, this.minecraft.getDeltaTracker());
        } else {
            TooltipRenderer.resetState();
            this.f1held = false;
            this.theme = null;
            super.render(ctx, mouseX, mouseY, partialTicks);
        }
    }

    @Override
    protected void renderForeground(GuiGraphics ctx, int rowLeft, int rowWidth, int mouseX, int mouseY, float partialTicks) {
        super.renderForeground(ctx, rowLeft, rowWidth, mouseX, mouseY, partialTicks);
        ctx.drawString(this.font, PREVIEW_PROMPT, rowLeft, 22, 0xAAAAAA);
    }

    @Override
    public ConfigListWidget getOptions() {
        ConfigListWidget options = new ConfigListWidget(this, this.minecraft, this.width, this.height, 42, this.height - 32, 26, Waila.CONFIG::save);
        options.with(new CategoryEntry("config.waila.general").with(new BooleanValue("config.waila.display_tooltip", WailaConfigScreen.get().getGeneral().isDisplayTooltip(), this.defaultConfig.getGeneral().isDisplayTooltip(), val -> WailaConfigScreen.get().getGeneral().setDisplayTooltip((boolean)val))).with(new BooleanValue("config.waila.sneaky_details", WailaConfigScreen.get().getGeneral().isShiftForDetails(), this.defaultConfig.getGeneral().isShiftForDetails(), val -> WailaConfigScreen.get().getGeneral().setShiftForDetails((boolean)val))).with(new BooleanValue("config.waila.hide_sneak_text", WailaConfigScreen.get().getGeneral().isHideShiftText(), this.defaultConfig.getGeneral().isHideShiftText(), val -> WailaConfigScreen.get().getGeneral().setHideShiftText((boolean)val))).with(new EnumValue("config.waila.display_mode", (Enum[])IWailaConfig.General.DisplayMode.values(), (Enum)WailaConfigScreen.get().getGeneral().getDisplayMode(), (Enum)this.defaultConfig.getGeneral().getDisplayMode(), val -> WailaConfigScreen.get().getGeneral().setDisplayMode((IWailaConfig.General.DisplayMode)((Object)val)))).with(new BooleanValue("config.waila.hide_from_players", WailaConfigScreen.get().getGeneral().isHideFromPlayerList(), this.defaultConfig.getGeneral().isHideFromPlayerList(), val -> WailaConfigScreen.get().getGeneral().setHideFromPlayerList((boolean)val))).with(new BooleanValue("config.waila.hide_from_debug", WailaConfigScreen.get().getGeneral().isHideFromDebug(), this.defaultConfig.getGeneral().isHideFromDebug(), val -> WailaConfigScreen.get().getGeneral().setHideFromDebug((boolean)val))).with(new BooleanValue("config.waila.tts", WailaConfigScreen.get().getGeneral().isEnableTextToSpeech(), this.defaultConfig.getGeneral().isEnableTextToSpeech(), val -> WailaConfigScreen.get().getGeneral().setEnableTextToSpeech((boolean)val))).with(new InputValue<Integer>("config.waila.rate_limit", WailaConfigScreen.get().getGeneral().getRateLimit(), this.defaultConfig.getGeneral().getRateLimit(), val -> WailaConfigScreen.get().getGeneral().setRateLimit(Math.max(val, 250)), InputValue.POSITIVE_INTEGER)).with(new ButtonEntry("config.waila.blacklist", "config.waila.blacklist_open", 100, 20, w -> Util.getPlatform().openFile(Waila.BLACKLIST_CONFIG.getPath().toFile()))));
        this.fpsVal = (ConfigValue)((Object)Util.make(new InputValue<Integer>("config.waila.overlay_fps", WailaConfigScreen.get().getOverlay().getFps(), this.defaultConfig.getOverlay().getFps(), val -> WailaConfigScreen.get().getOverlay().setFps((int)val), InputValue.POSITIVE_INTEGER), it -> it.disable("config.waila.overlay_fps.disabled_reason")));
        this.xAnchorValue = new EnumValue("config.waila.overlay_anchor_x", (Enum[])IWailaConfig.Overlay.Position.Align.X.values(), (Enum)WailaConfigScreen.get().getOverlay().getPosition().getAnchor().getX(), (Enum)this.defaultConfig.getOverlay().getPosition().getAnchor().getX(), val -> WailaConfigScreen.get().getOverlay().getPosition().getAnchor().setX((IWailaConfig.Overlay.Position.Align.X)((Object)val)));
        this.yAnchorValue = new EnumValue("config.waila.overlay_anchor_y", (Enum[])IWailaConfig.Overlay.Position.Align.Y.values(), (Enum)WailaConfigScreen.get().getOverlay().getPosition().getAnchor().getY(), (Enum)this.defaultConfig.getOverlay().getPosition().getAnchor().getY(), val -> WailaConfigScreen.get().getOverlay().getPosition().getAnchor().setY((IWailaConfig.Overlay.Position.Align.Y)((Object)val)));
        this.xAlignValue = new EnumValue("config.waila.overlay_align_x", (Enum[])IWailaConfig.Overlay.Position.Align.X.values(), (Enum)WailaConfigScreen.get().getOverlay().getPosition().getAlign().getX(), (Enum)this.defaultConfig.getOverlay().getPosition().getAlign().getX(), val -> WailaConfigScreen.get().getOverlay().getPosition().getAlign().setX((IWailaConfig.Overlay.Position.Align.X)((Object)val)));
        this.yAlignValue = new EnumValue("config.waila.overlay_align_y", (Enum[])IWailaConfig.Overlay.Position.Align.Y.values(), (Enum)WailaConfigScreen.get().getOverlay().getPosition().getAlign().getY(), (Enum)this.defaultConfig.getOverlay().getPosition().getAlign().getY(), val -> WailaConfigScreen.get().getOverlay().getPosition().getAlign().setY((IWailaConfig.Overlay.Position.Align.Y)((Object)val)));
        this.xPosValue = new InputValue<Integer>("config.waila.overlay_pos_x", WailaConfigScreen.get().getOverlay().getPosition().getX(), this.defaultConfig.getOverlay().getPosition().getX(), val -> WailaConfigScreen.get().getOverlay().getPosition().setX((int)val), InputValue.INTEGER);
        this.yPosValue = new InputValue<Integer>("config.waila.overlay_pos_y", WailaConfigScreen.get().getOverlay().getPosition().getY(), this.defaultConfig.getOverlay().getPosition().getY(), val -> WailaConfigScreen.get().getOverlay().getPosition().setY((int)val), InputValue.INTEGER);
        this.scaleValue = new InputValue<Float>("config.waila.overlay_scale", Float.valueOf(WailaConfigScreen.get().getOverlay().getScale()), Float.valueOf(this.defaultConfig.getOverlay().getScale()), val -> WailaConfigScreen.get().getOverlay().setScale(Math.max(val.floatValue(), 0.0f)), InputValue.POSITIVE_DECIMAL);
        this.backgroundAlphaVal = new InputValue<Integer>("config.waila.overlay_background_alpha", WailaConfigScreen.get().getOverlay().getColor().getBackgroundAlpha(), this.defaultConfig.getOverlay().getColor().getBackgroundAlpha(), val -> WailaConfigScreen.get().getOverlay().getColor().setBackgroundAlpha(Mth.clamp((int)val, (int)0, (int)255)), InputValue.POSITIVE_INTEGER);
        this.themeIdVal = new ThemeValue();
        options.with(new CategoryEntry("config.waila.overlay").with(this.fpsVal).with(this.xAnchorValue).with(this.yAnchorValue).with(this.xAlignValue).with(this.yAlignValue).with(this.xPosValue).with(this.yPosValue).with(new BooleanValue("config.waila.boss_bars_overlap", WailaConfigScreen.get().getOverlay().getPosition().isBossBarsOverlap(), this.defaultConfig.getOverlay().getPosition().isBossBarsOverlap(), val -> WailaConfigScreen.get().getOverlay().getPosition().setBossBarsOverlap((boolean)val))).with(this.scaleValue).with(this.backgroundAlphaVal).with(this.themeIdVal));
        this.modNameFormatVal = new InputValue<String>("config.waila.format_mod_name", WailaConfigScreen.get().getFormatter().getModName(), this.defaultConfig.getFormatter().getModName(), val -> WailaConfigScreen.get().getFormatter().setModName(!val.contains("%s") ? WailaConfigScreen.get().getFormatter().getModName() : val), InputValue.ANY);
        this.blockNameFormatVal = new InputValue<String>("config.waila.format_block_name", WailaConfigScreen.get().getFormatter().getBlockName(), this.defaultConfig.getFormatter().getBlockName(), val -> WailaConfigScreen.get().getFormatter().setBlockName(!val.contains("%s") ? WailaConfigScreen.get().getFormatter().getBlockName() : val), InputValue.ANY);
        options.with(new CategoryEntry("config.waila.formatting").with(this.modNameFormatVal).with(this.blockNameFormatVal).with(new InputValue<String>("config.waila.format_fluid_name", WailaConfigScreen.get().getFormatter().getFluidName(), this.defaultConfig.getFormatter().getFluidName(), val -> WailaConfigScreen.get().getFormatter().setFluidName(!val.contains("%s") ? WailaConfigScreen.get().getFormatter().getFluidName() : val), InputValue.ANY)).with(new InputValue<String>("config.waila.format_entity_name", WailaConfigScreen.get().getFormatter().getEntityName(), this.defaultConfig.getFormatter().getEntityName(), val -> WailaConfigScreen.get().getFormatter().setEntityName(!val.contains("%s") ? WailaConfigScreen.get().getFormatter().getEntityName() : val), InputValue.ANY)).with(new InputValue<String>("config.waila.format_registry_name", WailaConfigScreen.get().getFormatter().getRegistryName(), this.defaultConfig.getFormatter().getRegistryName(), val -> WailaConfigScreen.get().getFormatter().setRegistryName(!val.contains("%s") ? WailaConfigScreen.get().getFormatter().getRegistryName() : val), InputValue.ANY)));
        options.with(new CategoryEntry("config.waila.keybinds").with(new KeyBindValue(WailaClient.keyOpenConfig)).with(new KeyBindValue(WailaClient.keyShowOverlay)).with(new KeyBindValue(WailaClient.keyToggleLiquid)).with(new KeyBindValue(WailaClient.keyShowRecipeInput)).with(new KeyBindValue(WailaClient.keyShowRecipeOutput)));
        return options;
    }

    @Override
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.selectedKeyBind != null) {
            this.selectedKeyBind.setValue(InputConstants.Type.MOUSE.getOrCreate(button));
            this.selectedKeyBind = null;
            return true;
        }
        return this.f1held || super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (this.selectedKeyBind != null) {
            if (keyCode == 256) {
                this.selectedKeyBind.setValue(InputConstants.UNKNOWN);
            } else {
                this.selectedKeyBind.setValue(InputConstants.getKey((int)keyCode, (int)scanCode));
            }
            this.selectedKeyBind = null;
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    private class PreviewTooltipRendererState
    implements TooltipRenderer.State {
        private PreviewTooltipRendererState() {
        }

        @Override
        public boolean render() {
            return true;
        }

        @Override
        public boolean fireEvent() {
            return false;
        }

        @Override
        public int getFps() {
            return WailaConfigScreen.this.fpsVal.getValue();
        }

        @Override
        public int getBackgroundAlpha() {
            return WailaConfigScreen.this.backgroundAlphaVal.getValue();
        }

        @Override
        public float getScale() {
            return WailaConfigScreen.this.scaleValue.getValue().floatValue();
        }

        @Override
        public IWailaConfig.Overlay.Position.Align.X getXAnchor() {
            return WailaConfigScreen.this.xAnchorValue.getValue();
        }

        @Override
        public IWailaConfig.Overlay.Position.Align.Y getYAnchor() {
            return WailaConfigScreen.this.yAnchorValue.getValue();
        }

        @Override
        public IWailaConfig.Overlay.Position.Align.X getXAlign() {
            return WailaConfigScreen.this.xAlignValue.getValue();
        }

        @Override
        public IWailaConfig.Overlay.Position.Align.Y getYAlign() {
            return WailaConfigScreen.this.yAlignValue.getValue();
        }

        @Override
        public int getX() {
            return WailaConfigScreen.this.xPosValue.getValue();
        }

        @Override
        public int getY() {
            return WailaConfigScreen.this.yPosValue.getValue();
        }

        @Override
        public boolean bossBarsOverlap() {
            return false;
        }

        @Override
        public ITheme getTheme() {
            return WailaConfigScreen.this.getTheme().getInitializedInstance();
        }

        @Override
        public boolean enableTextToSpeech() {
            return false;
        }
    }

    private class ThemeValue
    extends CycleValue {
        private final Button editButton;
        private final Button newButton;

        public ThemeValue() {
            super("config.waila.overlay_theme", (String[])ThemeDefinition.getAll().values().stream().map(t -> t.id.toString()).sorted(String::compareToIgnoreCase).toArray(String[]::new), WailaConfigScreen.get().getOverlay().getColor().getActiveTheme().toString(), val -> WailaConfigScreen.get().getOverlay().getColor().applyTheme(ResourceLocation.parse((String)val)), false);
            this.editButton = DisplayUtil.createButton(0, 0, 40, 20, (Component)Component.translatable((String)"config.waila.edit"), button -> this.client.setScreen((Screen)new ThemeEditorScreen(WailaConfigScreen.this, WailaConfigScreen.this.getTheme(), true)));
            this.newButton = DisplayUtil.createButton(0, 0, 40, 20, (Component)Component.translatable((String)"config.waila.new"), button -> this.client.setScreen((Screen)new ThemeEditorScreen(WailaConfigScreen.this, WailaConfigScreen.this.getTheme(), false)));
            this.reloadEditButton();
        }

        private void reloadEditButton() {
            this.editButton.active = !ThemeDefinition.getAll().get((Object)ResourceLocation.parse((String)((String)this.getValue()))).builtin;
        }

        @Override
        protected void gatherChildren(ImmutableList.Builder<GuiEventListener> children) {
            super.gatherChildren(children);
            children.add((Object)this.editButton);
            children.add((Object)this.newButton);
        }

        @Override
        public void setValue(String value) {
            super.setValue(value);
            this.reloadEditButton();
        }

        @Override
        protected void drawValue(GuiGraphics ctx, int width, int height, int x, int y, int mouseX, int mouseY, boolean selected, float partialTicks) {
            this.newButton.setX(x + width - this.newButton.getWidth());
            this.newButton.setY(y + (height - this.newButton.getHeight()) / 2);
            this.editButton.setX(this.newButton.getX() - this.newButton.getWidth() - 2);
            this.editButton.setY(this.newButton.getY());
            this.editButton.render(ctx, mouseX, mouseY, partialTicks);
            this.newButton.render(ctx, mouseX, mouseY, partialTicks);
            super.drawValue(ctx, width - 84, height, x, y, mouseX, mouseY, selected, partialTicks);
        }
    }

    public class KeyBindValue
    extends ConfigValue<InputConstants.Key> {
        private final Button button;

        public KeyBindValue(KeyMapping key) {
            super(key.getName(), ((KeyMappingAccess)key).wthit_key(), key.getDefaultKey(), value -> {
                key.setKey(value);
                KeyMapping.resetMapping();
            });
            this.button = DisplayUtil.createButton(0, 0, 100, 20, (Component)Component.empty(), w -> {
                WailaConfigScreen.this.selectedKeyBind = this;
            });
        }

        @Override
        public GuiEventListener getListener() {
            return this.button;
        }

        @Override
        protected void drawValue(GuiGraphics ctx, int width, int height, int x, int y, int mouseX, int mouseY, boolean selected, float partialTicks) {
            if (WailaConfigScreen.this.selectedKeyBind == this) {
                this.button.setMessage((Component)Component.literal((String)("> " + ((InputConstants.Key)this.getValue()).getDisplayName().getString() + " <")).withStyle(ChatFormatting.YELLOW));
            } else {
                this.button.setMessage(((InputConstants.Key)this.getValue()).getDisplayName());
            }
            this.button.setX(x + width - this.button.getWidth());
            this.button.setY(y + (height - this.button.getHeight()) / 2);
            this.button.render(ctx, mouseX, mouseY, partialTicks);
        }
    }
}

