/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.widget;

import com.google.common.collect.ImmutableList;
import com.google.gson.reflect.TypeToken;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import mcp.mobius.waila.api.IJsonConfig;
import mcp.mobius.waila.gui.widget.ConfigListWidget;
import mcp.mobius.waila.util.DisplayUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.apache.commons.lang3.StringUtils;

public class CategoryEntry
extends ConfigListWidget.Entry {
    private static final IJsonConfig<Map<String, Boolean>> STATES = IJsonConfig.of(new TypeToken<Map<String, Boolean>>(){}).file("waila/category_entries").json5().factory(HashMap::new).commenter(() -> p -> !p.isEmpty() ? null : "This config controls the category entries collapsed state.\nYou shouldn't edit this config by hand.\n").build();
    public final Component title;
    private final String key;
    private final Button collapseButton;
    private final Button expandAllButton;
    private final List<ConfigListWidget.Entry> children = new ArrayList<ConfigListWidget.Entry>();
    private boolean collapsed;
    private boolean hasNested = false;
    private boolean filterMatchParent = false;

    public CategoryEntry(String title) {
        this.key = title;
        this.title = Component.translatable((String)title).withStyle(ChatFormatting.BOLD);
        this.collapseButton = DisplayUtil.createButton(0, 0, 12, 12, CommonComponents.EMPTY, b -> this.toggleCollapse());
        this.expandAllButton = DisplayUtil.createButton(0, 0, 20, 12, (Component)Component.literal((String)"++"), b -> {
            this.setCollapse(false, true);
            this.list.init();
            this.list.setFocused((GuiEventListener)this);
            this.setFocused((GuiEventListener)b);
        });
        this.expandAllButton.setTooltip(Tooltip.create((Component)Component.translatable((String)"config.waila.expand_all")));
        this.collapsed = Boolean.TRUE.equals(STATES.get().putIfAbsent(this.key, false));
        STATES.save();
    }

    public CategoryEntry with(ConfigListWidget.Entry child) {
        child.category = this;
        child.categoryDepth = this.categoryDepth + 1;
        this.children.add(child);
        if (child instanceof CategoryEntry) {
            this.hasNested = true;
        }
        return this;
    }

    @Override
    public int init() {
        boolean expand = !this.collapsed || this.list.filter != null;
        this.collapseButton.setMessage((Component)Component.literal((String)(!expand ? "+" : "-")));
        int added = 1;
        boolean matchCategory = StringUtils.containsIgnoreCase((CharSequence)this.title.getString(), (CharSequence)this.list.filter);
        if (this.category != null) {
            boolean bl = matchCategory = matchCategory || this.filterMatchParent;
        }
        if (expand) {
            for (ConfigListWidget.Entry child : this.children) {
                if (child instanceof CategoryEntry) {
                    CategoryEntry nest = (CategoryEntry)child;
                    nest.filterMatchParent = matchCategory;
                }
                if (!matchCategory && this.list.splitFilter != null && !child.match(this.list.splitFilter)) continue;
                this.list.add(this.index + added, child);
                added += child.init(this.list, this.index + added);
            }
        }
        return added;
    }

    @Override
    public void clear(ConfigListWidget list) {
        list.children().removeIf(it -> it.category == this);
        for (ConfigListWidget.Entry child : this.children) {
            child.clear(list);
        }
    }

    private void setCollapse(boolean collapsed, boolean deep) {
        this.collapsed = collapsed;
        STATES.get().put(this.key, collapsed);
        STATES.save();
        if (deep) {
            for (ConfigListWidget.Entry child : this.children) {
                if (!(child instanceof CategoryEntry)) continue;
                CategoryEntry entry = (CategoryEntry)child;
                entry.setCollapse(collapsed, true);
            }
        }
    }

    private void toggleCollapse() {
        if (!this.collapsed) {
            this.setCollapse(true, true);
        } else {
            this.setCollapse(false, false);
        }
        this.list.init();
        this.list.setFocused((GuiEventListener)this);
        this.setFocused((GuiEventListener)this.collapseButton);
    }

    @Override
    protected void gatherChildren(ImmutableList.Builder<GuiEventListener> children) {
        children.add((Object)this.collapseButton);
        children.add((Object)this.expandAllButton);
    }

    @Override
    protected void drawEntry(GuiGraphics ctx, int index, int rowTop, int rowLeft, int width, int height, int mouseX, int mouseY, boolean hovered, float deltaTime) {
        int buttonY = rowTop + (height - this.collapseButton.getHeight()) / 2;
        boolean hasFilter = this.list.filter != null;
        this.collapseButton.active = !hasFilter;
        this.collapseButton.setX(rowLeft);
        this.collapseButton.setY(buttonY);
        this.collapseButton.render(ctx, mouseX, mouseY, deltaTime);
        Font font = this.client.font;
        int n = rowLeft + this.collapseButton.getWidth() + 4;
        Objects.requireNonNull(this.client.font);
        ctx.drawString(font, this.title, n, rowTop + (height - 9) / 2 + 1, 0xFFFFFF);
        boolean bl = this.expandAllButton.active = this.hasNested && !hasFilter;
        if (this.expandAllButton.active) {
            this.expandAllButton.setX(rowLeft + width - this.expandAllButton.getWidth());
            this.expandAllButton.setY(buttonY);
            this.expandAllButton.render(ctx, mouseX, mouseY, deltaTime);
        }
    }

    @Override
    protected void buildSearchKey(StringBuilder sb) {
        sb.append(this.title.getString());
        if (!this.children.isEmpty()) {
            sb.append(" ");
            for (ConfigListWidget.Entry child : this.children) {
                child.buildSearchKey(sb);
            }
        }
    }
}

