/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.neo.provider;

import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IDataWriter;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerAccessor;
import mcp.mobius.waila.api.data.EnergyData;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.capabilities.BlockCapability;
import net.neoforged.neoforge.capabilities.BlockCapabilityCache;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.energy.IEnergyStorage;
import org.jetbrains.annotations.Nullable;

public enum EnergyCapabilityProvider implements IDataProvider<BlockEntity>
{
    INSTANCE;

    @Nullable
    private @Nullable BlockCapabilityCache<IEnergyStorage, @Nullable Direction> cache;

    @Override
    public void appendData(IDataWriter data, IServerAccessor<BlockEntity> accessor, IPluginConfig config) {
        data.add(EnergyData.TYPE, res -> {
            IEnergyStorage storage;
            ServerLevel world = (ServerLevel)accessor.getWorld();
            BlockEntity target = (BlockEntity)accessor.getTarget();
            BlockPos pos = target.getBlockPos();
            if (this.cache == null || this.cache.level() != world && !this.cache.pos().equals((Object)pos)) {
                this.cache = BlockCapabilityCache.create((BlockCapability)Capabilities.EnergyStorage.BLOCK, (ServerLevel)world, (BlockPos)pos, null);
            }
            if ((storage = (IEnergyStorage)this.cache.getCapability()) == null) {
                return;
            }
            res.add(EnergyData.of(storage.getEnergyStored(), storage.getMaxEnergyStored()));
        });
    }
}

