/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.test;

import com.google.common.base.Preconditions;
import io.netty.buffer.ByteBuf;
import mcp.mobius.waila.api.IBlockAccessor;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IData;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IDataWriter;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerAccessor;
import mcp.mobius.waila.api.ITooltip;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BarrelBlockEntity;

public enum RequestDataTest implements IBlockComponentProvider,
IDataProvider<BarrelBlockEntity>
{
    INSTANCE;

    public static final ResourceLocation ENABLED;
    public static final ResourceLocation RAW;
    public static final ResourceLocation TYPED;
    public static final IData.Type<Ctx> CTX;
    public static final StreamCodec<ByteBuf, Ctx> CTX_CODEC;
    public static final IData.Type<Data> DATA;
    public static final StreamCodec<ByteBuf, Data> DATA_CODEC;

    @Override
    public void appendDataContext(IDataWriter ctx, IBlockAccessor accessor, IPluginConfig config) {
        Preconditions.checkState((boolean)accessor.getData().raw().isEmpty());
        Preconditions.checkState((accessor.getData().get(DATA) == null ? 1 : 0) != 0);
        if (!config.getBoolean(ENABLED)) {
            return;
        }
        if (config.getBoolean(RAW)) {
            ctx.raw().putString("kyk", "NIHAHAHAHA");
        }
        if (config.getBoolean(TYPED)) {
            ctx.addImmediate(new Ctx("gomen yuuka"));
        }
    }

    @Override
    public void appendData(IDataWriter data, IServerAccessor<BarrelBlockEntity> accessor, IPluginConfig config) {
        CompoundTag raw = accessor.getContext().raw();
        if (raw.contains("kyk")) {
            data.raw().putString("kyk", raw.getString("kyk"));
        }
        data.add(DATA, res -> {
            Ctx ctx = accessor.getContext().get(CTX);
            if (ctx == null) {
                return;
            }
            res.add(new Data(ctx.msg));
        });
    }

    @Override
    public void appendBody(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
        Data data;
        CompoundTag raw = accessor.getData().raw();
        if (raw.contains("kyk")) {
            tooltip.addLine((Component)Component.literal((String)raw.getString("kyk")));
        }
        if ((data = accessor.getData().get(DATA)) != null) {
            tooltip.addLine((Component)Component.literal((String)data.msg));
        }
    }

    static {
        ENABLED = ResourceLocation.parse((String)"test:data.ctx");
        RAW = ResourceLocation.parse((String)"test:data.ctx.raw");
        TYPED = ResourceLocation.parse((String)"test:data.ctx.typed");
        CTX = IData.createType(ResourceLocation.parse((String)"test:data.ctx.ctx"));
        CTX_CODEC = ByteBufCodecs.STRING_UTF8.map(Ctx::new, Ctx::msg);
        DATA = IData.createType(ResourceLocation.parse((String)"test:data.ctx.data"));
        DATA_CODEC = ByteBufCodecs.STRING_UTF8.map(Data::new, Data::msg);
    }

    public record Ctx(String msg) implements IData
    {
        @Override
        public IData.Type<? extends IData> type() {
            return CTX;
        }
    }

    public record Data(String msg) implements IData
    {
        @Override
        public IData.Type<? extends IData> type() {
            return DATA;
        }
    }
}

