/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.vanilla.provider;

import it.unimi.dsi.fastutil.objects.Object2IntLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import mcp.mobius.waila.api.IBlockAccessor;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.component.PairComponent;
import mcp.mobius.waila.plugin.vanilla.config.Options;
import mcp.mobius.waila.plugin.vanilla.provider.data.BeehiveDataProvider;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.level.block.BeehiveBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public enum BeehiveProvider implements IBlockComponentProvider
{
    INSTANCE;


    @Override
    public void appendBody(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
        BeehiveDataProvider.OccupantsData occupants = accessor.getData().get(BeehiveDataProvider.OCCUPANTS);
        if (occupants != null && config.getBoolean(Options.BEE_HIVE_OCCUPANTS)) {
            String name;
            Object2IntLinkedOpenHashMap names = new Object2IntLinkedOpenHashMap(occupants.occupants().size());
            for (BeehiveDataProvider.OccupantsData.Occupant occupant : occupants.occupants()) {
                Component component = null;
                if (occupant.customName() != null) {
                    component = Component.Serializer.fromJson((String)occupant.customName(), (HolderLookup.Provider)accessor.getWorld().registryAccess());
                }
                if (component == null) {
                    component = occupant.entityType().getDescription();
                }
                name = component.getString();
                names.put((Object)name, names.getOrDefault((Object)name, 0) + 1);
            }
            if (!names.isEmpty()) {
                MutableComponent component = Component.empty();
                for (Object2IntMap.Entry entry : names.object2IntEntrySet()) {
                    if (!component.getSiblings().isEmpty()) {
                        component.append(CommonComponents.NEW_LINE);
                    }
                    name = (String)entry.getKey();
                    int count = entry.getIntValue();
                    if (count > 1) {
                        component.append((Component)Component.literal((String)(count + " " + name)));
                        continue;
                    }
                    component.append((Component)Component.literal((String)name));
                }
                tooltip.setLine(Options.BEE_HIVE_OCCUPANTS, (Component)component);
            }
        }
        if (config.getBoolean(Options.BEE_HIVE_HONEY_LEVEL)) {
            BlockState state = accessor.getBlockState();
            tooltip.setLine(Options.BEE_HIVE_HONEY_LEVEL, new PairComponent((Component)Component.translatable((String)"tooltip.waila.honey_level"), (Component)Component.literal((String)((Integer)state.getValue((Property)BeehiveBlock.HONEY_LEVEL)).toString())));
        }
    }
}

