/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.vanilla.provider;

import mcp.mobius.waila.api.IBlockAccessor;
import mcp.mobius.waila.api.IBlockComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.component.ItemComponent;
import mcp.mobius.waila.plugin.vanilla.config.Options;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;

public enum PlayerHeadProvider implements IBlockComponentProvider
{
    INSTANCE;

    static final ItemStack PLAYER_HEAD_STACK;

    @Override
    @Nullable
    public ITooltipComponent getIcon(IBlockAccessor accessor, IPluginConfig config) {
        SkullBlockEntity skull = (SkullBlockEntity)accessor.getBlockEntity();
        if (skull != null && skull.getOwnerProfile() != null) {
            PLAYER_HEAD_STACK.set(DataComponents.PROFILE, (Object)skull.getOwnerProfile());
            return new ItemComponent(PLAYER_HEAD_STACK);
        }
        return null;
    }

    @Override
    public void appendBody(ITooltip tooltip, IBlockAccessor accessor, IPluginConfig config) {
        SkullBlockEntity skull;
        if (config.getBoolean(Options.PLAYER_HEAD_NAME) && (skull = (SkullBlockEntity)accessor.getBlockEntity()) != null && skull.getOwnerProfile() != null && !StringUtils.isBlank((CharSequence)skull.getOwnerProfile().gameProfile().getName())) {
            tooltip.setLine(Options.PLAYER_HEAD_NAME, (Component)Component.translatable((String)skull.getOwnerProfile().gameProfile().getName()));
        }
    }

    static {
        PLAYER_HEAD_STACK = new ItemStack((ItemLike)Items.PLAYER_HEAD);
    }
}

