/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.vanilla.provider.data;

import java.util.Optional;
import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IDataWriter;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerAccessor;
import mcp.mobius.waila.plugin.vanilla.config.Options;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.JukeboxPlayable;
import net.minecraft.world.item.JukeboxSong;
import net.minecraft.world.level.block.entity.JukeboxBlockEntity;

public enum JukeboxDataProvider implements IDataProvider<JukeboxBlockEntity>
{
    INSTANCE;


    @Override
    public void appendData(IDataWriter data, IServerAccessor<JukeboxBlockEntity> accessor, IPluginConfig config) {
        ItemStack stack;
        if (config.getBoolean(Options.JUKEBOX_RECORD) && !(stack = accessor.getTarget().getTheItem()).isEmpty()) {
            Optional song;
            JukeboxPlayable playable = (JukeboxPlayable)stack.get(DataComponents.JUKEBOX_PLAYABLE);
            Component text = null;
            if (playable != null && (song = playable.song().unwrap(accessor.getPlayer().registryAccess().lookupOrThrow(Registries.JUKEBOX_SONG))).isPresent()) {
                text = ((JukeboxSong)song.get()).description();
            }
            if (text == null) {
                text = stack.getDisplayName();
            }
            data.raw().putString("record", Component.Serializer.toJson((Component)text, (HolderLookup.Provider)accessor.getWorld().registryAccess()));
        }
    }
}

