/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.areas_common_neoforge.util;

import com.natamus.areas_common_neoforge.config.ConfigHandler;
import com.natamus.areas_common_neoforge.data.AreaVariables;
import com.natamus.areas_common_neoforge.data.ClientConstants;
import com.natamus.areas_common_neoforge.data.GUIVariables;
import com.natamus.areas_common_neoforge.functions.ZoneFunctions;
import com.natamus.areas_common_neoforge.objects.AreaObject;
import com.natamus.collective_common_neoforge.data.GlobalVariables;
import com.natamus.collective_common_neoforge.functions.HashMapFunctions;
import com.natamus.collective_common_neoforge.functions.MessageFunctions;
import com.natamus.collective_common_neoforge.functions.SignFunctions;
import com.natamus.collective_common_neoforge.functions.TileEntityFunctions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.HangingSignEditScreen;
import net.minecraft.client.gui.screens.inventory.SignEditScreen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.SignText;

public class Util {
    public static AreaObject getAreaSign(Level level, BlockPos signPos) {
        BlockEntity blockEntity = level.getBlockEntity(signPos);
        if (!(blockEntity instanceof SignBlockEntity)) {
            return null;
        }
        SignBlockEntity signBlockEntity = (SignBlockEntity)blockEntity;
        StringBuilder areaNameBuilder = new StringBuilder();
        String rgb = "";
        String zonePrefix = "Area";
        int radius = ConfigHandler.defaultAreaRadius;
        boolean customrgb = false;
        List signLines = SignFunctions.getSignText((BlockEntity)blockEntity);
        HashMap areaObjectHashMap = (HashMap)HashMapFunctions.computeIfAbsent(AreaVariables.areaObjects, (Object)level, k -> new HashMap());
        if (areaObjectHashMap != null && areaObjectHashMap.containsKey(signPos)) {
            AreaObject cachedAreaObject = (AreaObject)areaObjectHashMap.get(signPos);
            if (cachedAreaObject.signLines.equals(signLines)) {
                return cachedAreaObject;
            }
            AreaVariables.areaObjects.get(level).remove(signPos);
        }
        int i = -1;
        for (String line : signLines) {
            if (++i == 0 && !ZoneFunctions.hasZonePrefix(line)) {
                return null;
            }
            if (i > 3) break;
            if (line.length() < 1) continue;
            Integer possibleradius = ZoneFunctions.getRadius(line.toLowerCase());
            if (possibleradius >= 0) {
                radius = possibleradius;
                continue;
            }
            String possiblergb = ZoneFunctions.getZoneRGB(line.toLowerCase());
            if (!possiblergb.equals("")) {
                rgb = possiblergb;
                continue;
            }
            if (ZoneFunctions.hasZonePrefix(line)) continue;
            if (!areaNameBuilder.toString().equals("")) {
                areaNameBuilder.append(" ");
            }
            areaNameBuilder.append(line);
        }
        String areaName = areaNameBuilder.toString();
        return new AreaObject(level, signPos, areaName, radius, rgb, signLines);
    }

    /*
     * WARNING - void declaration
     */
    public static void updateAreaSign(Level level, BlockPos signPos, SignBlockEntity signBlockEntity, List<String> signLines, String areaName, String zonePrefix, String rgb, int radius, boolean customrgb) {
        int i;
        boolean setradius = false;
        int maxradius = ConfigHandler.radiusAroundPlayerToCheckForSigns;
        if (radius > maxradius) {
            radius = maxradius;
            setradius = true;
        }
        StringBuilder areaNameBuilder = new StringBuilder();
        boolean shouldUpdateSign = false;
        if (areaName.trim().equals("")) {
            void var15_16;
            ArrayList<Object> newSignContentList = new ArrayList<Object>();
            newSignContentList.add("[" + zonePrefix + "] " + radius);
            if (customrgb) {
                newSignContentList.add("[RGB] " + rgb);
            } else {
                newSignContentList.add("");
            }
            if (ConfigHandler.giveUnnamedAreasRandomName) {
                String string = Util.getRandomAreaName();
                for (String word : string.split(" ")) {
                    if (newSignContentList.size() != 8) {
                        newSignContentList.add(word);
                        continue;
                    }
                    break;
                }
            } else {
                newSignContentList.add("Unnamed area");
            }
            i = 0;
            SignText signText = signBlockEntity.getFrontText();
            for (String string : newSignContentList) {
                if (i > 3) break;
                SignText signText2 = var15_16.setMessage(i, (Component)Component.literal((String)string));
                ++i;
            }
            signBlockEntity.setText((SignText)var15_16, true);
            shouldUpdateSign = true;
        }
        if (!shouldUpdateSign && (radius == 0 || setradius)) {
            i = 0;
            for (String string : signLines) {
                void var15_21;
                if (i == 0) {
                    String string2 = "[" + zonePrefix + "] " + radius;
                } else if (i > 3) break;
                signBlockEntity.getFrontText().setMessage(i, (Component)Component.literal((String)var15_21));
                ++i;
            }
            shouldUpdateSign = true;
        }
        if (shouldUpdateSign) {
            TileEntityFunctions.updateTileEntity((Level)level, (BlockPos)signPos, (BlockEntity)signBlockEntity);
        }
    }

    public static void enterArea(AreaObject areaObject, Player player) {
        if (Util.playerIsEditingASign()) {
            return;
        }
        AreaObject currentAreaObject = Util.getAreaSign(areaObject.level, areaObject.location);
        if (currentAreaObject.signLines != areaObject.signLines) {
            AreaVariables.enteredAreas.remove(areaObject);
            AreaVariables.areaObjects.get(areaObject.level).put(areaObject.location, currentAreaObject);
            areaObject = currentAreaObject;
        }
        boolean shouldMessage = Util.shouldMessagePlayer(areaObject, true);
        if (!AreaVariables.enteredAreas.contains(areaObject)) {
            AreaVariables.enteredAreas.add(areaObject);
        }
        if (shouldMessage) {
            String message = ConfigHandler.enterPrefix + areaObject.areaName + ConfigHandler.enterSuffix;
            Util.areaChangeMessage(player, message, areaObject.customRGB);
        }
    }

    public static void exitArea(AreaObject areaObject, Player player) {
        AreaVariables.enteredAreas.remove(areaObject);
        boolean shouldMessage = Util.shouldMessagePlayer(areaObject, false);
        if (shouldMessage) {
            String message = ConfigHandler.leavePrefix + areaObject.areaName + ConfigHandler.leaveSuffix;
            Util.areaChangeMessage(player, message, areaObject.customRGB);
        }
    }

    public static void removedArea(AreaObject areaObject, Player player) {
        AreaVariables.areaObjects.get(areaObject.level).remove(areaObject.location);
        AreaVariables.enteredAreas.remove(areaObject);
        boolean shouldMessage = Util.shouldMessagePlayer(areaObject, false);
        if (shouldMessage) {
            String message = "The area " + areaObject.areaName + " no longer exists.";
            BlockPos pPos = player.blockPosition();
            Vec3i vec3i = new Vec3i(pPos.getX(), pPos.getY(), pPos.getZ());
            if (areaObject.location.distSqr(vec3i) > (double)(areaObject.radius * 2)) {
                message = ConfigHandler.leavePrefix + areaObject.areaName + ConfigHandler.leaveSuffix;
            }
            Util.areaChangeMessage(player, message, areaObject.customRGB);
        }
    }

    public static boolean playerIsEditingASign() {
        Screen screen = ClientConstants.mc.screen;
        return screen instanceof SignEditScreen || screen instanceof HangingSignEditScreen;
    }

    public static boolean shouldMessagePlayer(AreaObject areaObject, boolean isEntering) {
        if (areaObject.areaName.equals("")) {
            return false;
        }
        for (AreaObject enteredAreaObject : AreaVariables.enteredAreas) {
            if (enteredAreaObject.equals(areaObject) || !areaObject.signLines.equals(enteredAreaObject.signLines)) continue;
            return false;
        }
        if (isEntering) {
            return ConfigHandler.showEnterMessage;
        }
        return ConfigHandler.showLeaveMessage;
    }

    public static void areaChangeMessage(Player player, String message, String rgb) {
        if (ConfigHandler.sendChatMessages) {
            MessageFunctions.sendMessage((Player)player, (String)message, (ChatFormatting)ChatFormatting.DARK_GREEN);
        }
        if (ConfigHandler.showHUDMessages) {
            GUIVariables.ticksLeftBeforeFade = ConfigHandler.HUDMessageFadeDelayMs / 50;
            GUIVariables.hudMessage = message;
            GUIVariables.rgb = rgb;
            GUIVariables.guiOpacity = 255;
        }
    }

    public static Boolean isSignBlock(Block block) {
        return block instanceof SignBlock;
    }

    public static Boolean isSignItem(Item item) {
        return Util.isSignBlock(Block.byItem((Item)item));
    }

    private static String getRandomAreaName() {
        return (String)GlobalVariables.areaNames.get(GlobalVariables.random.nextInt(GlobalVariables.areaNames.size()));
    }
}

