/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.listeners.bossbar;

import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.resources.Identifier;
import net.minecraft.server.level.ServerBossEvent;
import org.popcraft.chunky.GenerationTask;
import org.popcraft.chunky.event.task.GenerationTaskFinishEvent;
import org.popcraft.chunky.platform.World;

public class BossBarTaskFinishListener
implements Consumer<GenerationTaskFinishEvent> {
    private final Map<Identifier, ServerBossEvent> bossBars;

    public BossBarTaskFinishListener(Map<Identifier, ServerBossEvent> bossBars) {
        this.bossBars = bossBars;
    }

    @Override
    public void accept(GenerationTaskFinishEvent event) {
        GenerationTask task = event.generationTask();
        World world = task.getSelection().world();
        Identifier worldIdentifier = Identifier.tryParse((String)world.getKey());
        if (worldIdentifier == null) {
            return;
        }
        ServerBossEvent bossBar = this.bossBars.get(worldIdentifier);
        if (bossBar != null) {
            bossBar.removeAllPlayers();
            this.bossBars.remove(worldIdentifier);
        }
    }
}

