/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.dataObjects;

import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.util.objects.DataCorruptedException;
import com.seibel.distanthorizons.core.wrapperInterfaces.IWrapperFactory;
import com.seibel.distanthorizons.core.wrapperInterfaces.block.IBlockStateWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IBiomeWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import java.util.concurrent.ConcurrentHashMap;

public class BlockBiomeWrapperPair {
    private static final IWrapperFactory WRAPPER_FACTORY = SingletonInjector.INSTANCE.get(IWrapperFactory.class);
    private static final ConcurrentHashMap<IBlockStateWrapper, ConcurrentHashMap<IBiomeWrapper, BlockBiomeWrapperPair>> CACHED_PAIR_BY_BIOME_BY_BLOCK = new ConcurrentHashMap();
    public final IBiomeWrapper biome;
    public final IBlockStateWrapper blockState;
    private int hashCode = 0;
    private boolean hashGenerated = false;
    private String serialString = null;

    public static BlockBiomeWrapperPair get(IBlockStateWrapper blockState, IBiomeWrapper biome) {
        BlockBiomeWrapperPair pair;
        ConcurrentHashMap<IBiomeWrapper, BlockBiomeWrapperPair> pairByBiomeWrapper = CACHED_PAIR_BY_BIOME_BY_BLOCK.get(blockState);
        if (pairByBiomeWrapper != null && (pair = pairByBiomeWrapper.get(biome)) != null) {
            return pair;
        }
        return CACHED_PAIR_BY_BIOME_BY_BLOCK.computeIfAbsent(blockState, newBlockState -> new ConcurrentHashMap()).computeIfAbsent(biome, newBiome -> new BlockBiomeWrapperPair(biome, blockState));
    }

    private BlockBiomeWrapperPair(IBiomeWrapper biome, IBlockStateWrapper blockState) {
        this.biome = biome;
        this.blockState = blockState;
    }

    public int hashCode() {
        if (!this.hashGenerated) {
            this.hashCode = BlockBiomeWrapperPair.generateHashCode(this);
            this.hashGenerated = true;
        }
        return this.hashCode;
    }

    private static int generateHashCode(BlockBiomeWrapperPair pair) {
        return BlockBiomeWrapperPair.generateHashCode(pair.biome, pair.blockState);
    }

    private static int generateHashCode(IBiomeWrapper biome, IBlockStateWrapper blockState) {
        int prime = 31;
        int result = 1;
        result = 31 * result + (biome == null ? 0 : biome.hashCode());
        result = 31 * result + (blockState == null ? 0 : blockState.hashCode());
        return result;
    }

    public boolean equals(Object otherObj) {
        if (otherObj == this) {
            return true;
        }
        if (!(otherObj instanceof BlockBiomeWrapperPair)) {
            return false;
        }
        BlockBiomeWrapperPair other = (BlockBiomeWrapperPair)otherObj;
        return other.biome.getSerialString().equals(this.biome.getSerialString()) && other.blockState.getSerialString().equals(this.blockState.getSerialString());
    }

    public String toString() {
        return this.serialize();
    }

    public String serialize() {
        if (this.serialString == null) {
            this.serialString = this.biome.getSerialString() + "_DH-BSW_" + this.blockState.getSerialString();
        }
        return this.serialString;
    }

    public static BlockBiomeWrapperPair deserialize(String str, ILevelWrapper levelWrapper) throws DataCorruptedException {
        int separatorIndex = str.indexOf("_DH-BSW_");
        if (separatorIndex == -1) {
            throw new DataCorruptedException("Failed to deserialize BiomeBlockStateEntry [" + str + "], unable to find separator.");
        }
        IBiomeWrapper biome = WRAPPER_FACTORY.deserializeBiomeWrapperOrGetDefault(str.substring(0, separatorIndex), levelWrapper);
        IBlockStateWrapper blockState = WRAPPER_FACTORY.deserializeBlockStateWrapperOrGetDefault(str.substring(separatorIndex + "_DH-BSW_".length()), levelWrapper);
        return BlockBiomeWrapperPair.get(blockState, biome);
    }
}

