/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.level;

import com.google.common.cache.CacheBuilder;
import com.seibel.distanthorizons.core.config.Config;
import com.seibel.distanthorizons.core.dataObjects.fullData.sources.FullDataSourceV2;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.file.fullDatafile.RemoteFullDataSourceProvider;
import com.seibel.distanthorizons.core.file.fullDatafile.V2.FullDataSourceProviderV2;
import com.seibel.distanthorizons.core.file.structure.ISaveStructure;
import com.seibel.distanthorizons.core.generation.RemoteWorldRetrievalQueue;
import com.seibel.distanthorizons.core.level.AbstractDhLevel;
import com.seibel.distanthorizons.core.level.ClientLevelModule;
import com.seibel.distanthorizons.core.level.IDhClientLevel;
import com.seibel.distanthorizons.core.level.LodRequestModule;
import com.seibel.distanthorizons.core.logging.DhLogger;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.multiplayer.client.ClientNetworkState;
import com.seibel.distanthorizons.core.multiplayer.client.SyncOnLoadRequestQueue;
import com.seibel.distanthorizons.core.network.event.ScopedNetworkEventSource;
import com.seibel.distanthorizons.core.network.messages.fullData.FullDataPartialUpdateMessage;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.pos.blockPos.DhBlockPos2D;
import com.seibel.distanthorizons.core.render.RenderBufferHandler;
import com.seibel.distanthorizons.core.render.renderer.generic.GenericObjectRenderer;
import com.seibel.distanthorizons.core.sql.dto.FullDataSourceV2DTO;
import com.seibel.distanthorizons.core.util.threading.PriorityTaskPicker;
import com.seibel.distanthorizons.core.util.threading.ThreadPoolUtil;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import javax.annotation.CheckForNull;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DhClientLevel
extends AbstractDhLevel
implements IDhClientLevel {
    private static final DhLogger LOGGER = new DhLoggerBuilder().build();
    private static final DhLogger NETWORK_LOGGER = new DhLoggerBuilder().fileLevelConfig(Config.Common.Logging.logNetworkEventToFile).build();
    private static final IMinecraftClientWrapper MC_CLIENT = SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class);
    public final ClientLevelModule clientside;
    public final IClientLevelWrapper levelWrapper;
    public final ISaveStructure saveStructure;
    public final RemoteFullDataSourceProvider remoteDataSourceProvider;
    @CheckForNull
    private final ClientNetworkState networkState;
    @Nullable
    private final ScopedNetworkEventSource networkEventSource;
    private final Set<DhChunkPos> loadedOnceChunks = Collections.newSetFromMap(CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build().asMap());
    public final LodRequestModule lodRequestModule;
    @Nullable
    private final SyncOnLoadRequestQueue syncOnLoadRequestQueue;

    public DhClientLevel(ISaveStructure saveStructure, IClientLevelWrapper clientLevelWrapper, @Nullable ClientNetworkState networkState) throws SQLException, IOException {
        this(saveStructure, clientLevelWrapper, null, networkState);
    }

    public DhClientLevel(ISaveStructure saveStructure, IClientLevelWrapper clientLevelWrapper, @Nullable File fullDataSaveDirOverride, @Nullable ClientNetworkState networkState) throws SQLException, IOException {
        File saveFolder = saveStructure.getSaveFolder(clientLevelWrapper);
        File pre23Folder = saveStructure.getPre23SaveFolder(clientLevelWrapper);
        if (pre23Folder.exists()) {
            if (!pre23Folder.renameTo(saveFolder)) {
                throw new RuntimeException("Could not move old save data folder: " + pre23Folder.getAbsolutePath() + " to " + saveFolder.getAbsolutePath());
            }
        } else if (saveStructure.getSaveFolder(clientLevelWrapper).mkdirs()) {
            LOGGER.warn("unable to create data folder.", new Object[0]);
        }
        this.levelWrapper = clientLevelWrapper;
        this.levelWrapper.setDhLevel(this);
        this.saveStructure = saveStructure;
        this.networkState = networkState;
        if (this.networkState != null) {
            this.networkEventSource = new ScopedNetworkEventSource(this.networkState.getSession());
            this.syncOnLoadRequestQueue = new SyncOnLoadRequestQueue(this, this.networkState);
            this.registerNetworkHandlers();
        } else {
            this.networkEventSource = null;
            this.syncOnLoadRequestQueue = null;
        }
        this.remoteDataSourceProvider = new RemoteFullDataSourceProvider(this, saveStructure, fullDataSaveDirOverride, this.syncOnLoadRequestQueue);
        this.lodRequestModule = new LodRequestModule(this, this, this.remoteDataSourceProvider, () -> new LodRequestState(this, networkState));
        this.clientside = new ClientLevelModule(this);
        this.createAndSetSupportingRepos(this.remoteDataSourceProvider.repo.databaseFile);
        this.runRepoReliantSetup();
        this.clientside.startRenderer();
        LOGGER.info("Started DHLevel for " + this.levelWrapper + " with saves at " + this.saveStructure, new Object[0]);
    }

    private void registerNetworkHandlers() {
        assert (this.networkEventSource != null);
        assert (this.networkState != null);
        this.networkEventSource.registerHandler(FullDataPartialUpdateMessage.class, message -> {
            if (MC_CLIENT.connectedToReplay()) {
                return;
            }
            try (FullDataSourceV2DTO dataSourceDto = this.networkState.fullDataPayloadReceiver.decodeDataSource(message.payload);){
                boolean isSameLevel = message.isSameLevelAs(this.levelWrapper);
                NETWORK_LOGGER.debug("Buffer [" + message.payload.dtoBufferId + "] isSameLevel: [" + isSameLevel + "]", new Object[0]);
                if (!isSameLevel) {
                    return;
                }
                PriorityTaskPicker.Executor executor = ThreadPoolUtil.getFileHandlerExecutor();
                if (executor != null) {
                    executor.execute(() -> {
                        try {
                            this.updateBeaconBeamsForSectionPos(dataSourceDto.pos, message.payload.beaconBeams);
                        }
                        catch (Exception e) {
                            LOGGER.error("Unexpected erorr while updating full data source, error: [" + e.getMessage() + "].", e);
                        }
                    });
                }
                FullDataSourceV2 fullDataSource = dataSourceDto.createDataSource(this.levelWrapper, null);
                this.updateDataSourcesAsync(fullDataSource).whenComplete((result, e) -> fullDataSource.close());
            }
            catch (Exception e2) {
                LOGGER.error("Error while updating full data source", e2);
            }
        });
    }

    @Override
    public void clientTick() {
        try {
            this.clientside.clientTick();
            if (this.syncOnLoadRequestQueue != null) {
                this.syncOnLoadRequestQueue.tick(new DhBlockPos2D(MC_CLIENT.getPlayerBlockPos()));
            }
        }
        catch (Exception e) {
            LOGGER.error("Unexpected clientTick Exception: " + e.getMessage(), e);
        }
    }

    @Override
    public boolean shouldDoWorldGen() {
        ClientNetworkState networkState = this.networkState;
        boolean isClientUsable = false;
        boolean isAllowedDimension = false;
        if (networkState != null) {
            isClientUsable = networkState.isReady();
            isAllowedDimension = MC_CLIENT.getWrappedClientLevel() == this.levelWrapper;
        }
        return isClientUsable && networkState.sessionConfig.isDistantGenerationEnabled() && isAllowedDimension && this.clientside.isRendering();
    }

    @Override
    public DhBlockPos2D getTargetPosForGeneration() {
        return new DhBlockPos2D(MC_CLIENT.getPlayerBlockPos());
    }

    @Override
    public void onWorldGenTaskComplete(long pos) {
        this.clientside.reloadPos(pos);
    }

    @Override
    public IClientLevelWrapper getClientLevelWrapper() {
        return this.levelWrapper;
    }

    @Override
    public void clearRenderCache() {
        this.clientside.clearRenderCache();
    }

    @Override
    @NotNull
    public ILevelWrapper getLevelWrapper() {
        return this.levelWrapper;
    }

    @Override
    public CompletableFuture<Void> updateDataSourcesAsync(FullDataSourceV2 data) {
        return this.clientside.updateDataSourcesAsync(data);
    }

    @Override
    public FullDataSourceProviderV2 getFullDataProvider() {
        return this.remoteDataSourceProvider;
    }

    @Override
    public ISaveStructure getSaveStructure() {
        return this.saveStructure;
    }

    @Override
    public GenericObjectRenderer getGenericRenderer() {
        return this.clientside.genericRenderer;
    }

    @Override
    public RenderBufferHandler getRenderBufferHandler() {
        ClientLevelModule.ClientRenderState renderState = this.clientside.ClientRenderStateRef.get();
        return renderState != null ? renderState.renderBufferHandler : null;
    }

    public boolean shouldProcessChunkUpdate(DhChunkPos chunkPos) {
        if (this.networkState == null || !this.networkState.isReady()) {
            return true;
        }
        return !this.networkState.sessionConfig.isRealTimeUpdatesEnabled() || this.loadedOnceChunks.add(chunkPos);
    }

    @Override
    public void addDebugMenuStringsToList(List<String> messageList) {
        String dimName = this.levelWrapper.getDhIdentifier();
        boolean rendering = this.clientside.isRendering();
        messageList.add("[" + dimName + "] rendering: " + (rendering ? "yes" : "no"));
        this.remoteDataSourceProvider.addDebugMenuStringsToList(messageList);
        this.lodRequestModule.addDebugMenuStringsToList(messageList);
        if (this.syncOnLoadRequestQueue != null) {
            assert (this.networkState != null);
            if (this.networkState.sessionConfig.getSynchronizeOnLoad()) {
                this.syncOnLoadRequestQueue.addDebugMenuStringsToList(messageList);
            }
        }
    }

    public String toString() {
        return "DhClientLevel{" + this.getClientLevelWrapper().getDhIdentifier() + "}";
    }

    @Override
    public void close() {
        if (this.lodRequestModule != null) {
            this.lodRequestModule.close();
        }
        if (this.networkEventSource != null) {
            this.networkEventSource.close();
        }
        this.levelWrapper.setDhLevel(null);
        this.clientside.close();
        super.close();
        this.remoteDataSourceProvider.close();
        LOGGER.info("Closed [" + DhClientLevel.class.getSimpleName() + "] for [" + this.levelWrapper + "]", new Object[0]);
    }

    private static class LodRequestState
    extends LodRequestModule.AbstractLodRequestState {
        LodRequestState(DhClientLevel clientLevel, ClientNetworkState networkState) {
            this.retrievalQueue = new RemoteWorldRetrievalQueue(networkState, clientLevel);
        }
    }
}

