/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.network.messages.base;

import com.google.common.base.MoreObjects;
import com.seibel.distanthorizons.core.network.messages.AbstractNetworkMessage;
import io.netty.buffer.ByteBuf;

public class LevelInitMessage
extends AbstractNetworkMessage {
    public static final int MAX_LENGTH = 150;
    public static final String ALLOWED_CHARS_REGEX = "a-zA-Z0-9-_";
    public static final String SERVER_KEY_REGEX = String.format("^(?=.{1,%s}$)[%s]+$", 150, "a-zA-Z0-9-_");
    public static final String LEVEL_KEY_REGEX = String.format("^(?=.{1,%s}$)([%s]+@)?[%s]+(:[%s]+)?$", 150, "a-zA-Z0-9-_", "a-zA-Z0-9-_", "a-zA-Z0-9-_");
    public String serverKey;
    public String levelKey;
    public long serverTime;

    public LevelInitMessage() {
    }

    public LevelInitMessage(String serverKey, String levelKey) {
        this.serverKey = serverKey;
        this.levelKey = levelKey;
        this.serverTime = System.currentTimeMillis();
    }

    @Override
    public void encode(ByteBuf out) {
        this.writeString(this.serverKey, out);
        this.writeString(this.levelKey, out);
        out.writeLong(this.serverTime);
    }

    @Override
    public void decode(ByteBuf in) {
        this.serverKey = this.readString(in);
        this.levelKey = this.readString(in);
        this.serverTime = in.readLong();
    }

    @Override
    public MoreObjects.ToStringHelper toStringHelper() {
        return super.toStringHelper().add("serverKey", (Object)this.serverKey).add("levelKey", (Object)this.levelKey).add("serverTime", this.serverTime);
    }
}

