/*
 * Decompiled with CFR 0.152.
 */
package org.tukaani.xz.lz;

import org.tukaani.xz.ArrayCache;
import org.tukaani.xz.lz.Hash234;
import org.tukaani.xz.lz.LZEncoder;
import org.tukaani.xz.lz.Matches;

final class BT4
extends LZEncoder {
    private final Hash234 hash;
    private final int[] tree;
    private final Matches matches;
    private final int depthLimit;
    private final int cyclicSize;
    private int cyclicPos = -1;
    private int lzPos;

    static int getMemoryUsage(int i) {
        return Hash234.getMemoryUsage(i) + i / 128 + 10;
    }

    BT4(int i, int j, int k, int l, int m, int n, ArrayCache arrayCache) {
        super(i, j, k, l, m, arrayCache);
        this.lzPos = this.cyclicSize = i + 1;
        this.hash = new Hash234(i, arrayCache);
        this.tree = arrayCache.getIntArray(this.cyclicSize * 2, false);
        this.matches = new Matches(l - 1);
        this.depthLimit = n > 0 ? n : 16 + l / 2;
    }

    @Override
    public void putArraysToCache(ArrayCache arrayCache) {
        arrayCache.putArray(this.tree);
        this.hash.putArraysToCache(arrayCache);
        super.putArraysToCache(arrayCache);
    }

    private int movePos() {
        int n = this.movePos(this.niceLen, 4);
        if (n != 0) {
            if (++this.lzPos == Integer.MAX_VALUE) {
                int n2 = Integer.MAX_VALUE - this.cyclicSize;
                this.hash.normalize(n2);
                BT4.normalize(this.tree, this.cyclicSize * 2, n2);
                this.lzPos -= n2;
            }
            if (++this.cyclicPos == this.cyclicSize) {
                this.cyclicPos = 0;
            }
        }
        return n;
    }

    @Override
    public Matches getMatches() {
        this.matches.count = 0;
        int n = this.matchLenMax;
        int n2 = this.niceLen;
        int n3 = this.movePos();
        if (n3 < n) {
            if (n3 == 0) {
                return this.matches;
            }
            n = n3;
            if (n2 > n3) {
                n2 = n3;
            }
        }
        this.hash.calcHashes(this.buf, this.readPos);
        int n4 = this.lzPos - this.hash.getHash2Pos();
        int n5 = this.lzPos - this.hash.getHash3Pos();
        int n6 = this.hash.getHash4Pos();
        this.hash.updateTables(this.lzPos);
        int n7 = 0;
        if (n4 < this.cyclicSize && this.buf[this.readPos - n4] == this.buf[this.readPos]) {
            n7 = 2;
            this.matches.len[0] = 2;
            this.matches.dist[0] = n4 - 1;
            this.matches.count = 1;
        }
        if (n4 != n5 && n5 < this.cyclicSize && this.buf[this.readPos - n5] == this.buf[this.readPos]) {
            n7 = 3;
            this.matches.dist[this.matches.count++] = n5 - 1;
            n4 = n5;
        }
        if (this.matches.count > 0) {
            while (n7 < n && this.buf[this.readPos + n7 - n4] == this.buf[this.readPos + n7]) {
                ++n7;
            }
            this.matches.len[this.matches.count - 1] = n7;
            if (n7 >= n2) {
                this.skip(n2, n6);
                return this.matches;
            }
        }
        if (n7 < 3) {
            n7 = 3;
        }
        int n8 = this.depthLimit;
        int n9 = (this.cyclicPos << 1) + 1;
        int n10 = this.cyclicPos << 1;
        int n11 = 0;
        int n12 = 0;
        while (true) {
            int n13 = this.lzPos - n6;
            if (n8-- == 0 || n13 >= this.cyclicSize) {
                this.tree[n9] = 0;
                this.tree[n10] = 0;
                return this.matches;
            }
            int n14 = this.cyclicPos - n13 + (n13 > this.cyclicPos ? this.cyclicSize : 0) << 1;
            int n15 = Math.min(n11, n12);
            if (this.buf[this.readPos + n15 - n13] == this.buf[this.readPos + n15]) {
                while (++n15 < n && this.buf[this.readPos + n15 - n13] == this.buf[this.readPos + n15]) {
                }
                if (n15 > n7) {
                    n7 = n15;
                    this.matches.len[this.matches.count] = n15;
                    this.matches.dist[this.matches.count] = n13 - 1;
                    ++this.matches.count;
                    if (n15 >= n2) {
                        this.tree[n10] = this.tree[n14];
                        this.tree[n9] = this.tree[n14 + 1];
                        return this.matches;
                    }
                }
            }
            if ((this.buf[this.readPos + n15 - n13] & 0xFF) < (this.buf[this.readPos + n15] & 0xFF)) {
                this.tree[n10] = n6;
                n10 = n14 + 1;
                n6 = this.tree[n10];
                n12 = n15;
                continue;
            }
            this.tree[n9] = n6;
            n9 = n14;
            n6 = this.tree[n9];
            n11 = n15;
        }
    }

    private void skip(int i, int j) {
        int n = this.depthLimit;
        int n2 = (this.cyclicPos << 1) + 1;
        int n3 = this.cyclicPos << 1;
        int n4 = 0;
        int n5 = 0;
        while (true) {
            int n6 = this.lzPos - j;
            if (n-- == 0 || n6 >= this.cyclicSize) {
                this.tree[n2] = 0;
                this.tree[n3] = 0;
                return;
            }
            int n7 = this.cyclicPos - n6 + (n6 > this.cyclicPos ? this.cyclicSize : 0) << 1;
            int n8 = Math.min(n4, n5);
            if (this.buf[this.readPos + n8 - n6] == this.buf[this.readPos + n8]) {
                do {
                    if (++n8 != i) continue;
                    this.tree[n3] = this.tree[n7];
                    this.tree[n2] = this.tree[n7 + 1];
                    return;
                } while (this.buf[this.readPos + n8 - n6] == this.buf[this.readPos + n8]);
            }
            if ((this.buf[this.readPos + n8 - n6] & 0xFF) < (this.buf[this.readPos + n8] & 0xFF)) {
                this.tree[n3] = j;
                n3 = n7 + 1;
                j = this.tree[n3];
                n5 = n8;
                continue;
            }
            this.tree[n2] = j;
            n2 = n7;
            j = this.tree[n2];
            n4 = n8;
        }
    }

    @Override
    public void skip(int i) {
        while (i-- > 0) {
            int n = this.niceLen;
            int n2 = this.movePos();
            if (n2 < n) {
                if (n2 == 0) continue;
                n = n2;
            }
            this.hash.calcHashes(this.buf, this.readPos);
            int n3 = this.hash.getHash4Pos();
            this.hash.updateTables(this.lzPos);
            this.skip(n, n3);
        }
    }
}

