/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone.blocks;

import de.maxhenkel.gravestone.ClientUtils;
import de.maxhenkel.gravestone.GraveUtils;
import de.maxhenkel.gravestone.GravestoneMod;
import de.maxhenkel.gravestone.corelib.block.DirectionalVoxelShape;
import de.maxhenkel.gravestone.corelib.death.Death;
import de.maxhenkel.gravestone.entity.GhostPlayerEntity;
import de.maxhenkel.gravestone.items.ObituaryItem;
import de.maxhenkel.gravestone.tileentity.GraveStoneTileEntity;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.InsideBlockEffectApplier;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ScheduledTickAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class GraveStoneBlock
extends Block
implements EntityBlock,
SimpleWaterloggedBlock {
    public static final EnumProperty<Direction> FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape BASE1 = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    private static final VoxelShape BASE2 = Block.box((double)1.0, (double)1.0, (double)1.0, (double)15.0, (double)2.0, (double)15.0);
    private static final DirectionalVoxelShape SHAPE = new DirectionalVoxelShape.Builder().direction(Direction.NORTH, BASE1, BASE2, Block.box((double)1.0, (double)2.0, (double)1.0, (double)15.0, (double)12.0, (double)2.0), Block.box((double)2.0, (double)12.0, (double)1.0, (double)14.0, (double)14.0, (double)2.0), Block.box((double)3.0, (double)14.0, (double)1.0, (double)13.0, (double)15.0, (double)2.0)).direction(Direction.SOUTH, BASE1, BASE2, Block.box((double)1.0, (double)2.0, (double)14.0, (double)15.0, (double)12.0, (double)15.0), Block.box((double)2.0, (double)12.0, (double)14.0, (double)14.0, (double)14.0, (double)15.0), Block.box((double)3.0, (double)14.0, (double)14.0, (double)13.0, (double)15.0, (double)15.0)).direction(Direction.EAST, BASE1, BASE2, Block.box((double)14.0, (double)2.0, (double)1.0, (double)15.0, (double)12.0, (double)15.0), Block.box((double)14.0, (double)12.0, (double)2.0, (double)15.0, (double)14.0, (double)14.0), Block.box((double)14.0, (double)14.0, (double)3.0, (double)15.0, (double)15.0, (double)13.0)).direction(Direction.WEST, BASE1, BASE2, Block.box((double)1.0, (double)2.0, (double)1.0, (double)2.0, (double)12.0, (double)15.0), Block.box((double)1.0, (double)12.0, (double)2.0, (double)2.0, (double)14.0, (double)14.0), Block.box((double)1.0, (double)14.0, (double)3.0, (double)2.0, (double)15.0, (double)13.0)).build();

    public GraveStoneBlock(BlockBehaviour.Properties properties) {
        super(properties.mapColor(MapColor.DIRT).strength(0.3f, Float.MAX_VALUE));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue(FACING, (Comparable)Direction.NORTH)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
        builder.add(new Property[]{WATERLOGGED});
    }

    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    protected BlockState updateShape(BlockState state, LevelReader level, ScheduledTickAccess tickAccess, BlockPos pos, Direction direction, BlockPos facingPos, BlockState facingState, RandomSource randomSource) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            tickAccess.scheduleTick(pos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay(level));
        }
        return super.updateShape(state, level, tickAccess, pos, direction, facingPos, facingState, randomSource);
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        BlockEntity tileentity;
        if (stack.has(DataComponents.CUSTOM_NAME) && (tileentity = world.getBlockEntity(pos)) instanceof GraveStoneTileEntity) {
            GraveStoneTileEntity grave = (GraveStoneTileEntity)tileentity;
            grave.setCustomName(stack.getHoverName());
        }
        super.setPlacedBy(world, pos, state, placer, stack);
    }

    public void wasExploded(ServerLevel level, BlockPos pos, Explosion explosion) {
    }

    public void onBlockExploded(BlockState state, ServerLevel level, BlockPos pos, Explosion explosion) {
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.defaultBlockState().setValue(FACING, (Comparable)context.getHorizontalDirection())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.getLevel().getFluidState(context.getClickedPos()).getType() == Fluids.WATER));
    }

    public boolean canEntityDestroy(BlockState state, BlockGetter world, BlockPos pos, Entity entity) {
        return false;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult result) {
        BlockEntity tileentity = level.getBlockEntity(pos);
        if (!(tileentity instanceof GraveStoneTileEntity)) {
            return InteractionResult.FAIL;
        }
        GraveStoneTileEntity grave = (GraveStoneTileEntity)tileentity;
        Component name = grave.getGraveName();
        if (name == null) {
            return InteractionResult.FAIL;
        }
        if (level.isClientSide()) {
            MutableComponent time = GraveUtils.getDate(grave.getDeath().getTimestamp());
            if (time == null) {
                ClientUtils.sendMessage(name);
            } else {
                ClientUtils.sendMessage((Component)Component.translatable((String)"message.gravestone.died", (Object[])new Object[]{name, time}));
            }
        }
        return InteractionResult.SUCCESS;
    }

    protected void affectNeighborsAfterRemoval(BlockState state, ServerLevel level, BlockPos pos, boolean moving) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof GraveStoneTileEntity) {
            GraveStoneTileEntity grave = (GraveStoneTileEntity)blockEntity;
            this.dropItems((Level)level, pos, grave.getDeath().getAllItems());
        }
        super.affectNeighborsAfterRemoval(state, level, pos, moving);
    }

    public void dropItems(Level world, BlockPos pos, NonNullList<ItemStack> items) {
        for (ItemStack item : items) {
            Containers.dropItemStack((Level)world, (double)((double)pos.getX() + 0.5), (double)((double)pos.getY() + 0.5), (double)((double)pos.getZ() + 0.5), (ItemStack)item);
        }
    }

    public boolean onDestroyedByPlayer(BlockState state, Level world, BlockPos pos, Player player, ItemStack toolStack, boolean willHarvest, FluidState fluid) {
        if (!GraveUtils.canBreakGrave(world, player, pos)) {
            return false;
        }
        BlockEntity te = world.getBlockEntity(pos);
        if (!world.isClientSide() && te instanceof GraveStoneTileEntity) {
            GraveStoneTileEntity grave = (GraveStoneTileEntity)te;
            this.removeObituary(player, grave);
            this.spawnGhost(world, pos, grave);
            if (!grave.getDeath().getId().equals(GraveUtils.EMPTY_UUID) && ((Boolean)GravestoneMod.SERVER_CONFIG.breakPickup.get()).booleanValue()) {
                this.sortItems(world, pos, player, grave);
            }
        }
        return super.onDestroyedByPlayer(state, world, pos, player, toolStack, willHarvest, fluid);
    }

    protected void spawnGhost(Level world, BlockPos pos, GraveStoneTileEntity grave) {
        if (!((Boolean)GravestoneMod.SERVER_CONFIG.spawnGhost.get()).booleanValue()) {
            return;
        }
        if (!world.isEmptyBlock(pos.above())) {
            return;
        }
        UUID uuid = grave.getDeath().getPlayerUUID();
        if (uuid.equals(GraveUtils.EMPTY_UUID)) {
            return;
        }
        GhostPlayerEntity ghost = new GhostPlayerEntity(world, uuid, (Component)Component.literal((String)grave.getDeath().getPlayerName()), grave.getDeath().getEquipment(), grave.getDeath().getModel());
        ghost.setPos((double)pos.getX() + 0.5, (double)pos.getY() + 0.1, (double)pos.getZ() + 0.5);
        world.addFreshEntity((Entity)ghost);
    }

    protected void removeObituary(Player p, GraveStoneTileEntity grave) {
        if (!((Boolean)GravestoneMod.SERVER_CONFIG.removeObituary.get()).booleanValue()) {
            return;
        }
        if (!(p instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer player = (ServerPlayer)p;
        Inventory inv = player.getInventory();
        for (int i = 0; i < player.getInventory().getContainerSize(); ++i) {
            Death death;
            ItemStack stack = player.getInventory().getItem(i);
            if (!stack.getItem().equals(GravestoneMod.OBITUARY.get()) || (death = ((ObituaryItem)((Object)GravestoneMod.OBITUARY.get())).fromStack(player, stack)) == null || grave.getDeath().getId().equals(GraveUtils.EMPTY_UUID) || !grave.getDeath().getId().equals(death.getId())) continue;
            inv.removeItem(stack);
        }
    }

    protected void entityInside(BlockState state, Level level, BlockPos pos, Entity entity, InsideBlockEffectApplier effectApplier, boolean b) {
        super.entityInside(state, level, pos, entity, effectApplier, b);
        if (!(entity instanceof ServerPlayer && entity.isAlive() && ((Boolean)GravestoneMod.SERVER_CONFIG.sneakPickup.get()).booleanValue())) {
            return;
        }
        ServerPlayer player = (ServerPlayer)entity;
        if (!player.isShiftKeyDown() || player.getAbilities().instabuild || !GraveUtils.canBreakGrave(level, (Player)player, pos)) {
            return;
        }
        BlockEntity te = level.getBlockEntity(pos);
        if (!(te instanceof GraveStoneTileEntity)) {
            return;
        }
        GraveStoneTileEntity grave = (GraveStoneTileEntity)te;
        if (grave.getDeath().getId().equals(GraveUtils.EMPTY_UUID)) {
            return;
        }
        this.removeObituary((Player)player, grave);
        this.spawnGhost(level, pos, grave);
        this.sortItems(level, pos, (Player)player, grave);
        level.destroyBlock(pos, true);
    }

    protected void sortItems(Level world, BlockPos pos, Player player, GraveStoneTileEntity grave) {
        Death death = grave.getDeath();
        this.dropItems(world, pos, this.fillPlayerInventory(player, death));
        world.playSound(null, pos, SoundEvents.ITEM_FRAME_REMOVE_ITEM, SoundSource.BLOCKS, 1.0f, 1.0f);
        grave.setChanged();
    }

    public NonNullList<ItemStack> fillPlayerInventory(Player player, Death death) {
        NonNullList additionalItems = NonNullList.create();
        this.fillInventory((List<ItemStack>)additionalItems, death.getMainInventory(), (NonNullList<ItemStack>)player.getInventory().getNonEquipmentItems());
        this.fillInventoryEquipment(player, (List<ItemStack>)additionalItems, (ItemStack)death.getArmorInventory().get(EquipmentSlot.FEET.getIndex()), EquipmentSlot.FEET);
        this.fillInventoryEquipment(player, (List<ItemStack>)additionalItems, (ItemStack)death.getArmorInventory().get(EquipmentSlot.LEGS.getIndex()), EquipmentSlot.LEGS);
        this.fillInventoryEquipment(player, (List<ItemStack>)additionalItems, (ItemStack)death.getArmorInventory().get(EquipmentSlot.CHEST.getIndex()), EquipmentSlot.CHEST);
        this.fillInventoryEquipment(player, (List<ItemStack>)additionalItems, (ItemStack)death.getArmorInventory().get(EquipmentSlot.HEAD.getIndex()), EquipmentSlot.HEAD);
        this.fillInventoryEquipment(player, (List<ItemStack>)additionalItems, (ItemStack)death.getOffHandInventory().getFirst(), EquipmentSlot.OFFHAND);
        additionalItems.addAll(death.getAdditionalItems());
        NonNullList restItems = NonNullList.create();
        for (ItemStack stack : additionalItems) {
            if (player.getInventory().add(stack)) continue;
            restItems.add((Object)stack);
        }
        death.getAdditionalItems().clear();
        return restItems;
    }

    public void fillInventoryEquipment(Player player, List<ItemStack> additionalItems, ItemStack item, EquipmentSlot slot) {
        if (item.isEmpty()) {
            return;
        }
        ItemStack oldPlayerItem = player.getItemBySlot(slot);
        if (!oldPlayerItem.isEmpty()) {
            additionalItems.add(oldPlayerItem);
        }
        player.setItemSlot(slot, item);
    }

    public void fillInventory(List<ItemStack> additionalItems, NonNullList<ItemStack> inventory, NonNullList<ItemStack> playerInv) {
        for (int i = 0; i < inventory.size(); ++i) {
            ItemStack stack = (ItemStack)inventory.get(i);
            if (stack.isEmpty()) continue;
            ItemStack playerStack = (ItemStack)playerInv.get(i);
            if (!playerStack.isEmpty()) {
                additionalItems.add(playerStack);
            }
            inventory.set(i, (Object)ItemStack.EMPTY);
            playerInv.set(i, (Object)stack);
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter reader, BlockPos pos, CollisionContext context) {
        return SHAPE.get((Direction)state.getValue(FACING));
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new GraveStoneTileEntity(pos, state);
    }
}

