/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.gravestone.events;

import de.maxhenkel.gravestone.GraveUtils;
import de.maxhenkel.gravestone.GravestoneMod;
import de.maxhenkel.gravestone.blocks.GraveStoneBlock;
import de.maxhenkel.gravestone.corelib.death.Death;
import de.maxhenkel.gravestone.corelib.death.PlayerDeathEvent;
import de.maxhenkel.gravestone.items.ObituaryItem;
import de.maxhenkel.gravestone.tileentity.GraveStoneTileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gamerules.GameRules;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;

public class DeathEvents {
    public DeathEvents() {
        de.maxhenkel.gravestone.corelib.death.DeathEvents.register();
    }

    @SubscribeEvent
    public void playerDeath(PlayerDeathEvent event) {
        BlockEntity tileentity;
        event.storeDeath();
        Death death = event.getDeath();
        ServerPlayer player = event.getPlayer();
        Level world = player.level();
        if (DeathEvents.keepInventory((Player)player)) {
            return;
        }
        GravestoneMod.LOGGER.info("The death ID of player {} is {}", (Object)death.getPlayerName(), (Object)death.getId());
        BlockPos graveStoneLocation = GraveUtils.getGraveStoneLocation(world, death.getBlockPos());
        if (((Boolean)GravestoneMod.SERVER_CONFIG.giveObituaries.get()).booleanValue()) {
            player.getInventory().add(((ObituaryItem)((Object)GravestoneMod.OBITUARY.get())).toStack(death));
        }
        if (graveStoneLocation == null) {
            GravestoneMod.LOGGER.info("Grave of '{}' can't be placed (No space)", (Object)death.getPlayerName());
            GravestoneMod.LOGGER.info("The death ID of '{}' is {}", (Object)death.getPlayerName(), (Object)death.getId().toString());
            return;
        }
        world.setBlockAndUpdate(graveStoneLocation, (BlockState)((GraveStoneBlock)((Object)GravestoneMod.GRAVESTONE.get())).defaultBlockState().setValue(GraveStoneBlock.FACING, (Comparable)player.getDirection().getOpposite()));
        if (GraveUtils.isReplaceable(world, graveStoneLocation.below())) {
            world.setBlockAndUpdate(graveStoneLocation.below(), Blocks.DIRT.defaultBlockState());
        }
        if (!((tileentity = world.getBlockEntity(graveStoneLocation)) instanceof GraveStoneTileEntity)) {
            GravestoneMod.LOGGER.info("Grave of '{}' can't be filled with loot (No tileentity found)", (Object)death.getPlayerName());
            GravestoneMod.LOGGER.info("The death ID of '{}' is {}", (Object)death.getPlayerName(), (Object)death.getId().toString());
            return;
        }
        GraveStoneTileEntity gravestone = (GraveStoneTileEntity)tileentity;
        gravestone.setDeath(death);
        event.removeDrops();
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerCloneLast(PlayerEvent.Clone event) {
        if (!((Boolean)GravestoneMod.SERVER_CONFIG.giveObituaries.get()).booleanValue()) {
            return;
        }
        if (!event.isWasDeath()) {
            return;
        }
        if (DeathEvents.keepInventory(event.getEntity())) {
            return;
        }
        for (int i = 0; i < event.getOriginal().getInventory().getContainerSize(); ++i) {
            ItemStack stack = event.getOriginal().getInventory().getItem(i);
            if (!(stack.getItem() instanceof ObituaryItem)) continue;
            event.getEntity().getInventory().add(stack);
        }
    }

    public static boolean keepInventory(Player player) {
        try {
            Level level = player.level();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                return (Boolean)serverLevel.getGameRules().get(GameRules.KEEP_INVENTORY);
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }
}

