/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.healingcampfire_common_forge.events;

import com.natamus.collective_common_forge.data.BlockEntityData;
import com.natamus.healingcampfire_common_forge.config.ConfigHandler;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class CampfireEvent {
    public static void playerTickEvent(ServerLevel level, ServerPlayer player) {
        double r;
        if (player.tickCount % ConfigHandler.checkForCampfireDelayInTicks != 0) {
            return;
        }
        if (!((WeakHashMap)BlockEntityData.cachedBlockEntities.get(BlockEntityType.CAMPFIRE)).containsKey(level)) {
            return;
        }
        BlockPos entityPos = player.blockPosition();
        Vec3i entityVec3i = new Vec3i(entityPos.getX(), entityPos.getY(), entityPos.getZ());
        BlockPos campfirePos = null;
        for (BlockEntity campfireBlockEntity : (CopyOnWriteArrayList)((WeakHashMap)BlockEntityData.cachedBlockEntities.get(BlockEntityType.CAMPFIRE)).get(level)) {
            Boolean issignalling;
            Boolean islit;
            BlockPos nearbyCampfirePos = campfireBlockEntity.getBlockPos();
            if (!nearbyCampfirePos.closerThan(entityVec3i, (double)ConfigHandler.healingRadius)) continue;
            BlockState campfireState = campfireBlockEntity.getBlockState();
            Block block = campfireState.getBlock();
            if (!ConfigHandler.enableEffectForNormalCampfires && block.equals(Blocks.CAMPFIRE) || !ConfigHandler.enableEffectForSoulCampfires && block.equals(Blocks.SOUL_CAMPFIRE) || ConfigHandler.campfireMustBeLit && !(islit = (Boolean)campfireState.getValue((Property)CampfireBlock.LIT)).booleanValue() || ConfigHandler.campfireMustBeSignalling && !(issignalling = (Boolean)campfireState.getValue((Property)CampfireBlock.SIGNAL_FIRE)).booleanValue()) continue;
            campfirePos = nearbyCampfirePos.immutable();
            break;
        }
        if (campfirePos == null) {
            return;
        }
        MobEffectInstance effectinstance = ConfigHandler.hideEffectParticles ? new MobEffectInstance(MobEffects.REGENERATION, ConfigHandler.effectDurationSeconds * 20, ConfigHandler.regenerationLevel - 1, true, false) : new MobEffectInstance(MobEffects.REGENERATION, ConfigHandler.effectDurationSeconds * 20, ConfigHandler.regenerationLevel - 1);
        BlockPos ppos = player.blockPosition();
        if (ppos.closerThan(campfirePos, r = (double)ConfigHandler.healingRadius)) {
            int currentduration;
            boolean addeffect = true;
            MobEffectInstance currentregen = player.getEffect(effectinstance.getEffect());
            if (currentregen != null && (currentduration = currentregen.getDuration()) > ConfigHandler.effectDurationSeconds * 10) {
                addeffect = false;
            }
            if (addeffect) {
                player.addEffect(effectinstance);
            }
        }
        if (ConfigHandler.healPassiveMobs) {
            for (Entity entity : level.getEntities((Entity)player, new AABB((double)campfirePos.getX() - r, (double)campfirePos.getY() - r, (double)campfirePos.getZ() - r, (double)campfirePos.getX() + r, (double)campfirePos.getY() + r, (double)campfirePos.getZ() + r))) {
                int currentduration;
                if (!(entity instanceof LivingEntity) || entity instanceof Player || entity.getType().getCategory().equals((Object)MobCategory.MONSTER)) continue;
                LivingEntity le = (LivingEntity)entity;
                boolean addeffect = true;
                MobEffectInstance currentregen = le.getEffect(effectinstance.getEffect());
                if (currentregen != null && (currentduration = currentregen.getDuration()) > ConfigHandler.effectDurationSeconds * 10) {
                    addeffect = false;
                }
                if (!addeffect) continue;
                le.addEffect(effectinstance);
            }
        }
    }
}

