/*
 * Decompiled with CFR 0.152.
 */
package io.github.sycamore0.myluckyblock.utils;

import com.google.gson.annotations.SerializedName;
import io.github.sycamore0.myluckyblock.utils.PosSrc;
import java.util.List;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class RandomEventReader {
    @SerializedName(value="id")
    protected int id;
    @SerializedName(value="drop_items")
    protected List<DropItem> dropItems;
    @SerializedName(value="place_blocks")
    protected List<PlaceBlock> placeBlocks;
    @SerializedName(value="place_chests")
    protected List<PlaceChest> placeChests;
    @SerializedName(value="fall_blocks")
    protected List<FallBlock> fallBlocks;
    @SerializedName(value="give_potion_effects")
    protected List<GivePotionEffect> givePotionEffects;
    @SerializedName(value="spawn_mobs")
    protected List<SpawnMob> spawnMobs;
    @SerializedName(value="send_messages")
    protected List<SendMessage> sendMessages;
    @SerializedName(value="display_messages")
    protected List<DisplayMessage> displayMessages;
    @SerializedName(value="create_explosions")
    protected List<CreateExplosion> createExplosions;
    @SerializedName(value="add_particles")
    protected List<AddParticle> addParticles;
    @SerializedName(value="play_sounds")
    protected List<PlaySound> playSounds;
    @SerializedName(value="load_structures")
    protected List<LoadStructure> loadStructures;
    @SerializedName(value="execute_commands")
    protected List<ExecuteCommand> executeCommands;

    public boolean hasDropItems() {
        return this.dropItems != null && !this.dropItems.isEmpty();
    }

    public boolean hasPlaceBlocks() {
        return this.placeBlocks != null && !this.placeBlocks.isEmpty();
    }

    public boolean hasPlaceChests() {
        return this.placeChests != null && !this.placeChests.isEmpty();
    }

    public boolean hasFallBlocks() {
        return this.fallBlocks != null && !this.fallBlocks.isEmpty();
    }

    public boolean hasGivePotionEffects() {
        return this.givePotionEffects != null && !this.givePotionEffects.isEmpty();
    }

    public boolean hasSpawnMobs() {
        return this.spawnMobs != null && !this.spawnMobs.isEmpty();
    }

    public boolean hasSendMessages() {
        return this.sendMessages != null && !this.sendMessages.isEmpty();
    }

    public boolean hasDisplayMessages() {
        return this.displayMessages != null && !this.displayMessages.isEmpty();
    }

    public boolean hasCreateExplosions() {
        return this.createExplosions != null && !this.createExplosions.isEmpty();
    }

    public boolean hasAddParticles() {
        return this.addParticles != null && !this.addParticles.isEmpty();
    }

    public boolean hasPlaySounds() {
        return this.playSounds != null && !this.playSounds.isEmpty();
    }

    public boolean hasLoadStructures() {
        return this.loadStructures != null && !this.loadStructures.isEmpty();
    }

    public boolean hasExecuteCommands() {
        return this.executeCommands != null && !this.executeCommands.isEmpty();
    }

    public List<DropItem> getDropItems() {
        return this.dropItems;
    }

    public List<PlaceBlock> getPlaceBlocks() {
        return this.placeBlocks;
    }

    public List<PlaceChest> getPlaceChests() {
        return this.placeChests;
    }

    public List<FallBlock> getFallBlocks() {
        return this.fallBlocks;
    }

    public List<GivePotionEffect> getGivePotionEffects() {
        return this.givePotionEffects;
    }

    public List<SpawnMob> getSpawnMobs() {
        return this.spawnMobs;
    }

    public List<SendMessage> getSendMessages() {
        return this.sendMessages;
    }

    public List<DisplayMessage> getDisplayMessages() {
        return this.displayMessages;
    }

    public List<CreateExplosion> getCreateExplosions() {
        return this.createExplosions;
    }

    public List<AddParticle> getAddParticles() {
        return this.addParticles;
    }

    public List<PlaySound> getPlaySounds() {
        return this.playSounds;
    }

    public List<LoadStructure> getLoadStructures() {
        return this.loadStructures;
    }

    public List<ExecuteCommand> getExecuteCommands() {
        return this.executeCommands;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public static class Offset {
        @SerializedName(value="x")
        protected double x;
        @SerializedName(value="y")
        protected double y;
        @SerializedName(value="z")
        protected double z;

        public Offset(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getZ() {
            return this.z;
        }
    }

    public static class Velocity {
        @SerializedName(value="x")
        protected double x;
        @SerializedName(value="y")
        protected double y;
        @SerializedName(value="z")
        protected double z;

        public Velocity(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public double getX() {
            return this.x;
        }

        public double getY() {
            return this.y;
        }

        public double getZ() {
            return this.z;
        }
    }

    public static class RandomNum {
        @SerializedName(value="min")
        protected int min;
        @SerializedName(value="max")
        protected int max;

        public RandomNum(int min, int max) {
            this.min = Mth.clamp((int)min, (int)0, (int)max);
            this.max = Mth.clamp((int)max, (int)min, (int)64);
        }

        public int getMin() {
            return this.min;
        }

        public int getMax() {
            return this.max;
        }
    }

    public static class ExecuteCommand {
        @SerializedName(value="command")
        protected String command;
        @SerializedName(value="pos_src")
        protected int posSrc = 0;
        @SerializedName(value="offset")
        protected Offset offset = new Offset(0.0, 0.0, 0.0);

        public String getCommand() {
            return this.command;
        }

        public PosSrc getPosSrc() {
            return PosSrc.fromValue(this.posSrc);
        }

        public Vec3 getOffset() {
            return new Vec3(this.offset.getX(), this.offset.getY(), this.offset.getZ());
        }
    }

    public static class LoadStructure {
        @SerializedName(value="id")
        protected String id;
        @SerializedName(value="mod_id")
        protected String modId = "myluckyblock";
        @SerializedName(value="pos_src")
        protected int posSrc = 0;
        @SerializedName(value="offset")
        protected Offset offset = new Offset(0.0, 0.0, 0.0);

        public String getId() {
            return this.id;
        }

        public String getModId() {
            return this.modId;
        }

        public PosSrc getPosSrc() {
            return PosSrc.fromValue(this.posSrc);
        }

        public Vec3 getOffset() {
            return new Vec3(this.offset.getX(), this.offset.getY(), this.offset.getZ());
        }
    }

    public static class AddParticle {
        @SerializedName(value="id")
        protected String id;
        @SerializedName(value="count")
        protected int count = 1;
        @SerializedName(value="velocity")
        protected Velocity velocity = new Velocity(1.0, 1.0, 1.0);
        @SerializedName(value="speed")
        protected double speed = 0.0;
        @SerializedName(value="pos_src")
        protected int posSrc = 0;
        @SerializedName(value="offset")
        protected Offset offset = new Offset(0.0, 0.0, 0.0);

        public String getId() {
            return this.id;
        }

        public int getCount() {
            return this.count;
        }

        public Velocity getVelocity() {
            return this.velocity;
        }

        public double getSpeed() {
            return this.speed;
        }

        public PosSrc getPosSrc() {
            return PosSrc.fromValue(this.posSrc);
        }

        public Vec3 getOffset() {
            return new Vec3(this.offset.getX(), this.offset.getY(), this.offset.getZ());
        }
    }

    public static class PlaySound {
        @SerializedName(value="id")
        protected String id;
        @SerializedName(value="volume")
        protected float volume = 1.0f;
        @SerializedName(value="pitch")
        protected float pitch = 1.0f;

        public String getId() {
            return this.id;
        }

        public float getVolume() {
            return this.volume;
        }

        public float getPitch() {
            return this.pitch;
        }
    }

    public static class CreateExplosion {
        @SerializedName(value="pos_src")
        protected int posSrc = 0;
        @SerializedName(value="offset")
        protected Offset offset = new Offset(0.0, 0.0, 0.0);
        @SerializedName(value="power")
        protected int power = 1;
        @SerializedName(value="create_fire")
        protected boolean createFire = false;

        public PosSrc getPosSrc() {
            return PosSrc.fromValue(this.posSrc);
        }

        public Vec3 getOffset() {
            return new Vec3(this.offset.getX(), this.offset.getY(), this.offset.getZ());
        }

        public int getPower() {
            return this.power;
        }

        public boolean isCreateFire() {
            return this.createFire;
        }
    }

    public static class SendMessage {
        @SerializedName(value="msg")
        protected String msg;

        public String getMsg() {
            return this.msg;
        }
    }

    public static class DisplayMessage {
        @SerializedName(value="msg")
        protected String msg;
        @SerializedName(value="overlay")
        protected boolean overlay = true;

        public boolean getOverlay() {
            return this.overlay;
        }

        public String getMsg() {
            return this.msg;
        }
    }

    public static class SpawnMob {
        @SerializedName(value="id")
        protected String id;
        @SerializedName(value="pos_src")
        protected int posSrc = 0;
        @SerializedName(value="offset")
        protected Offset offset = new Offset(0.0, 0.0, 0.0);
        @SerializedName(value="velocity")
        protected Vec3 velocity = new Vec3(0.0, 0.0, 0.0);
        @SerializedName(value="randomize")
        protected boolean randomize = true;
        @SerializedName(value="name")
        protected String name = null;
        @SerializedName(value="name_visible")
        protected boolean nameVisible = false;
        @SerializedName(value="desc")
        protected String desc = null;
        @SerializedName(value="is_baby")
        protected boolean isBaby = false;
        @SerializedName(value="use_random")
        protected boolean useRandom = false;
        @SerializedName(value="random_num")
        protected RandomNum randomNum = new RandomNum(0, 1);
        @SerializedName(value="num")
        protected int num = 1;
        @SerializedName(value="nbt")
        protected String nbt = null;

        public PosSrc getPosSrc() {
            return PosSrc.fromValue(this.posSrc);
        }

        public Vec3 getOffset() {
            return new Vec3(this.offset.getX(), this.offset.getY(), this.offset.getZ());
        }

        public Vec3 getVelocity() {
            return this.velocity;
        }

        public String getId() {
            return this.id;
        }

        public boolean isUseRandom() {
            return this.useRandom;
        }

        public RandomNum getRandomNum() {
            return this.randomNum;
        }

        public boolean getRandomize() {
            return this.randomize;
        }

        public String getName() {
            return this.name;
        }

        public String getDesc() {
            return this.desc;
        }

        public Boolean isNameVisible() {
            return this.nameVisible;
        }

        public Boolean isBaby() {
            return this.isBaby;
        }

        public int getNum() {
            return this.num;
        }

        public String getNbt() {
            return this.nbt;
        }
    }

    public static class GivePotionEffect {
        @SerializedName(value="id")
        protected String id;
        @SerializedName(value="amplifier")
        protected int amplifier = 0;
        @SerializedName(value="duration")
        protected int duration = 1;

        public String getId() {
            return this.id;
        }

        public int getAmplifier() {
            return this.amplifier;
        }

        public int getDuration() {
            return this.duration;
        }
    }

    public static class FallBlock {
        @SerializedName(value="id")
        protected String id;
        @SerializedName(value="pos_src")
        protected int posSrc = 0;
        @SerializedName(value="offset")
        protected Offset offset = new Offset(0.0, 0.0, 0.0);
        @SerializedName(value="velocity")
        protected Vec3 velocity = new Vec3(0.0, 0.0, 0.0);

        public PosSrc getPosSrc() {
            return PosSrc.fromValue(this.posSrc);
        }

        public Vec3 getOffset() {
            return new Vec3(this.offset.getX(), this.offset.getY(), this.offset.getZ());
        }

        public Vec3 getVelocity() {
            return this.velocity;
        }

        public String getId() {
            return this.id;
        }
    }

    public static class PlaceChest {
        @SerializedName(value="id")
        protected String id = "empty";
        @SerializedName(value="chest_id")
        protected String chestId = "minecraft:chest";
        @SerializedName(value="pos_src")
        protected int posSrc = 0;
        @SerializedName(value="offset")
        protected Offset offset = new Offset(0.0, 0.0, 0.0);

        public PosSrc getPosSrc() {
            return PosSrc.fromValue(this.posSrc);
        }

        public Vec3 getOffset() {
            return new Vec3(this.offset.getX(), this.offset.getY(), this.offset.getZ());
        }

        public String getId() {
            return this.id;
        }

        public String getChestId() {
            return this.chestId;
        }
    }

    public static class PlaceBlock {
        @SerializedName(value="id")
        protected String id;
        @SerializedName(value="pos_src")
        protected int posSrc = 0;
        @SerializedName(value="offset")
        protected Offset offset = new Offset(0.0, 0.0, 0.0);

        public String getId() {
            return this.id;
        }

        public PosSrc getPosSrc() {
            return PosSrc.fromValue(this.posSrc);
        }

        public Vec3 getOffset() {
            return new Vec3(this.offset.getX(), this.offset.getY(), this.offset.getZ());
        }
    }

    public static class DropItem {
        @SerializedName(value="id")
        protected String id;
        @SerializedName(value="use_random")
        protected boolean useRandom = false;
        @SerializedName(value="random_num")
        protected RandomNum randomNum = new RandomNum(0, 1);
        @SerializedName(value="num")
        protected int num = 1;
        @SerializedName(value="pos_src")
        protected int posSrc = 0;
        @SerializedName(value="offset")
        protected Offset offset = new Offset(0.0, 0.0, 0.0);
        @SerializedName(value="name")
        protected String name = null;
        @SerializedName(value="name_visible")
        protected boolean nameVisible = false;
        @SerializedName(value="desc")
        protected String desc = null;
        @SerializedName(value="nbt")
        protected String nbt = null;

        public String getId() {
            return this.id;
        }

        public boolean isUseRandom() {
            return this.useRandom;
        }

        public RandomNum getRandomNum() {
            return this.randomNum;
        }

        public int getNum() {
            return Mth.clamp((int)this.num, (int)1, (int)64);
        }

        public PosSrc getPosSrc() {
            return PosSrc.fromValue(this.posSrc);
        }

        public Vec3 getOffset() {
            return new Vec3(this.offset.getX(), this.offset.getY(), this.offset.getZ());
        }

        public String getName() {
            return this.name;
        }

        public boolean isNameVisible() {
            return this.nameVisible;
        }

        public String getDesc() {
            return this.desc;
        }

        public String getNbt() {
            return this.nbt;
        }
    }
}

