/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.nohostilesaroundcampfire_common_neoforge.events;

import com.natamus.collective_common_neoforge.data.BlockEntityData;
import com.natamus.collective_common_neoforge.functions.CompareBlockFunctions;
import com.natamus.collective_common_neoforge.functions.EntityFunctions;
import com.natamus.nohostilesaroundcampfire_common_neoforge.config.ConfigHandler;
import com.natamus.nohostilesaroundcampfire_common_neoforge.util.Util;
import java.util.HashMap;
import java.util.List;
import java.util.WeakHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;

public class CampfireEvent {
    private static final HashMap<Level, List<BlockPos>> checkCampfireBurn = new HashMap();

    public static void onCampfireAdded(Level level, BlockEntity blockEntity, BlockEntityType<?> blockEntityType) {
        if (level.isClientSide()) {
            return;
        }
        if (!blockEntityType.equals((Object)BlockEntityType.CAMPFIRE)) {
            return;
        }
        BlockPos campfirePos = blockEntity.getBlockPos();
        BlockState campfireState = blockEntity.getBlockState();
        if (CompareBlockFunctions.blockIsInRegistryHolder((Block)campfireState.getBlock(), (TagKey)BlockTags.CAMPFIRES)) {
            boolean isLit = true;
            if (ConfigHandler.campfireMustBeLit) {
                isLit = (Boolean)campfireState.getValue((Property)CampfireBlock.LIT);
            }
            if (isLit) {
                int r = (int)((double)ConfigHandler.preventHostilesRadius * ConfigHandler.burnHostilesRadiusModifier);
                List entities = level.getEntities(null, new AABB((double)(campfirePos.getX() - r), (double)(campfirePos.getY() - r), (double)(campfirePos.getZ() - r), (double)(campfirePos.getX() + r), (double)(campfirePos.getY() + r), (double)(campfirePos.getZ() + r)));
                for (Entity entity : entities) {
                    if (!Util.entityIsHostile(entity)) continue;
                    entity.setRemainingFireTicks(600);
                }
            }
        }
    }

    public static boolean onEntityCheckSpawn(Mob mob, ServerLevel level, BlockPos spawnerPos, EntitySpawnReason spawnReason) {
        if (mob == null) {
            return true;
        }
        if (mob.getTags().contains("nohostilesaroundcampfire.checked")) {
            return true;
        }
        mob.addTag("nohostilesaroundcampfire.checked");
        if (!ConfigHandler.preventMobSpawnerSpawns && EntityFunctions.isEntityFromSpawner((Entity)mob).booleanValue()) {
            return true;
        }
        if (!Util.entityIsHostile((Entity)mob)) {
            return true;
        }
        if (!((WeakHashMap)BlockEntityData.cachedBlockEntities.get(BlockEntityType.CAMPFIRE)).containsKey(level)) {
            return true;
        }
        BlockPos entityPos = mob.blockPosition();
        Vec3i entityVec3i = new Vec3i(entityPos.getX(), entityPos.getY(), entityPos.getZ());
        boolean foundCampfire = false;
        for (BlockEntity campfireBlockEntity : (CopyOnWriteArrayList)((WeakHashMap)BlockEntityData.cachedBlockEntities.get(BlockEntityType.CAMPFIRE)).get(level)) {
            Boolean issignalling;
            Boolean isLit;
            BlockState campfireState;
            Block block;
            if (!campfireBlockEntity.getBlockPos().closerThan(entityVec3i, (double)ConfigHandler.preventHostilesRadius) || !((block = (campfireState = campfireBlockEntity.getBlockState()).getBlock()) instanceof CampfireBlock) || !ConfigHandler.enableEffectForNormalCampfires && block.equals(Blocks.CAMPFIRE) || !ConfigHandler.enableEffectForSoulCampfires && block.equals(Blocks.SOUL_CAMPFIRE) || ConfigHandler.campfireMustBeLit && !(isLit = (Boolean)campfireState.getValue((Property)CampfireBlock.LIT)).booleanValue() || ConfigHandler.campfireMustBeSignalling && !(issignalling = (Boolean)campfireState.getValue((Property)CampfireBlock.SIGNAL_FIRE)).booleanValue()) continue;
            foundCampfire = true;
            break;
        }
        if (!foundCampfire) {
            return true;
        }
        List passengers = mob.getPassengers();
        if (passengers.size() > 0) {
            for (Entity passenger : passengers) {
                passenger.remove(Entity.RemovalReason.DISCARDED);
            }
        }
        return false;
    }

    public static void onCampfireRemoved(Level level, BlockEntity blockEntity, BlockEntityType<?> blockEntityType) {
        if (level.isClientSide()) {
            return;
        }
        if (!blockEntityType.equals((Object)BlockEntityType.CAMPFIRE)) {
            return;
        }
        if (!ConfigHandler.burnHostilesAroundWhenPlaced) {
            return;
        }
        Block block = blockEntity.getBlockState().getBlock();
        if (!CompareBlockFunctions.blockIsInRegistryHolder((Block)block, (TagKey)BlockTags.CAMPFIRES)) {
            return;
        }
        if (!ConfigHandler.enableEffectForNormalCampfires && block.equals(Blocks.CAMPFIRE)) {
            return;
        }
        if (!ConfigHandler.enableEffectForSoulCampfires && block.equals(Blocks.SOUL_CAMPFIRE)) {
            return;
        }
        BlockPos campfirePos = blockEntity.getBlockPos();
        int r = (int)((double)ConfigHandler.preventHostilesRadius * ConfigHandler.burnHostilesRadiusModifier);
        for (Entity entity : level.getEntities(null, new AABB((double)(campfirePos.getX() - r), (double)(campfirePos.getY() - r), (double)(campfirePos.getZ() - r), (double)(campfirePos.getX() + r), (double)(campfirePos.getY() + r), (double)(campfirePos.getZ() + r)))) {
            if (!Util.entityIsHostile(entity) || !entity.isOnFire()) continue;
            entity.clearFire();
            entity.setRemainingFireTicks(40);
        }
    }
}

