/*
 * Decompiled with CFR 0.152.
 */
package page.langeweile.ok_zoomer.utils;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.function.Predicate;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.toasts.SystemToast;
import net.minecraft.client.gui.components.toasts.Toast;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import page.langeweile.ok_zoomer.config.ConfigEnums;
import page.langeweile.ok_zoomer.config.OkZoomerConfigManager;
import page.langeweile.ok_zoomer.key_binds.ZoomKeyBinds;
import page.langeweile.ok_zoomer.utils.ModUtils;
import page.langeweile.ok_zoomer.utils.Portals;
import page.langeweile.ok_zoomer.zoom.Zoom;

public class ZoomUtils {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Ok Zoomer");
    public static final SystemToast.SystemToastId TOAST_ID = new SystemToast.SystemToastId();
    public static final TagKey<Item> ZOOM_DEPENDENCIES_TAG = TagKey.create((ResourceKey)Registries.ITEM, (Identifier)ModUtils.id("zoom_dependencies"));
    public static int zoomStep = 0;
    private static Predicate<LocalPlayer> hasSpyglass = player -> player.isCreative();
    private static boolean safeSmartOcclusion = false;
    private static Float fadeModifier = null;

    public static void changeZoomDivisor(boolean increase) {
        Minecraft minecraft = Minecraft.getInstance();
        int scrollBase = (Integer)OkZoomerConfigManager.CONFIG.zoomValues.scrollBase.value();
        int scrollResolution = (Integer)OkZoomerConfigManager.CONFIG.zoomValues.scrollResolution.value();
        int upperScrollStep = (Integer)OkZoomerConfigManager.CONFIG.zoomValues.scrollStepLimit.value();
        int lowerScrollStep = 0;
        int lastZoomStep = zoomStep;
        zoomStep = increase ? Math.min(zoomStep + 1, upperScrollStep) : Math.max(zoomStep - 1, -lowerScrollStep);
        double divisor = 1.0;
        if (zoomStep != 0) {
            divisor = Math.pow(scrollBase, (double)zoomStep / (double)scrollResolution);
            Zoom.setZoomDivisor(divisor);
        } else {
            Zoom.setZoomDivisor(1.0);
        }
        if (lastZoomStep != zoomStep && ((Boolean)OkZoomerConfigManager.CONFIG.tweaks.scrollSounds.value()).booleanValue()) {
            minecraft.player.playSound(Portals.getScrollSound(), 1.0f, 1.0f);
        }
        if (((Boolean)OkZoomerConfigManager.CONFIG.tweaks.debugScrolling.value()).booleanValue()) {
            minecraft.player.displayClientMessage((Component)Component.literal((String)(zoomStep + " - " + divisor)), true);
        }
    }

    public static void resetZoomDivisor(boolean userPrompted) {
        if (!userPrompted && !((Boolean)OkZoomerConfigManager.CONFIG.tweaks.forgetZoomDivisor.value()).booleanValue()) {
            return;
        }
        int scrollBase = (Integer)OkZoomerConfigManager.CONFIG.zoomValues.scrollBase.value();
        int scrollResolution = (Integer)OkZoomerConfigManager.CONFIG.zoomValues.scrollResolution.value();
        zoomStep = (Integer)OkZoomerConfigManager.CONFIG.zoomValues.defaultScrollStep.value();
        Zoom.setZoomDivisor(Math.pow(scrollBase, (double)zoomStep / (double)scrollResolution));
    }

    public static void keepZoomStepsWithinBounds() {
        zoomStep = Mth.clamp((int)zoomStep, (int)0, (int)((Integer)OkZoomerConfigManager.CONFIG.zoomValues.scrollStepLimit.value()));
    }

    public static void unbindConflictingKey(Minecraft client, boolean userPrompted) {
        if (ZoomKeyBinds.ZOOM_KEY.isDefault()) {
            if (client.options.keySaveHotbarActivator.isDefault()) {
                if (userPrompted) {
                    LOGGER.info("[Ok Zoomer] The \"Save Toolbar Activator\" keybind was occupying C! Unbinding...");
                    client.getToastManager().addToast((Toast)SystemToast.multiline((Minecraft)client, (SystemToast.SystemToastId)TOAST_ID, (Component)Component.translatable((String)"toast.ok_zoomer.title"), (Component)Component.translatable((String)"toast.ok_zoomer.unbind_conflicting_key.success")));
                } else {
                    LOGGER.info("[Ok Zoomer] The \"Save Toolbar Activator\" keybind was occupying C! Unbinding... This process won't be repeated until specified in the config.");
                }
                client.options.keySaveHotbarActivator.setKey(InputConstants.UNKNOWN);
                client.options.save();
                KeyMapping.resetMapping();
            } else {
                LOGGER.info("[Ok Zoomer] No conflicts with the \"Save Toolbar Activator\" keybind were found!");
                if (userPrompted) {
                    client.getToastManager().addToast((Toast)SystemToast.multiline((Minecraft)client, (SystemToast.SystemToastId)TOAST_ID, (Component)Component.translatable((String)"toast.ok_zoomer.title"), (Component)Component.translatable((String)"toast.ok_zoomer.unbind_conflicting_key.no_conflict")));
                }
            }
        }
    }

    public static boolean hasSpyglass(LocalPlayer player) {
        return hasSpyglass.test(player);
    }

    public static void addSpyglassProvider(Predicate<LocalPlayer> provider) {
        hasSpyglass = hasSpyglass.or(provider);
    }

    public static void enableSafeSmartOcclusion() {
        safeSmartOcclusion = true;
    }

    public static boolean hasSmartOcclusion() {
        return (Boolean)OkZoomerConfigManager.CONFIG.tweaks.smartOcclusion.value() != false && safeSmartOcclusion;
    }

    public static boolean canSeeDistantEntities() {
        return switch ((ConfigEnums.SeeDistantEntitiesModes)OkZoomerConfigManager.CONFIG.tweaks.seeDistantEntities.value()) {
            default -> throw new MatchException(null, null);
            case ConfigEnums.SeeDistantEntitiesModes.SAFE -> safeSmartOcclusion;
            case ConfigEnums.SeeDistantEntitiesModes.ON -> true;
            case ConfigEnums.SeeDistantEntitiesModes.OFF -> false;
        };
    }

    public static Float getFadeModifier() {
        return fadeModifier;
    }

    public static void setFadeModifier(Float fadeModifier) {
        ZoomUtils.fadeModifier = fadeModifier;
    }
}

