/*
 * Decompiled with CFR 0.152.
 */
package page.langeweile.ok_zoomer.zoom.overlays;

import net.minecraft.client.DeltaTracker;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Mth;
import page.langeweile.ok_zoomer.zoom.overlays.ZoomOverlay;
import page.langeweile.ok_zoomer.zoom.transitions.TransitionMode;

public class SpyglassZoomOverlay
implements ZoomOverlay {
    private final Identifier textureId;
    private float scale;
    private boolean active;

    public SpyglassZoomOverlay(Identifier textureId) {
        this.textureId = textureId;
        this.scale = 0.5f;
        this.active = false;
    }

    @Override
    public boolean getActive() {
        return this.active;
    }

    @Override
    public boolean cancelOverlayRendering() {
        return true;
    }

    @Override
    public void renderOverlay(GuiGraphics graphics, DeltaTracker deltaTracker, TransitionMode transitionMode) {
        int guiWidth = graphics.guiWidth();
        int guiHeight = graphics.guiHeight();
        float smallerLength = Math.min(guiWidth, guiHeight);
        float scaledSmallerLength = Math.min((float)guiWidth / smallerLength, (float)guiHeight / smallerLength) * this.scale;
        int width = Mth.floor((float)(smallerLength * scaledSmallerLength));
        int height = Mth.floor((float)(smallerLength * scaledSmallerLength));
        int x = (guiWidth - width) / 2;
        int y = (guiHeight - height) / 2;
        int borderX = x + width;
        int borderY = y + height;
        graphics.blit(RenderPipelines.GUI_TEXTURED, this.textureId, x, y, 0.0f, 0.0f, width, height, width, height);
        graphics.fill(RenderPipelines.GUI, 0, borderY, guiWidth, guiHeight, -16777216);
        graphics.fill(RenderPipelines.GUI, 0, 0, guiWidth, y, -16777216);
        graphics.fill(RenderPipelines.GUI, 0, y, x, borderY, -16777216);
        graphics.fill(RenderPipelines.GUI, borderX, y, guiWidth, borderY, -16777216);
    }

    @Override
    public void tick(boolean active, double divisor, TransitionMode transitionMode) {
        this.active = active;
    }

    @Override
    public void tickBeforeRender(DeltaTracker deltaTracker) {
        this.scale = !this.active ? 0.5f : Mth.lerp((float)(0.5f * deltaTracker.getGameTimeDeltaTicks()), (float)this.scale, (float)1.125f);
    }
}

