/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.pumpkillagersquest_common_forge.util;

import com.mojang.datafixers.util.Pair;
import com.natamus.collective_common_forge.data.GlobalVariables;
import com.natamus.collective_common_forge.functions.BlockPosFunctions;
import com.natamus.pumpkillagersquest_common_forge.util.Scheduler;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.Identifier;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.villager.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CarvedPumpkinBlock;
import net.minecraft.world.level.block.PumpkinBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Util {
    public static Pair<Player, MutableComponent> modifyMessagePair(Pair<Player, MutableComponent> pair, MutableComponent newMessageComponent) {
        return new Pair((Object)((Player)pair.getFirst()), (Object)newMessageComponent);
    }

    public static boolean isPumpkillager(Entity entity) {
        if (entity instanceof Villager) {
            Villager villager = (Villager)entity;
            return Util.isPumpkillager(villager.getName(), villager.getOffhandItem());
        }
        return false;
    }

    public static boolean isPumpkillager(@Nullable Component nameComponent, ItemStack offhandStack) {
        if (nameComponent != null && nameComponent.getString().contains("The Pumpkillager")) {
            return true;
        }
        try {
            if (!offhandStack.isEmpty()) {
                return offhandStack.getItem().equals(Items.BARRIER);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    public static boolean isPrisoner(Entity entity) {
        return entity instanceof Villager && entity.getTags().contains("pumpkillagersquest.prisoner");
    }

    public static boolean prisonerIsKnown(Villager character, Player player) {
        return character.getTags().contains("pumpkillagersquest.isknownto." + player.getName().getString());
    }

    public static boolean isPumpkinBlock(Block block) {
        return block instanceof PumpkinBlock || block instanceof CarvedPumpkinBlock;
    }

    public static boolean pumpkinBlockIsClear(Level level, BlockPos pumpkinPos) {
        BlockPos abovePumpkinPos = pumpkinPos.above().immutable();
        ArrayList<BlockPos> toCheckPositions = new ArrayList<BlockPos>(Stream.concat(Util.getSidePositions(pumpkinPos.immutable()).stream(), Util.getSidePositions(abovePumpkinPos).stream()).toList());
        toCheckPositions.add(abovePumpkinPos);
        for (BlockPos aroundPos : toCheckPositions) {
            BlockState aroundState = level.getBlockState(aroundPos);
            MapColor material = aroundState.getMapColor((BlockGetter)level, aroundPos);
            if (aroundState.getLightBlock() < 15 && !GlobalVariables.surfacematerials.contains(material)) continue;
            return false;
        }
        return true;
    }

    public static List<BlockPos> getSidePositions(BlockPos pos) {
        return Arrays.asList(pos.north(), pos.east(), pos.south(), pos.west());
    }

    public static BlockPos getPrisonerCampCoordinates(Level level, Villager pumpkillager, Player player) {
        String coordinates = "";
        if (level.isClientSide()) {
            return null;
        }
        return BlockPosFunctions.getRandomCoordinatesInNearestUngeneratedChunk((ServerLevel)((ServerLevel)level), (BlockPos)pumpkillager.blockPosition());
    }

    public static void spawnLightning(Level level, BlockPos pos, LivingEntity target, Player player, boolean healTarget) {
        LightningBolt lightningbolt = (LightningBolt)EntityType.LIGHTNING_BOLT.create(level, EntitySpawnReason.EVENT);
        lightningbolt.setPos(Vec3.atBottomCenterOf((Vec3i)pos));
        level.addFreshEntity((Entity)lightningbolt);
        if (player != null) {
            player.playSound(SoundEvents.LIGHTNING_BOLT_THUNDER, 5.0f, 1.0f);
        }
        Scheduler.scheduleFireExtuingish(level, pos, target, healTarget);
    }

    public static InputStream getSchematicsInputStream(MinecraftServer minecraftServer, String schematicName) {
        return Util.getSchematicsInputStream(minecraftServer, schematicName, ".schem");
    }

    public static InputStream getSchematicsInputStream(MinecraftServer minecraftServer, String schematicName, String fileExtension) {
        try {
            Optional resourceOptional = minecraftServer.getResourceManager().getResource(Identifier.parse((String)("pumpkillagersquest:schematics/" + schematicName + fileExtension)));
            if (resourceOptional.isPresent()) {
                Resource resource = (Resource)resourceOptional.get();
                return resource.open();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static float roundFloat(float d, int decimalPlace) {
        BigDecimal bd = new BigDecimal(Float.toString(d));
        bd = bd.setScale(decimalPlace, RoundingMode.HALF_UP);
        return bd.floatValue();
    }

    public static EntityDimensions getDefaultVillagerDimensions() {
        return EntityDimensions.scalable((float)0.6f, (float)1.95f);
    }
}

