/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.pumpkillagersquest_common_neoforge.pumpkillager;

import com.mojang.datafixers.util.Pair;
import com.natamus.pumpkillagersquest_common_neoforge.pumpkillager.Actions;
import com.natamus.pumpkillagersquest_common_neoforge.util.Data;
import com.natamus.pumpkillagersquest_common_neoforge.util.Scheduler;
import com.natamus.pumpkillagersquest_common_neoforge.util.SpookyHeads;
import com.natamus.pumpkillagersquest_common_neoforge.util.Util;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.npc.villager.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class Conversations {
    public static void startTalking(Level level, Villager character, Player targetPlayer, int conversationId) {
        switch (conversationId) {
            case 0: {
                Conversations.startInitialConversation(level, character, targetPlayer);
                break;
            }
            case 1: {
                Conversations.startPostRitualConversation(level, character, targetPlayer);
                break;
            }
            case 2: {
                Conversations.startPostAncientFormConversation(level, character, targetPlayer);
                break;
            }
            case 3: {
                Conversations.startInitialPrisonerShout(level, character, targetPlayer);
                break;
            }
            case 4: {
                Conversations.startPostPrisonerShout(level, character, targetPlayer);
                break;
            }
            case 5: {
                Conversations.startGettingToKnowPrisoner(level, character, targetPlayer);
                break;
            }
            case 6: {
                Conversations.startPrisonerGenerationConversation(level, character, targetPlayer);
                break;
            }
            case 7: {
                Conversations.startInitialFinalBossConversation(level, character, targetPlayer);
                break;
            }
            case 8: {
                Conversations.bossJustGotWeakenedConversation(level, character, targetPlayer);
                break;
            }
            case 9: {
                Conversations.postFinalPrisonerConversation(level, character, targetPlayer);
            }
        }
    }

    public static void startInitialConversation(Level level, Villager pumpkillager, Player targetPlayer) {
        Conversations.addEmptyMessage(level, pumpkillager, targetPlayer, 0);
        Conversations.addMessage(level, pumpkillager, targetPlayer, "Hello " + targetPlayer.getName().getString() + ".", ChatFormatting.WHITE, 0);
        Conversations.addMessage(level, pumpkillager, targetPlayer, "I am the Pumpkillager.", ChatFormatting.WHITE, 2000);
        Conversations.addMessage(level, pumpkillager, targetPlayer, "I have a quest for you.", ChatFormatting.WHITE, 4000, new ItemStack((ItemLike)Items.WRITTEN_BOOK, 1), "hold");
        Conversations.addMessage(level, pumpkillager, targetPlayer, "Right-click the book to accept.", ChatFormatting.GRAY, 5000);
    }

    public static void startPostRitualConversation(Level level, Villager pumpkillager, Player targetPlayer) {
        pumpkillager.getTags().add("pumpkillagersquest.nodamage");
        Conversations.addEmptyMessage(level, pumpkillager, targetPlayer, 500);
        Conversations.addMessage(level, pumpkillager, targetPlayer, "Hehehehehehe.", ChatFormatting.GRAY, 510);
        Conversations.addMessage(level, pumpkillager, targetPlayer, "Thank you, " + targetPlayer.getName().getString() + ".", ChatFormatting.WHITE, 3000);
        Conversations.addMessage(level, pumpkillager, targetPlayer, "You have freed me from these shackles.", ChatFormatting.WHITE, 5000, SpookyHeads.getEvilJackoLantern(1), "wear");
        Conversations.addMessage(level, pumpkillager, targetPlayer, "My ancient form has been returned.", ChatFormatting.WHITE, 6000);
    }

    public static void startPostAncientFormConversation(Level level, Villager pumpkillager, Player targetPlayer) {
        CompletableFuture.runAsync(() -> {
            ItemStack paperStack = Actions.generatePrisonAndCoordinatePaper(level, pumpkillager, targetPlayer);
            Conversations.addEmptyMessage(level, pumpkillager, targetPlayer, 0);
            Conversations.addMessage(level, pumpkillager, targetPlayer, "Are you surprised, mortal?", ChatFormatting.WHITE, 10);
            Conversations.addMessage(level, pumpkillager, targetPlayer, "I've been stuck in that tiny form for eons.", ChatFormatting.WHITE, 2500);
            Conversations.addMessage(level, pumpkillager, targetPlayer, "Now that I'm free, I can finally continue my quest for world domination.", ChatFormatting.WHITE, 5000);
            Conversations.addMessage(level, pumpkillager, targetPlayer, "Goodbye, " + targetPlayer.getName().getString() + ". There's no reward, sorry.", ChatFormatting.WHITE, 7500);
            Conversations.addMessageWithoutPrefix(level, pumpkillager, targetPlayer, "As the Pumpkillager flies away, you see something fall out of his pocket.", ChatFormatting.GRAY, 8490, paperStack, "drop");
            Scheduler.scheduleCharacterLeave(level, pumpkillager, 8500);
        });
    }

    public static void startInitialPrisonerShout(Level level, Villager prisoner, Player targetPlayer) {
        if (prisoner.getTags().contains("pumpkillagersquest.shoutedto." + targetPlayer.getName().getString())) {
            return;
        }
        prisoner.getTags().add("pumpkillagersquest.shoutedto." + targetPlayer.getName().getString());
        Conversations.addMessage(level, prisoner, targetPlayer, "Hey, over here!", ChatFormatting.WHITE, 0);
        Conversations.addMessage(level, prisoner, targetPlayer, "I'm inside the tree!", ChatFormatting.WHITE, 4000);
        Conversations.addMessage(level, prisoner, targetPlayer, "Help me!", ChatFormatting.WHITE, 5500);
        Actions.makePrisonerGuardsStepOffHorse(level, prisoner, targetPlayer);
    }

    public static void startPostPrisonerShout(Level level, Villager prisoner, Player targetPlayer) {
        String targetPlayerName;
        Set prisonerTags = prisoner.getTags();
        if (prisonerTags.contains("pumpkillagersquest.isknownto." + (targetPlayerName = targetPlayer.getName().getString())) || prisonerTags.contains("pumpkillagersquest.shoutedtotwice." + targetPlayerName)) {
            return;
        }
        Conversations.addMessageWithoutPrefix(level, prisoner, targetPlayer, "Right click the prisoner to talk to him.", ChatFormatting.GRAY, 3000);
        prisoner.getTags().add("pumpkillagersquest.shoutedtotwice." + targetPlayerName);
    }

    public static void startGettingToKnowPrisoner(Level level, Villager prisoner, Player targetPlayer) {
        prisoner.getTags().add("pumpkillagersquest.isknownto." + targetPlayer.getName().getString());
        prisoner.getTags().remove("pumpkillagersquest.persistent");
        prisoner.setCustomName((Component)Component.literal((String)"Jax o'Saturn").withStyle(Data.defaultPrisonerColour));
        Conversations.addEmptyMessage(level, prisoner, targetPlayer, 0);
        Conversations.addMessage(level, prisoner, targetPlayer, "Hello, my name is Jax o'Saturn.", ChatFormatting.WHITE, 10);
        Conversations.addMessage(level, prisoner, targetPlayer, "Did you come here to save me, " + targetPlayer.getName().getString() + "?", ChatFormatting.WHITE, 4000);
        Conversations.addMessage(level, prisoner, targetPlayer, "I have been locked in here by a creature which called himself the Pumpkillager.", ChatFormatting.WHITE, 8000);
        Conversations.addMessage(level, prisoner, targetPlayer, "I've heard stories about this mythical being when I was young, but didn't think he'd be real.", ChatFormatting.WHITE, 12000);
        Conversations.addMessage(level, prisoner, targetPlayer, "Never thought I would get out, until I saw you appear through the bars.", ChatFormatting.WHITE, 16000);
        Conversations.addMessage(level, prisoner, targetPlayer, "Thanks so much for creating a way out. My magic has disappeared since I've been in here.", ChatFormatting.WHITE, 20000);
        Conversations.addEmptyMessage(level, prisoner, targetPlayer, 24000);
        Conversations.addMessage(level, prisoner, targetPlayer, "You'll need this book. It contains ancient knowledge on how to stop him. Read it thoroughly.", ChatFormatting.WHITE, 24010, Data.getStopPkbook(level), "give");
        Conversations.addEmptyMessage(level, prisoner, targetPlayer, 29000);
        Conversations.addMessage(level, prisoner, targetPlayer, "I believe if you follow that ritual, it should summon the Pumpkillager.", ChatFormatting.WHITE, 29010);
        Conversations.addMessage(level, prisoner, targetPlayer, "Oh hmm I feel my magic tingle. Let me try something.", ChatFormatting.GRAY, 33500);
        Actions.processPrisonerItemGeneration(level, prisoner, targetPlayer, 36000);
    }

    public static void startPrisonerGenerationConversation(Level level, Villager prisoner, Player targetPlayer) {
        ItemStack bowStack = new ItemStack((ItemLike)Items.BOW, 1);
        bowStack.enchant((Holder)level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).getOrThrow(Enchantments.POWER), 3);
        ItemStack arrowStack = new ItemStack((ItemLike)Items.SPECTRAL_ARROW, 4);
        Conversations.addEmptyMessage(level, prisoner, targetPlayer, 1500);
        Conversations.addMessage(level, prisoner, targetPlayer, "My magic is coming back, thank Notch.", ChatFormatting.GRAY, 1510);
        Conversations.addEmptyMessage(level, prisoner, targetPlayer, 4000);
        Conversations.addMessage(level, prisoner, targetPlayer, "Take these arrows, you'll need them to defeat the Pumpkillager.", ChatFormatting.WHITE, 4010, arrowStack, "give");
        Conversations.addEmptyMessage(level, prisoner, targetPlayer, 8000);
        Conversations.addMessage(level, prisoner, targetPlayer, "This bow will probably come in useful too.", ChatFormatting.WHITE, 8010, bowStack, "give");
        Conversations.addEmptyMessage(level, prisoner, targetPlayer, 12000);
        Conversations.addMessage(level, prisoner, targetPlayer, "Now be quick, before it's too late. Perform the reversed ritual from the book, and destroy that creature once and for all.", ChatFormatting.WHITE, 12010);
        Conversations.addMessage(level, prisoner, targetPlayer, "You are going to need candles for the ritual. There should be some around here on the island.", ChatFormatting.WHITE, 16000);
        Conversations.addMessage(level, prisoner, targetPlayer, "I'll be there too when you summon the Pumpkillager. Good bye, and thanks again!", ChatFormatting.WHITE, 20000);
        Scheduler.scheduleCharacterLeave(level, prisoner, 22500);
        targetPlayer.getTags().add("pumpkillagersquest.cansummonfinalform");
    }

    public static void startInitialFinalBossConversation(Level level, Villager pumpkillager, Player targetPlayer) {
        pumpkillager.lookAt(EntityAnchorArgument.Anchor.EYES, targetPlayer.position());
        String suffixa = "";
        String suffixb = "";
        if (targetPlayer.getTags().contains("pumpkillagersquest.diedonce")) {
            suffixa = " AGAIN";
            suffixb = " still";
        }
        Conversations.addEmptyMessage(level, pumpkillager, targetPlayer, 0);
        Conversations.addMessage(level, pumpkillager, targetPlayer, "Huh.. how did I get here.", ChatFormatting.GRAY, 10);
        Conversations.addMessage(level, pumpkillager, targetPlayer, "YOU" + suffixa + "!", ChatFormatting.WHITE, 2500);
        Conversations.addMessage(level, pumpkillager, targetPlayer, "I" + suffixb + " don't know how you managed to complete this ritual correctly, but you're going to regret it.", ChatFormatting.WHITE, 4500);
        Conversations.addEmptyMessage(level, pumpkillager, targetPlayer, 8500);
        Conversations.addMessage(level, pumpkillager, targetPlayer, "FEEL MY WRATH", ChatFormatting.WHITE, 8510);
        Scheduler.scheduleMinionSummoning(level, pumpkillager, targetPlayer, 0, 9000);
    }

    public static void bossJustGotWeakenedConversation(Level level, Villager pumpkillager, Player targetPlayer) {
        Conversations.addEmptyMessage(level, pumpkillager, targetPlayer, 50);
        Conversations.addMessage(level, pumpkillager, targetPlayer, "AAAAGHHHHHH", ChatFormatting.GOLD, 60);
        Conversations.addMessage(level, pumpkillager, targetPlayer, "It hurts! What did you do to me?", ChatFormatting.WHITE, 1000);
    }

    public static void postFinalPrisonerConversation(Level level, Villager prisoner, Player targetPlayer) {
        Registry enchantmentsRegistry = level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT);
        ItemStack rewardStack = new ItemStack((ItemLike)Items.NETHERITE_SWORD, 1);
        rewardStack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)"Pumpkalibur").withStyle(ChatFormatting.GOLD));
        rewardStack.enchant((Holder)enchantmentsRegistry.getOrThrow(Enchantments.SHARPNESS), 4);
        rewardStack.enchant((Holder)enchantmentsRegistry.getOrThrow(Enchantments.SWEEPING_EDGE), 3);
        Conversations.addEmptyMessage(level, prisoner, targetPlayer, 0);
        Conversations.addMessage(level, prisoner, targetPlayer, "You did it, " + targetPlayer.getName().getString() + "!", ChatFormatting.WHITE, 500);
        Conversations.addMessage(level, prisoner, targetPlayer, "With the Pumpkillager defeated, the world has lost its most dangerous threat.", ChatFormatting.WHITE, 4500);
        Conversations.addMessage(level, prisoner, targetPlayer, "Take this, you've earned it.", ChatFormatting.WHITE, 8500, rewardStack, "give");
        Conversations.addEmptyMessage(level, prisoner, targetPlayer, 12500);
        Conversations.addMessage(level, prisoner, targetPlayer, "The citizens of this world will not forget this.", ChatFormatting.WHITE, 12510);
        Conversations.addMessage(level, prisoner, targetPlayer, "Thank you.", ChatFormatting.WHITE, 16500);
        Scheduler.scheduleCharacterLeave(level, prisoner, 18000);
    }

    public static void addMessage(Level level, Villager character, Player player, MutableComponent messageComponent, int msDelay) {
        Conversations.addMessage(level, character, player, messageComponent, msDelay, null, "");
    }

    public static void addMessage(Level level, Villager character, Player player, MutableComponent messageComponent, int msDelay, ItemStack itemStack, String itemStackBehaviour) {
        Conversations.addMessage(level, character, (Pair<Player, MutableComponent>)new Pair((Object)player, (Object)messageComponent), msDelay, itemStack, itemStackBehaviour);
    }

    public static void addMessage(Level level, Villager character, Player player, String message, ChatFormatting colour, int msDelay) {
        Conversations.addMessage(level, character, player, message, colour, msDelay, null, "");
    }

    public static void addMessage(Level level, Villager character, Player player, String message, ChatFormatting colour, int msDelay, ItemStack itemStack, String itemStackBehaviour) {
        Conversations.addMessage(level, character, Conversations.createMessagePair(player, message, colour), msDelay, itemStack, itemStackBehaviour);
    }

    public static void addMessage(Level level, Villager character, Pair<Player, MutableComponent> messagePair, int msDelay) {
        Conversations.addMessage(level, character, messagePair, msDelay, null, "");
    }

    public static void addMessage(Level level, Villager character, Pair<Player, MutableComponent> messagePair, int msDelay, ItemStack itemStack, String itemStackBehaviour) {
        if (character != null && character.getTags().contains("pumpkillagersquest.iskilled")) {
            return;
        }
        if (msDelay == 0) {
            Data.messagesToSend.get(level).add(Util.modifyMessagePair(messagePair, Data.addCharacterPrefix(character, (Player)messagePair.getFirst(), (MutableComponent)messagePair.getSecond())));
            return;
        }
        Scheduler.scheduleCharacterMessage(level, character, Util.modifyMessagePair(messagePair, Data.addCharacterPrefix(character, (Player)messagePair.getFirst(), (MutableComponent)messagePair.getSecond())), msDelay, itemStack, itemStackBehaviour);
    }

    public static void addPostDeathMessage(Level level, Villager character, Player player, String message, ChatFormatting colour) {
        if (message.equals("")) {
            Data.messagesToSend.get(level).add(Conversations.createMessagePair(player, message));
            return;
        }
        Conversations.addPostDeathMessage(level, character, Conversations.createMessagePair(player, message, colour));
    }

    public static void addPostDeathMessage(Level level, Villager character, Pair<Player, MutableComponent> messagePair) {
        Data.messagesToSend.get(level).add(Util.modifyMessagePair(messagePair, Data.addCharacterPrefix(character, (Player)messagePair.getFirst(), (MutableComponent)messagePair.getSecond())));
    }

    public static void addEmptyMessage(Level level, Villager character, Player player, int msDelay) {
        Conversations.addMessageWithoutPrefix(level, character, player, "", ChatFormatting.WHITE, msDelay);
    }

    public static void addMessageWithoutPrefix(Level level, Villager character, Player player, String messageString, ChatFormatting colour, int msDelay) {
        Conversations.addMessageWithoutPrefix(level, character, player, messageString, colour, msDelay, null, "");
    }

    public static void addMessageWithoutPrefix(Level level, Villager character, Player player, MutableComponent component, int msDelay) {
        Conversations.addMessageWithoutPrefix(level, character, player, component, msDelay, null, "");
    }

    public static void addMessageWithoutPrefix(Level level, Villager character, Player player, String messageString, ChatFormatting colour, int msDelay, ItemStack itemStack, String itemStackBehaviour) {
        Pair<Player, MutableComponent> messagePair = Conversations.createMessagePair(player, messageString, colour);
        if (character != null && character.getTags().contains("pumpkillagersquest.iskilled")) {
            return;
        }
        if (msDelay == 0) {
            Data.messagesToSend.get(level).add(messagePair);
            return;
        }
        Scheduler.scheduleCharacterMessage(level, character, messagePair, msDelay, itemStack, itemStackBehaviour);
    }

    public static void addMessageWithoutPrefix(Level level, Villager character, Player player, MutableComponent component, int msDelay, ItemStack itemStack, String itemStackBehaviour) {
        Pair<Player, MutableComponent> messagePair = Conversations.createMessagePair(player, component);
        if (character != null && character.getTags().contains("pumpkillagersquest.iskilled")) {
            return;
        }
        if (msDelay == 0) {
            Data.messagesToSend.get(level).add(messagePair);
            return;
        }
        Scheduler.scheduleCharacterMessage(level, character, messagePair, msDelay, itemStack, itemStackBehaviour);
    }

    public static void sendJaxMessage(Level level, Player player, String message, ChatFormatting colour, int msDelay) {
        Conversations.sendJaxMessage(level, player, message, colour, msDelay, null, "");
    }

    public static void sendJaxMessage(Level level, Player player, String message, ChatFormatting colour, int msDelay, ItemStack itemStack, String itemStackBehaviour) {
        Conversations.addMessageWithoutPrefix(level, null, player, Data.addCharacterPrefix("knownprisoner", player, Component.translatable((String)message).withStyle(colour)), msDelay, itemStack, itemStackBehaviour);
    }

    public static Pair<Player, MutableComponent> createMessagePair(Player player, String message, ChatFormatting colour) {
        return new Pair((Object)player, (Object)Component.translatable((String)message).withStyle(colour));
    }

    public static Pair<Player, MutableComponent> createMessagePair(Player player, MutableComponent component) {
        return new Pair((Object)player, (Object)component);
    }

    public static Pair<Player, MutableComponent> createMessagePair(Player player, String messageString) {
        return new Pair((Object)player, (Object)Component.translatable((String)messageString));
    }
}

