/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.client.components.header;

import com.teamresourceful.resourcefulconfig.api.types.ResourcefulConfig;
import com.teamresourceful.resourcefulconfig.api.types.info.ResourcefulConfigInfoButton;
import com.teamresourceful.resourcefulconfig.api.types.info.ResourcefulConfigLink;
import com.teamresourceful.resourcefulconfig.client.components.ModSprites;
import com.teamresourceful.resourcefulconfig.client.components.base.ContainerWidget;
import com.teamresourceful.resourcefulconfig.client.components.base.SpriteButton;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.MultiLineTextWidget;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.layouts.EqualSpacingLayout;
import net.minecraft.client.gui.layouts.GridLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.ConfirmLinkScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class HeaderContentWidget
extends ContainerWidget {
    private final EqualSpacingLayout layout;

    public HeaderContentWidget(int width, ResourcefulConfig config) {
        super(0, 0, width, 0);
        SpriteButton button;
        Font font = Minecraft.getInstance().font;
        int twoThirds = (int)((float)this.width * 0.6666667f);
        this.layout = new EqualSpacingLayout(this.width - 20, 0, EqualSpacingLayout.Orientation.HORIZONTAL);
        GridLayout links = new GridLayout().spacing(4);
        int maxCols = Math.max(1, (this.width - twoThirds - 10) / 20);
        int col = 0;
        int row = 0;
        for (ResourcefulConfigLink link : config.info().links()) {
            button = SpriteButton.builder(12, 12).padding(2).sprite(ModSprites.ofIcon(link.icon())).onPress(() -> {
                Screen screen = Minecraft.getInstance().screen;
                if (screen == null) {
                    return;
                }
                ConfirmLinkScreen.confirmLinkNow((Screen)screen, (String)link.url());
            }).tooltip((Component)link.text().toComponent()).build();
            links.addChild((LayoutElement)button, row, col);
            if (++col < maxCols) continue;
            col = 0;
            ++row;
        }
        for (ResourcefulConfigInfoButton infoButton : config.info().buttons()) {
            button = SpriteButton.builder(12, 12).padding(2).sprite(ModSprites.ofIcon(infoButton.icon())).onPress(infoButton::onClick).tooltip((Component)infoButton.text().toComponent()).build();
            links.addChild((LayoutElement)button, row, col);
            if (++col < maxCols) continue;
            col = 0;
            ++row;
        }
        links.arrangeElements();
        int textWidth = Math.max(this.width - links.getWidth() - 20, twoThirds);
        LinearLayout titleDesc = LinearLayout.vertical().spacing(4);
        titleDesc.addChild((LayoutElement)new StringWidget(textWidth, 9, (Component)config.info().title().toComponent().withColor(-329226), font));
        MultiLineTextWidget description = (MultiLineTextWidget)titleDesc.addChild((LayoutElement)new MultiLineTextWidget((Component)config.info().description().toComponent().withColor(-9276296), font));
        description.setMaxWidth(textWidth);
        description.setMaxRows(3);
        this.layout.addChild((LayoutElement)titleDesc);
        this.layout.addChild((LayoutElement)links, settings -> settings.alignVerticallyMiddle().alignHorizontallyRight());
        this.layout.arrangeElements();
        this.layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget(x$0);
        });
        this.height = Math.max(22, this.layout.getHeight()) + 20;
    }

    @Override
    public void renderWidget(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.blitSprite(RenderPipelines.GUI_TEXTURED, ModSprites.CONTAINER, this.getX(), this.getY(), this.width, this.height);
        super.renderWidget(graphics, mouseX, mouseY, partialTicks);
    }

    @Override
    protected void positionUpdated() {
        this.layout.setPosition(this.getX() + 10, this.getY() + 10);
    }
}

