/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.client.components.options.types;

import com.teamresourceful.resourcefulconfig.api.annotations.ConfigOption;
import com.teamresourceful.resourcefulconfig.api.types.entries.ResourcefulConfigValueEntry;
import com.teamresourceful.resourcefulconfig.api.types.options.EntryData;
import com.teamresourceful.resourcefulconfig.api.types.options.Option;
import com.teamresourceful.resourcefulconfig.api.types.options.data.DraggableOptionEntry;
import com.teamresourceful.resourcefulconfig.client.UIConstants;
import com.teamresourceful.resourcefulconfig.client.components.ModSprites;
import com.teamresourceful.resourcefulconfig.client.components.base.BaseWidget;
import com.teamresourceful.resourcefulconfig.client.components.options.misc.draggable.DraggableList;
import com.teamresourceful.resourcefulconfig.client.components.options.types.DropdownWidget;
import com.teamresourceful.resourcefulconfig.client.screens.base.ModalOverlay;
import com.teamresourceful.resourcefulconfig.common.utils.ModUtils;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.EqualSpacingLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.jetbrains.annotations.NotNull;

public class DraggableListOptionWidget<T>
extends BaseWidget {
    private static final int WIDTH = 80;
    private static final int SIZE = 12;
    private static final int SPACING = 4;
    private static final int PADDING = 2;
    private final Component title;
    private final List<DraggableOptionEntry<T>> options;
    private final Supplier<List<T>> getter;
    private final Consumer<List<T>> setter;
    private final IntIntPair range;

    public DraggableListOptionWidget(Component title, List<DraggableOptionEntry<T>> options, Supplier<List<T>> getter, Consumer<List<T>> setter, IntIntPair range) {
        super(80, 16);
        this.title = title;
        this.options = options;
        this.getter = getter;
        this.setter = setter;
        this.range = range == null ? null : IntIntPair.of((int)range.firstInt(), (int)range.secondInt());
    }

    public static DraggableListOptionWidget<Enum<?>> of(ResourcefulConfigValueEntry entry, EntryData data) {
        ConfigOption.Range range = data.getOption(Option.RANGE);
        ArrayList entries = new ArrayList();
        Set<Enum> duplicates = Set.of(data.getOrDefaultOption(Option.DRAGGABLE, new Enum[0]));
        for (Enum<?> e : ModUtils.getEnumConstants(entry.objectType())) {
            entries.add(new DraggableOptionEntry(e, duplicates.contains(e)));
        }
        return new DraggableListOptionWidget((Component)entry.options().title().toComponent(), entries, () -> Arrays.asList((Enum[])entry.getArray()), value -> {
            Object[] array = (Enum[])Array.newInstance(entry.objectType(), value.size());
            for (int i = 0; i < value.size(); ++i) {
                array[i] = (Enum)value.get(i);
            }
            entry.setArray(array);
        }, range == null ? null : IntIntPair.of((int)((int)range.min()), (int)((int)range.max())));
    }

    @Override
    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.blitSprite(RenderPipelines.GUI_TEXTURED, ModSprites.ofButton(this.isHovered()), this.getX(), this.getY(), this.getWidth(), this.getHeight());
        int contentWidth = this.font.width((FormattedText)UIConstants.EDIT) + 4 + 12;
        graphics.blitSprite(RenderPipelines.GUI_TEXTURED, ModSprites.EDIT, this.getX() + (this.getWidth() - contentWidth) / 2, this.getY() + 2, 12, 12);
        int n = this.getX() + (this.getWidth() - contentWidth) / 2 + 12 + 4;
        int n2 = this.getY();
        int n3 = this.getHeight();
        Objects.requireNonNull(this.font);
        graphics.drawString(this.font, UIConstants.EDIT, n, n2 + (n3 - 9) / 2 + 1, -329226);
    }

    public void onClick(@NotNull MouseButtonEvent event, boolean bl) {
        new DraggableListOverlay(this).open();
    }

    private static class DraggableListOverlay<T>
    extends ModalOverlay {
        private final DraggableListOptionWidget<T> widget;

        protected DraggableListOverlay(DraggableListOptionWidget<T> widget) {
            this.widget = widget;
            this.title = UIConstants.EDIT_LIST;
        }

        protected List<T> getOptions() {
            HashSet chosen = new HashSet(this.widget.getter.get());
            ArrayList options = new ArrayList();
            for (DraggableOptionEntry option : this.widget.options) {
                if (chosen.contains(option.value()) && !option.duplicatable()) continue;
                options.add(option.value());
            }
            return options;
        }

        @Override
        protected void init() {
            super.init();
            EqualSpacingLayout layout = new EqualSpacingLayout(this.contentWidth, 16, EqualSpacingLayout.Orientation.HORIZONTAL);
            StringWidget title = (StringWidget)layout.addChild((LayoutElement)new StringWidget(this.contentWidth - 84, 16, (Component)Component.empty(), this.font));
            Runnable updateTitle = () -> {
                if (this.widget.range != null) {
                    String count = "%d/%d".formatted(this.widget.getter.get().size(), this.widget.range.secondInt());
                    title.setMessage((Component)Component.empty().append(this.widget.title).append(" ").append(count));
                } else {
                    title.setMessage(this.widget.title);
                }
            };
            updateTitle.run();
            DropdownWidget dropdown = (DropdownWidget)layout.addChild(new DropdownWidget<Object>(UIConstants.ADD_ITEM, this.getOptions(), () -> null, value -> {
                ArrayList<Object> list = new ArrayList<Object>(this.widget.getter.get());
                list.addFirst(value);
                this.widget.setter.accept(list);
            }));
            dropdown.setWidth(84);
            dropdown.active = this.widget.range == null || this.widget.getter.get().size() < this.widget.range.secondInt();
            layout.setPosition(this.left, this.top + 1);
            layout.arrangeElements();
            layout.visitWidgets(x$0 -> {
                AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
            });
            int heading = layout.getHeight() + 4;
            DraggableList list = (DraggableList)this.addRenderableWidget((GuiEventListener)new DraggableList(this.left + 1, this.top + heading, this.contentWidth - 2, this.contentHeight - heading));
            list.addAll(this.widget.getter.get());
            list.setOnUpdate(value -> {
                this.widget.setter.accept((List<List>)value);
                list.setCanDelete(this.widget.range == null || this.widget.getter.get().size() > this.widget.range.firstInt());
                dropdown.active = this.widget.range == null || this.widget.getter.get().size() < this.widget.range.secondInt();
                dropdown.setOptions(this.getOptions());
                updateTitle.run();
            });
            list.setCanDelete(this.widget.range == null || this.widget.getter.get().size() > this.widget.range.firstInt());
        }

        @Override
        public void renderBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            super.renderBackground(graphics, mouseX, mouseY, partialTicks);
            graphics.blitSprite(RenderPipelines.GUI_TEXTURED, ModSprites.BUTTON, this.left, this.top + 20, this.contentWidth, this.contentHeight - 20);
        }
    }
}

