/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.client.components.options.types;

import com.teamresourceful.resourcefulconfig.api.types.info.Translatable;
import com.teamresourceful.resourcefulconfig.client.components.ModSprites;
import com.teamresourceful.resourcefulconfig.client.components.base.BaseWidget;
import com.teamresourceful.resourcefulconfig.client.components.base.ListWidget;
import com.teamresourceful.resourcefulconfig.client.screens.base.OverlayScreen;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class DropdownWidget<T>
extends BaseWidget {
    private static final int MIN_WIDTH = 80;
    private static final int MAX_WIDTH = 160;
    private final Component title;
    private final Supplier<T> getter;
    private final Consumer<T> setter;
    private List<T> options;

    public DropdownWidget(Component title, List<T> options, Supplier<T> getter, Consumer<T> setter) {
        super(80, 16);
        this.title = title;
        this.options = List.copyOf(options);
        this.getter = getter;
        this.setter = setter;
    }

    public DropdownWidget<T> setOptions(List<T> options) {
        this.options = options;
        return this;
    }

    @Override
    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.blitSprite(RenderPipelines.GUI_TEXTURED, ModSprites.ofButton(this.isHovered()), this.getX(), this.getY(), this.getWidth(), this.getHeight());
        graphics.textRendererForWidget((AbstractWidget)this, GuiGraphics.HoveredTextEffects.NONE).acceptScrollingWithDefaultCenter((Component)Translatable.toComponent(this.getter.get(), this.title).copy().withColor(-9276296), this.getX() + 4, this.getX() + this.getWidth() - 16, this.getY() + 4, this.getY() + this.getHeight() - 4);
        graphics.blitSprite(RenderPipelines.GUI_TEXTURED, ModSprites.CHEVRON_DOWN, this.getX() + this.getWidth() - 12, this.getY() + 4, 8, 8);
        this.applyCursor(graphics);
    }

    public void onClick(@NotNull MouseButtonEvent event, boolean bl) {
        Minecraft.getInstance().setScreen(new DropdownOverlay(this));
    }

    private static class DropdownOverlay<T>
    extends OverlayScreen {
        private final DropdownWidget<T> widget;

        protected DropdownOverlay(DropdownWidget<T> widget) {
            super(Minecraft.getInstance().screen);
            this.widget = widget;
        }

        @Override
        protected void init() {
            DropdownList list = (DropdownList)this.addRenderableWidget((GuiEventListener)DropdownList.of(this.widget));
            for (Object option : this.widget.options) {
                list.add(new DropdownItem(option, () -> {
                    this.widget.setter.accept(option);
                    this.onClose();
                }));
            }
        }

        public boolean mouseClicked(MouseButtonEvent event, boolean bl) {
            if (this.getChildAt(event.x(), event.y()).isEmpty()) {
                this.onClose();
                return true;
            }
            return super.mouseClicked(event, bl);
        }
    }

    private static class DropdownItem
    extends BaseWidget
    implements ListWidget.Item {
        private final Object option;
        private final Runnable onClick;

        public DropdownItem(Object option, Runnable setter) {
            super(80, 12);
            this.option = option;
            this.onClick = setter;
        }

        public int effectiveWidth() {
            return Mth.clamp((int)(Minecraft.getInstance().font.width((FormattedText)Translatable.toComponent(this.option)) + 8), (int)80, (int)160);
        }

        @Override
        protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            graphics.blitSprite(RenderPipelines.GUI_TEXTURED, ModSprites.ofButton(this.isHovered()), this.getX() + 1, this.getY(), this.getWidth() - 1, this.getHeight());
            int color = this.isHovered() ? -329226 : -9276296;
            graphics.textRendererForWidget((AbstractWidget)this, GuiGraphics.HoveredTextEffects.NONE).acceptScrollingWithDefaultCenter((Component)Translatable.toComponent(this.option).copy().withColor(color), this.getX() + 4, this.getX() + this.getWidth() - 16, this.getY() + 1, this.getY() + this.getHeight() - 1);
            this.applyCursor(graphics);
        }

        public void onClick(@NotNull MouseButtonEvent event, boolean bl) {
            this.onClick.run();
        }

        @Override
        public void setItemWidth(int width) {
            this.setWidth(width);
        }
    }

    private static class DropdownList
    extends ListWidget {
        private final int ogX;

        public DropdownList(int x, int y, int height) {
            super(x + 1, y, 78, height);
            this.ogX = x;
        }

        public static <T> DropdownList of(DropdownWidget<T> widget) {
            int listHeight;
            int windowHeight = Minecraft.getInstance().getWindow().getGuiScaledHeight();
            int widgetY = widget.getY() + widget.getHeight();
            if (widgetY + (listHeight = Math.min(widget.options.size() * 12, 96) + 1) > windowHeight) {
                widgetY = widget.getY() - listHeight - 1;
            }
            return new DropdownList(widget.getX(), widgetY, listHeight);
        }

        @Override
        public void add(ListWidget.Item item) {
            int addition;
            super.add(item);
            if (!(item instanceof DropdownItem)) {
                return;
            }
            DropdownItem it = (DropdownItem)item;
            int n = addition = this.items.size() * 12 > this.height ? 10 : 0;
            if (it.effectiveWidth() + addition <= this.width) {
                return;
            }
            this.setWidth(Math.min(it.effectiveWidth() + addition, 160));
            this.setX(this.ogX - (this.width - 80) - 1);
        }

        @Override
        public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            graphics.blitSprite(RenderPipelines.GUI_TEXTURED, ModSprites.ACCENT, this.getX() - 1, this.getY() - 1, this.getWidth() + 2, this.getHeight() + 2);
            graphics.blitSprite(RenderPipelines.GUI_TEXTURED, ModSprites.BUTTON, this.getX(), this.getY(), this.getWidth(), this.getHeight());
            super.renderWidget(graphics, mouseX, mouseY, partialTicks);
        }
    }
}

