/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.client.screens.base;

import com.teamresourceful.resourcefulconfig.client.components.ModSprites;
import com.teamresourceful.resourcefulconfig.client.components.base.SpriteButton;
import com.teamresourceful.resourcefulconfig.client.screens.base.OverlayScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.EqualSpacingLayout;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LayoutSettings;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.NotNull;

public class ModalOverlay
extends OverlayScreen {
    protected static final int PADDING = 10;
    protected int modalWidth = 0;
    protected int modalHeight = 0;
    protected int modalLeft = 0;
    protected int modalTop = 0;
    protected int contentWidth = 0;
    protected int contentHeight = 0;
    protected int left = 0;
    protected int top = 0;
    protected Component title = CommonComponents.EMPTY;

    protected ModalOverlay() {
        super(Minecraft.getInstance().screen);
    }

    @Override
    protected void init() {
        this.modalWidth = (int)((double)this.width * 0.6);
        this.modalHeight = (int)((double)this.height * 0.8);
        this.modalLeft = (this.width - this.modalWidth) / 2;
        this.modalTop = (this.height - this.modalHeight) / 2;
        EqualSpacingLayout header = new EqualSpacingLayout(this.modalWidth - 20, 20, EqualSpacingLayout.Orientation.HORIZONTAL);
        header.addChild((LayoutElement)new StringWidget(this.title, this.font), LayoutSettings::alignVerticallyMiddle);
        header.addChild((LayoutElement)SpriteButton.builder(12, 12).sprite(ModSprites.CROSS).padding(2).tooltip(CommonComponents.GUI_CANCEL).onPress(this::onClose).build(), settings -> settings.alignVerticallyMiddle().alignHorizontallyRight());
        this.contentWidth = this.modalWidth;
        this.contentHeight = this.modalHeight;
        this.left = this.modalLeft;
        this.top = this.modalTop;
        header.arrangeElements();
        header.setPosition(this.left + 10, this.top + 10);
        header.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
        this.contentHeight -= header.getHeight() + 40;
        this.contentWidth -= 20;
        this.top += header.getHeight() + 30;
        this.left += 10;
    }

    @Override
    public void renderBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderBackground(graphics, mouseX, mouseY, partialTicks);
        this.renderTransparentBackground(graphics);
        graphics.blitSprite(RenderPipelines.GUI_TEXTURED, ModSprites.CONTAINER, this.modalLeft, this.modalTop, this.modalWidth, this.modalHeight);
        graphics.blitSprite(RenderPipelines.GUI_TEXTURED, ModSprites.HEADER, this.modalLeft, this.modalTop, this.modalWidth, 40);
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean bl) {
        if (event.x() < (double)this.modalLeft || event.x() > (double)(this.modalLeft + this.modalWidth) || event.y() < (double)this.modalTop || event.y() > (double)(this.modalTop + this.modalHeight)) {
            this.onClose();
            return true;
        }
        return super.mouseClicked(event, bl);
    }

    public void open() {
        Minecraft.getInstance().setScreen((Screen)this);
    }
}

