/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.api.types.elements;

import com.teamresourceful.resourcefulconfig.api.types.ResourcefulConfigElement;
import com.teamresourceful.resourcefulconfig.api.types.entries.ResourcefulConfigEntry;
import com.teamresourceful.resourcefulconfig.api.types.options.Option;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.resources.Identifier;

public interface ResourcefulConfigEntryElement
extends ResourcefulConfigElement {
    public String id();

    public ResourcefulConfigEntry entry();

    @Override
    default public Identifier renderer() {
        return this.entry().options().getOrDefaultOption(Option.RENDERER, null);
    }

    @Override
    default public boolean search(Predicate<String> predicate) {
        String title = this.entry().options().title().toLocalizedString();
        String description = this.entry().options().comment().toLocalizedString();
        for (String term : this.entry().options().getOrDefaultOption(Option.SEARCH_TERM, List.of())) {
            if (!predicate.test(term)) continue;
            return true;
        }
        return predicate.test(title) || predicate.test(description);
    }

    @Override
    default public boolean isHidden() {
        return this.entry().options().hasOption(Option.HIDDEN);
    }
}

