/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.client;

import com.teamresourceful.resourcefulconfig.api.types.ResourcefulConfig;
import com.teamresourceful.resourcefulconfig.api.types.ResourcefulConfigElement;
import com.teamresourceful.resourcefulconfig.client.ConfigScreenContext;
import com.teamresourceful.resourcefulconfig.client.components.categories.CategoriesListWidget;
import com.teamresourceful.resourcefulconfig.client.components.categories.CategoryItem;
import com.teamresourceful.resourcefulconfig.client.components.header.HeaderWidget;
import com.teamresourceful.resourcefulconfig.client.components.options.Options;
import com.teamresourceful.resourcefulconfig.client.components.options.OptionsListWidget;
import com.teamresourceful.resourcefulconfig.client.components.options.types.StringOptionWidget;
import com.teamresourceful.resourcefulconfig.client.screens.base.CloseableScreen;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.layouts.LayoutElement;
import net.minecraft.client.gui.layouts.LinearLayout;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.CommonComponents;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ConfigScreen
extends Screen
implements CloseableScreen {
    private final Screen parent;
    private final ResourcefulConfig config;
    private final ConfigScreenContext context;
    private OptionsListWidget optionsList = null;
    private CategoriesListWidget categoriesList = null;
    private StringOptionWidget searchWidget = null;

    public ConfigScreen(Screen parent, ResourcefulConfig config) {
        this(parent, config, new ConfigScreenContext());
    }

    public ConfigScreen(Screen parent, ResourcefulConfig config, ConfigScreenContext context) {
        super(CommonComponents.EMPTY);
        this.parent = parent;
        this.config = config;
        this.context = context;
    }

    protected void rebuildWidgets() {
        OptionsListWidget oldList = this.optionsList;
        super.rebuildWidgets();
        this.optionsList.update(oldList);
    }

    protected void init() {
        boolean categoriesEmpty;
        int contentWidth = this.width - 20;
        int contentHeight = this.height - 20;
        int optionsWidth = contentWidth;
        LinearLayout layout = LinearLayout.vertical().spacing(10);
        HeaderWidget header = (HeaderWidget)layout.addChild((LayoutElement)new HeaderWidget(this.width - 20, this.config, this.context, () -> {
            this.updateOptions();
            this.updateCategories();
        }));
        this.searchWidget = header.getSearchWidget();
        contentHeight -= header.getHeight() + 10;
        LinearLayout body = (LinearLayout)layout.addChild((LayoutElement)LinearLayout.horizontal().spacing(10));
        boolean bl = categoriesEmpty = this.config.categories().isEmpty() || this.config.categories().values().stream().allMatch(it -> it.info().isHidden());
        if (!categoriesEmpty) {
            int categoryWidth = contentWidth / 4;
            this.categoriesList = (CategoriesListWidget)body.addChild((LayoutElement)new CategoriesListWidget(categoryWidth, contentHeight));
            this.updateCategories();
            optionsWidth = contentWidth - categoryWidth - 10;
        }
        this.optionsList = (OptionsListWidget)body.addChild((LayoutElement)new OptionsListWidget(optionsWidth, contentHeight));
        this.updateOptions();
        layout.arrangeElements();
        layout.setPosition(10, 10);
        layout.visitWidgets(x$0 -> {
            AbstractWidget cfr_ignored_0 = (AbstractWidget)this.addRenderableWidget((GuiEventListener)x$0);
        });
    }

    public void updateOptions() {
        this.optionsList.clear();
        ArrayList<ResourcefulConfigElement> elements = new ArrayList<ResourcefulConfigElement>();
        for (ResourcefulConfigElement element : this.config.elements()) {
            if (!this.context.fulfillsSearch(element)) continue;
            elements.add(element);
        }
        Options.populateOptions(this.optionsList, elements);
    }

    public void updateCategories() {
        if (this.categoriesList == null) {
            return;
        }
        this.categoriesList.clear();
        for (ResourcefulConfig value : this.config.categories().values()) {
            if (!this.context.fulfillsSearch(value) || value.info().isHidden()) continue;
            this.categoriesList.add(new CategoryItem(this, value, this.context));
        }
    }

    public void renderBackground(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.fill(0, 0, this.width, this.height, -15526633);
    }

    public boolean mouseClicked(@NotNull MouseButtonEvent event, boolean bl) {
        if (this.getChildAt(event.x(), event.y()).isEmpty()) {
            this.setFocused(null);
            return false;
        }
        return super.mouseClicked(event, bl);
    }

    public boolean keyPressed(@NotNull KeyEvent event) {
        if (event.hasControlDown() && event.input() == 70 && this.searchWidget != null) {
            this.setFocused((GuiEventListener)this.searchWidget);
            this.searchWidget.setFocused(true);
            return true;
        }
        if (super.keyPressed(event)) {
            return true;
        }
        if (event.input() == 256) {
            this.onClose();
            return true;
        }
        return false;
    }

    public boolean shouldCloseOnEsc() {
        return false;
    }

    @Override
    public void onClosed(@Nullable Screen screen) {
        boolean shouldSave;
        boolean bl = shouldSave = screen == null || screen == this.parent && !(this.parent instanceof ConfigScreen);
        if (shouldSave) {
            this.config.save();
        }
    }

    public void onClose() {
        Minecraft.getInstance().setScreen(this.parent);
    }
}

