/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.client.components.options.misc.draggable;

import com.teamresourceful.resourcefulconfig.api.types.info.TooltipProvider;
import com.teamresourceful.resourcefulconfig.api.types.info.Translatable;
import com.teamresourceful.resourcefulconfig.client.components.ModSprites;
import com.teamresourceful.resourcefulconfig.client.components.base.BaseWidget;
import com.teamresourceful.resourcefulconfig.client.components.base.ListWidget;
import com.teamresourceful.resourcefulconfig.client.components.options.misc.draggable.DraggableList;
import net.minecraft.client.gui.ActiveTextCollector;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.ARGB;
import org.jetbrains.annotations.NotNull;

public class DraggableItem<T>
extends BaseWidget
implements ListWidget.Item {
    private static final int HEIGHT = 16;
    private final DraggableList<T> list;
    private final T value;
    private final Runnable remove;

    public DraggableItem(int width, DraggableList<T> list, T value, Runnable remove) {
        super(width, 16);
        this.list = list;
        this.value = value;
        this.remove = remove;
    }

    public void render(GuiGraphics graphics, int x, int y, int mouseX, int mouseY, int flags) {
        boolean hovered = (flags & 1) != 0;
        boolean dragging = (flags & 2) != 0;
        boolean canDelete = (flags & 4) != 0;
        boolean fadeOut = (flags & 8) != 0;
        graphics.blitSprite(RenderPipelines.GUI_TEXTURED, ModSprites.ofButton(hovered && !dragging), x, y, this.getWidth(), this.getHeight(), fadeOut ? -2130706433 : -1);
        if (!dragging && hovered) {
            graphics.blitSprite(RenderPipelines.GUI_TEXTURED, ModSprites.DRAGGABLE, x + 4, y + 4, 8, 8, fadeOut ? -2130706433 : -1);
        }
        if (!dragging && hovered) {
            TooltipProvider provider;
            T t;
            boolean hoveringDelete;
            boolean bl = hoveringDelete = x + this.getWidth() - 16 <= mouseX;
            if (canDelete) {
                graphics.blitSprite(RenderPipelines.GUI_TEXTURED, ModSprites.DELETE, x + this.getWidth() - 12, y + 4, 8, 8, fadeOut ? -2130706433 : -1);
                if (this.minecraft.screen != null && hoveringDelete) {
                    graphics.setTooltipForNextFrame((Component)Component.literal((String)"Remove"), mouseX, mouseY);
                }
            }
            if (!hoveringDelete && this.minecraft.screen != null && (t = this.value) instanceof TooltipProvider && (provider = (TooltipProvider)t).getTooltip() != null && !provider.getTooltip().getString().isBlank()) {
                Font font = this.minecraft.font;
                graphics.setTooltipForNextFrame(font, font.split((FormattedText)provider.getTooltip(), Integer.MAX_VALUE), mouseX, mouseY);
            }
            this.applyCursor(graphics);
        }
        int color = hovered ? -329226 : -9276296;
        int left = x + 16;
        int right = x + this.getWidth() - 32;
        ActiveTextCollector renderer = graphics.textRendererForWidget((AbstractWidget)this, GuiGraphics.HoveredTextEffects.NONE);
        renderer.acceptScrolling((Component)Translatable.toComponent(this.value).copy().withColor(fadeOut ? ARGB.color((int)128, (int)color) : color), (left + right) / 2, left, right, y + 1, y + this.getHeight() - 1, renderer.defaultParameters().withOpacity(fadeOut ? 128.0f : (float)color));
    }

    @Override
    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.list.isDraggingItem() && this.list.getDraggingItem() == this) {
            graphics.blitSprite(RenderPipelines.GUI_TEXTURED, ModSprites.ofButton(true), this.getX() + 1, this.getY(), this.getWidth() - 1, this.getHeight());
        } else {
            int flags = 0;
            if (this.isHovered()) {
                flags |= 1;
            }
            if (this.list.isDraggingItem()) {
                flags |= 2;
            }
            if (this.list.canDelete()) {
                flags |= 4;
            }
            this.render(graphics, this.getX(), this.getY(), mouseX, mouseY, flags);
        }
    }

    public boolean mouseClicked(@NotNull MouseButtonEvent event, boolean bl) {
        if (this.isHovered() && event.button() == 0 && event.x() >= (double)(this.getX() + this.getWidth() - 16)) {
            this.remove.run();
            return true;
        }
        return false;
    }

    @Override
    public void setItemWidth(int width) {
        this.setWidth(width);
    }

    public T value() {
        return this.value;
    }
}

