/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.client.components.options.misc.draggable;

import com.teamresourceful.resourcefulconfig.client.components.base.ListWidget;
import com.teamresourceful.resourcefulconfig.client.components.options.misc.draggable.DraggableItem;
import com.teamresourceful.resourcefulconfig.client.utils.KeyCodeHelper;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.input.MouseButtonEvent;
import org.jetbrains.annotations.NotNull;
import org.joml.Vector2d;

public class DraggableList<T>
extends ListWidget {
    private final Vector2d draggingOffset = new Vector2d();
    private int draggingIndex = -1;
    private Consumer<List<T>> onUpdate = value -> {};
    private boolean canDelete = true;

    public DraggableList(int x, int y, int width, int height) {
        super(x, y, width, height);
    }

    public void setOnUpdate(Consumer<List<T>> onUpdate) {
        this.onUpdate = onUpdate;
    }

    public void setCanDelete(boolean canDelete) {
        this.canDelete = canDelete;
    }

    public boolean canDelete() {
        return this.canDelete;
    }

    public void addAll(List<T> values) {
        this.items.clear();
        for (T value : values) {
            AtomicReference<DraggableItem<T>> item = new AtomicReference<DraggableItem<T>>();
            item.set(new DraggableItem<T>(this.width, this, value, () -> {
                this.items.remove(item.get());
                this.onUpdate.accept(this.items.stream().map(i -> (DraggableItem)i).map(DraggableItem::value).toList());
                this.updateScrollBar();
            }));
            this.items.add((ListWidget.Item)item.get());
        }
        this.updateLastHeight();
    }

    @Override
    @Deprecated
    public void add(ListWidget.Item item) {
        throw new UnsupportedOperationException("Use addAll(T value) instead.");
    }

    @Override
    public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.renderWidget(graphics, mouseX, mouseY, partialTicks);
        if (!this.isMouseOver(mouseX, mouseY) && this.draggingIndex != -1 && !KeyCodeHelper.isMouseKeyPressed(0)) {
            this.draggingIndex = -1;
        }
        graphics.enableScissor(this.getX(), this.getY(), this.getX() + this.width, this.getY() + this.height);
        this.renderPossiblePositionLine(graphics, mouseX, mouseY);
        graphics.disableScissor();
        this.renderDraggedItem(graphics, mouseX, mouseY);
    }

    private void renderPossiblePositionLine(GuiGraphics graphics, int mouseX, int mouseY) {
        if (this.draggingIndex == -1) {
            return;
        }
        int hoveredIndex = this.getItemOver(mouseX, mouseY);
        if (hoveredIndex != this.draggingIndex && hoveredIndex != -1) {
            ListWidget.Item hoveredItem = (ListWidget.Item)this.items.get(hoveredIndex);
            boolean isAbove = hoveredIndex < this.draggingIndex;
            int y = hoveredItem.getY() + (isAbove ? -1 : hoveredItem.getHeight() - 1);
            graphics.fill(hoveredItem.getX(), y, hoveredItem.getX() + hoveredItem.getWidth(), y + 2, -11141291);
        }
    }

    private void renderDraggedItem(GuiGraphics graphics, int mouseX, int mouseY) {
        if (this.draggingIndex == -1) {
            return;
        }
        ListWidget.Item item = (ListWidget.Item)this.items.get(this.draggingIndex);
        if (!(item instanceof DraggableItem)) {
            return;
        }
        DraggableItem draggableItem = (DraggableItem)item;
        graphics.nextStratum();
        int x = (int)((double)mouseX - this.draggingOffset.x);
        int y = (int)((double)mouseY - this.draggingOffset.y);
        draggableItem.render(graphics, x, y, mouseX, mouseY, 9);
    }

    public int getItemOver(double mouseX, double mouseY) {
        for (int i = 0; i < this.items.size(); ++i) {
            if (!((ListWidget.Item)this.items.get(i)).isMouseOver(mouseX, mouseY)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean mouseClicked(@NotNull MouseButtonEvent event, boolean bl) {
        if (super.mouseClicked(event, bl)) {
            return true;
        }
        if (event.input() == 0) {
            this.draggingIndex = this.getItemOver(event.x(), event.y());
            if (this.draggingIndex != -1) {
                ListWidget.Item item = (ListWidget.Item)this.items.get(this.draggingIndex);
                this.draggingOffset.set(event.x() - (double)item.getX(), event.y() - (double)item.getY());
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean mouseReleased(@NotNull MouseButtonEvent event) {
        if (event.input() == 0 && this.draggingIndex != -1) {
            int newIndex = this.getItemOver(event.x(), event.y());
            if (newIndex != -1 && newIndex != this.draggingIndex) {
                this.items.add(newIndex, (ListWidget.Item)this.items.remove(this.draggingIndex));
                this.onUpdate.accept(this.items.stream().map(item -> (DraggableItem)item).map(DraggableItem::value).toList());
            }
            this.draggingIndex = -1;
        }
        return super.mouseReleased(event);
    }

    public boolean isDraggingItem() {
        return this.draggingIndex != -1;
    }

    public ListWidget.Item getDraggingItem() {
        return this.draggingIndex != -1 ? (ListWidget.Item)this.items.get(this.draggingIndex) : null;
    }
}

