/*
 * Decompiled with CFR 0.152.
 */
package com.teamresourceful.resourcefulconfig.client.components.options.types;

import com.teamresourceful.resourcefulconfig.api.types.info.Translatable;
import com.teamresourceful.resourcefulconfig.client.components.ModSprites;
import com.teamresourceful.resourcefulconfig.client.components.base.BaseWidget;
import com.teamresourceful.resourcefulconfig.client.components.base.ListWidget;
import com.teamresourceful.resourcefulconfig.client.screens.base.OverlayScreen;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.renderer.RenderPipelines;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;

public class SelectWidget<T>
extends BaseWidget {
    private static final int MIN_WIDTH = 80;
    private static final int MAX_WIDTH = 160;
    private final Component heading;
    private final List<T> options;
    private final Supplier<List<T>> getter;
    private final Consumer<List<T>> setter;

    public SelectWidget(Component heading, List<T> options, Supplier<List<T>> getter, Consumer<List<T>> setter) {
        super(80, 16);
        this.heading = heading;
        this.options = options;
        this.getter = getter;
        this.setter = setter;
    }

    @Override
    protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        graphics.blitSprite(RenderPipelines.GUI_TEXTURED, ModSprites.ofButton(this.isHovered()), this.getX(), this.getY(), this.getWidth(), this.getHeight());
        graphics.textRendererForWidget((AbstractWidget)this, GuiGraphics.HoveredTextEffects.NONE).acceptScrollingWithDefaultCenter((Component)this.heading.copy().withColor(-9276296), this.getX() + 4, this.getX() + this.getWidth() - 16, this.getY() + 4, this.getY() + this.getHeight() - 4);
        graphics.blitSprite(RenderPipelines.GUI_TEXTURED, ModSprites.CHEVRON_DOWN, this.getX() + this.getWidth() - 12, this.getY() + 4, 8, 8);
        this.applyCursor(graphics);
    }

    public void onClick(MouseButtonEvent event, boolean bl) {
        Minecraft.getInstance().setScreen(new SelectOverlay(this));
    }

    private static class SelectOverlay<T>
    extends OverlayScreen {
        private final SelectWidget<T> widget;

        protected SelectOverlay(SelectWidget<T> widget) {
            super(Minecraft.getInstance().screen);
            this.widget = widget;
        }

        @Override
        protected void init() {
            SelectList list = (SelectList)this.addRenderableWidget((GuiEventListener)SelectList.of(this.widget));
            for (Object option : this.widget.options) {
                list.add(new SelectItem(option, () -> {
                    Set set = Set.copyOf(this.widget.getter.get());
                    return set.contains(option);
                }, () -> {
                    HashSet<Object> set = new HashSet<Object>(this.widget.getter.get());
                    if (set.contains(option)) {
                        set.remove(option);
                    } else {
                        set.add(option);
                    }
                    this.widget.setter.accept(List.copyOf(set));
                }));
            }
        }

        public boolean mouseClicked(@NotNull MouseButtonEvent event, boolean bl) {
            if (this.getChildAt(event.x(), event.y()).isEmpty()) {
                this.onClose();
                return true;
            }
            return super.mouseClicked(event, bl);
        }
    }

    private static class SelectItem
    extends BaseWidget
    implements ListWidget.Item {
        private final Object option;
        private final BooleanSupplier selected;
        private final Runnable onClick;

        public SelectItem(Object option, BooleanSupplier selected, Runnable onClick) {
            super(80, 12);
            this.option = option;
            this.selected = selected;
            this.onClick = onClick;
        }

        public int effectiveWidth() {
            return Mth.clamp((int)(Minecraft.getInstance().font.width((FormattedText)Translatable.toComponent(this.option)) + 20), (int)80, (int)160);
        }

        @Override
        protected void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            graphics.blitSprite(RenderPipelines.GUI_TEXTURED, ModSprites.ofButton(this.isHovered()), this.getX() + 1, this.getY(), this.getWidth() - 1, this.getHeight());
            if (this.selected.getAsBoolean()) {
                graphics.blitSprite(RenderPipelines.GUI_TEXTURED, ModSprites.CHECK, this.getX() + 4, this.getY() + 2, 8, 8);
            }
            int color = this.isHovered() ? -329226 : -9276296;
            graphics.textRendererForWidget((AbstractWidget)this, GuiGraphics.HoveredTextEffects.NONE).acceptScrollingWithDefaultCenter((Component)Translatable.toComponent(this.option).copy().withColor(color), this.getX() + 16, this.getX() + this.getWidth() - 4, this.getY() + 1, this.getY() + this.getHeight() - 1);
            this.applyCursor(graphics);
        }

        public void onClick(@NotNull MouseButtonEvent event, boolean bl) {
            this.onClick.run();
        }

        @Override
        public void setItemWidth(int width) {
            this.setWidth(width);
        }
    }

    private static class SelectList
    extends ListWidget {
        private final int ogX;

        public SelectList(int x, int y, int height) {
            super(x + 1, y, 78, height);
            this.ogX = x;
        }

        public static SelectList of(SelectWidget<?> widget) {
            int listHeight;
            int windowHeight = Minecraft.getInstance().getWindow().getGuiScaledHeight();
            int widgetY = widget.getY() + widget.getHeight();
            if (widgetY + (listHeight = Math.min(widget.options.size() * 12, 96) + 1) > windowHeight) {
                widgetY = widget.getY() - listHeight - 1;
            }
            return new SelectList(widget.getX(), widgetY, listHeight);
        }

        @Override
        public void add(ListWidget.Item item) {
            int addition;
            super.add(item);
            if (!(item instanceof SelectItem)) {
                return;
            }
            SelectItem it = (SelectItem)item;
            int n = addition = this.items.size() * 12 > this.height ? 10 : 0;
            if (it.effectiveWidth() + addition <= this.width) {
                return;
            }
            this.setWidth(Math.min(it.effectiveWidth() + addition, 160));
            this.setX(this.ogX - (this.width - 80) - 1);
        }

        @Override
        public void renderWidget(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            graphics.blitSprite(RenderPipelines.GUI_TEXTURED, ModSprites.ACCENT, this.getX() - 1, this.getY() - 1, this.getWidth() + 2, this.getHeight() + 2);
            graphics.blitSprite(RenderPipelines.GUI_TEXTURED, ModSprites.BUTTON, this.getX(), this.getY(), this.getWidth(), this.getHeight());
            super.renderWidget(graphics, mouseX, mouseY, partialTicks);
        }
    }
}

